/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.factories;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentObserverRegistrar;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.sharedUI.BoundToOfferingExtensionFactory;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.ui.extensions.AbstractAgentWizardPage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class WizardPageFactory
extends BoundToOfferingExtensionFactory {
    private static final String TAG_WIZARD_PAGES = "wizardPages";
    private static WizardPageFactory instance = new WizardPageFactory();

    public static WizardPageFactory getInstance() {
        return instance;
    }

    public AbstractAgentWizardPage[] createExtensionPages(WizardType type, AgentJob[] jobs) throws CoreException {
        IExtension[] extensions;
        LinkedHashMap wizardExtensions = new LinkedHashMap();
        HashMap offeringBindings = new HashMap();
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_WIZARD_PAGES).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseDefinitions(extension, type, wizardExtensions, offeringBindings);
            ++n2;
        }
        LinkedList pages = new LinkedList();
        for (WizardPageExtension wizardExtension : wizardExtensions.values()) {
            boolean boundToOfferings = this.setupJobsForWizardExtensions(wizardExtension, offeringBindings, jobs);
            pages.addAll(this.createWizardPages(wizardExtension, boundToOfferings));
        }
        return pages.toArray(new AbstractAgentWizardPage[pages.size()]);
    }

    private List createWizardPages(final WizardPageExtension wizardExtension, boolean boundToOfferings) throws CoreException {
        LinkedList<AbstractAgentWizardPage> wizardPages = new LinkedList<AbstractAgentWizardPage>();
        if (boundToOfferings && wizardExtension.getJobs().size() == 0) {
            return wizardPages;
        }
        List pages = wizardExtension.getPages();
        int i = 0;
        while (i < pages.size()) {
            Page pg = (Page)pages.get(i);
            AbstractAgentWizardPage page = pg.getPage();
            page.init(new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (IAgent.class.equals((Object)adapter)) {
                        return AgentUI.getDefault().getAgent();
                    }
                    if (IAgentJob[].class.equals((Object)adapter) || AgentJob[].class.equals((Object)adapter)) {
                        return wizardExtension.getJobs().toArray(new AgentJob[wizardExtension.getJobs().size()]);
                    }
                    if (IAgentObserverRegistrar.class.equals((Object)adapter)) {
                        return AgentUI.getDefault().getAgent().getEventManager();
                    }
                    return null;
                }
            });
            if (page.canAddPageToWizard()) {
                wizardPages.add(page);
            }
            ++i;
        }
        return wizardPages;
    }

    private void parseDefinitions(IExtension extension, WizardType type, Map wizardExtensions, Map offeringBindings) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("wizardExtension")) {
                String declaredType = element.getAttribute("wizardType");
                if (type.getType().equals(declaredType)) {
                    this.addPagesToWizardExtension(element, wizardExtensions);
                }
            } else if (element.getName().equals("wizardOfferingBinding")) {
                this.addWizardOfferingBinding(element, offeringBindings);
            }
            ++n2;
        }
    }

    private void addPagesToWizardExtension(IConfigurationElement element, Map wizardExtensions) {
        IConfigurationElement[] pageElements;
        String wizardId = element.getAttribute("wizardExtensionId");
        String wizardType = element.getAttribute("wizardType");
        WizardPageExtension ext = (WizardPageExtension)((Object)wizardExtensions.get(wizardId));
        if (ext == null) {
            ext = new WizardPageExtension(wizardId, wizardType);
            wizardExtensions.put(wizardId, ext);
        }
        IConfigurationElement[] iConfigurationElementArray = pageElements = element.getChildren();
        int n = pageElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pageElement = iConfigurationElementArray[n2];
            ext.getPages().add(new Page(pageElement));
            ++n2;
        }
    }

    protected Comparable createBindingEntry(IConfigurationElement element) {
        return null;
    }

    private static class Page {
        private AbstractAgentWizardPage page;
        private final IConfigurationElement element;

        public Page(IConfigurationElement element) {
            this.element = element;
        }

        public AbstractAgentWizardPage getPage() throws CoreException {
            if (this.page == null) {
                this.page = this.createPage();
            }
            return this.page;
        }

        private AbstractAgentWizardPage createPage() throws CoreException {
            Object obj = this.element.createExecutableExtension("class");
            if (!(obj instanceof AbstractAgentWizardPage)) {
                throw new CoreException((IStatus)new Status(4, this.element.getNamespaceIdentifier(), 0, "class specified by page element must be an instance of AbstractAgentWizardPage", null));
            }
            return (AbstractAgentWizardPage)((Object)obj);
        }
    }

    private class WizardPageExtension
    extends BoundToOfferingExtensionFactory.WizardExtension {
        private final List pages;

        public WizardPageExtension(String wizardId, String wizardType) {
            super(wizardId, wizardType);
            this.pages = new LinkedList();
        }

        public List getPages() {
            return this.pages;
        }
    }
}

