/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.factories;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIAction;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public final class ImportWizardFactory {
    private static final String TAG_IMPORT_WIZARD_EXTENSION = "importWizards";
    private static final String TAG_IMPORT_WIZARD = "importWizard";
    private static final String TAG_ACTION_ID = "id";
    private static final String TAG_ACTION_LABEL = "label";
    private static final String TAG_ACTION_IMAGE = "image";
    private static final String TAG_ACTION_DISABLE_IMAGE = "disableImage";
    private static final String TAG_ACTION_TOOLTIP = "tooltip";
    private static final String TAG_ACTION_CLASS = "actionClass";
    private static final String TAG_LINK = "startLink";
    private static final String TAG_LINK_LABEL = "label";
    private static final String TAG_LINK_IMAGE = "image";
    private static final String TAG_LINK_HOVER_IMAGE = "hoverImage";
    private static final String TAG_IMPORT_WIZARD_ID = "importWizardId";
    private ImportWizardExtension[] actionExtensions;
    private static ImportWizardFactory instance = new ImportWizardFactory();

    public static ImportWizardFactory getInstance() {
        return instance;
    }

    public ImportWizardExtension[] createImportWizards() {
        if (this.actionExtensions == null) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_IMPORT_WIZARD_EXTENSION).getExtensions();
            if (extensions == null || extensions.length == 0) {
                this.actionExtensions = new ImportWizardExtension[0];
            } else {
                IExtension extension;
                HashMap actionMap = new HashMap();
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    extension = iExtensionArray[n2];
                    this.parseActionDefinitions(extension, actionMap);
                    ++n2;
                }
                if (!actionMap.isEmpty()) {
                    iExtensionArray = extensions;
                    n = extensions.length;
                    n2 = 0;
                    while (n2 < n) {
                        extension = iExtensionArray[n2];
                        this.parseLinkDefinitions(extension, actionMap);
                        ++n2;
                    }
                }
                if (!actionMap.isEmpty()) {
                    Collection actions = actionMap.values();
                    this.actionExtensions = actions.toArray(new ImportWizardExtension[actions.size()]);
                } else {
                    this.actionExtensions = new ImportWizardExtension[0];
                }
            }
        }
        return this.actionExtensions;
    }

    public boolean hasImportWizards() {
        return this.createImportWizards().length > 0;
    }

    public AgentUIWizard getWizard() {
        AbstractAgentUIAction importAction;
        ImportWizardExtension[] extensions = this.createImportWizards();
        if (extensions.length > 0 && (importAction = extensions[0].getImportWizard()) != null) {
            return importAction.getWizard();
        }
        return null;
    }

    private void parseActionDefinitions(IExtension extension, Map actionMap) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_IMPORT_WIZARD) && (id = element.getAttribute(TAG_ACTION_ID)) != null && id.trim().length() > 0) {
                    String tooltip;
                    ImageDescriptor diableImageDes;
                    String disableImagePath;
                    ImageDescriptor imageDes;
                    String imagePath;
                    ImportWizardExtension actionExtension = new ImportWizardExtension(element, id);
                    String label = element.getAttribute("label");
                    if (label != null) {
                        actionExtension.setActionLabel(label);
                    }
                    if ((imagePath = element.getAttribute("image")) != null && (imageDes = this.getImageDescriptor(element.getContributor().getName(), imagePath)) != null) {
                        actionExtension.setActionImage(imageDes);
                    }
                    if ((disableImagePath = element.getAttribute(TAG_ACTION_DISABLE_IMAGE)) != null && (diableImageDes = this.getImageDescriptor(element.getContributor().getName(), disableImagePath)) != null) {
                        actionExtension.setActionDisableImage(diableImageDes);
                    }
                    if ((tooltip = element.getAttribute(TAG_ACTION_TOOLTIP)) != null) {
                        actionExtension.setActionTooltip(tooltip);
                    }
                    actionMap.put(id, actionExtension);
                }
                ++n2;
            }
        }
    }

    private void parseLinkDefinitions(IExtension extension, Map actionMap) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ImportWizardExtension actionExtension;
                String id;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_LINK) && (id = element.getAttribute(TAG_IMPORT_WIZARD_ID)) != null && id.trim().length() > 0 && (actionExtension = (ImportWizardExtension)actionMap.get(id)) != null) {
                    ImageDescriptor hoverImageDes;
                    String hoverLinkImagePath;
                    ImageDescriptor imageDes;
                    String linkImagePath;
                    actionExtension.setAddToStartPage(true);
                    String linkLabel = element.getAttribute("label");
                    if (linkLabel != null) {
                        actionExtension.setLinkLabel(linkLabel);
                    }
                    if ((linkImagePath = element.getAttribute("image")) != null && (imageDes = this.getImageDescriptor(element.getContributor().getName(), linkImagePath)) != null) {
                        actionExtension.setLinkImage(imageDes);
                    }
                    if ((hoverLinkImagePath = element.getAttribute(TAG_LINK_HOVER_IMAGE)) != null && (hoverImageDes = this.getImageDescriptor(element.getContributor().getName(), hoverLinkImagePath)) != null) {
                        actionExtension.setLinkHoverImage(hoverImageDes);
                    }
                }
                ++n2;
            }
        }
    }

    private ImageDescriptor getImageDescriptor(String namespace, String imagePath) {
        Bundle bundle;
        ImageDescriptor image = null;
        if (imagePath != null && (bundle = Platform.getBundle((String)namespace)) != null) {
            String path = "$nl$/" + imagePath;
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            image = ImageDescriptor.createFromURL((URL)url);
        }
        return image;
    }

    public static class ImportWizardExtension {
        private final IConfigurationElement element;
        private AbstractAgentUIAction action;
        private final String actionId;
        private String actionLabel;
        private ImageDescriptor actionImage;
        private ImageDescriptor actionDisableImage;
        private String actionTooltip;
        private String linkLabel;
        private ImageDescriptor linkImage;
        private ImageDescriptor linkHoverImage;
        private boolean addToStartPage = false;

        public ImportWizardExtension(IConfigurationElement element, String id) {
            this.element = element;
            this.actionId = id;
        }

        public AbstractAgentUIAction getImportWizard() {
            if (this.action == null) {
                this.action = this.createAction();
            }
            return this.action;
        }

        private AbstractAgentUIAction createAction() {
            Object obj = null;
            try {
                obj = this.element.createExecutableExtension(ImportWizardFactory.TAG_ACTION_CLASS);
                if (!(obj instanceof AbstractAgentUIAction)) {
                    AgentUI.reportException((Throwable)new CoreException((IStatus)new Status(4, this.element.getNamespaceIdentifier(), 0, "class specified by panel element must be an instance of AbstractAgentUIAction", null)), false);
                    obj = null;
                }
            }
            catch (Exception e) {
                AgentUI.reportException(e, false);
                obj = null;
            }
            AbstractAgentUIAction agentUIAction = (AbstractAgentUIAction)((Object)obj);
            return agentUIAction;
        }

        public String getActionId() {
            return this.actionId;
        }

        public String getActionLabel() {
            return this.actionLabel;
        }

        public ImageDescriptor getActionImage() {
            return this.actionImage;
        }

        public void setActionImage(ImageDescriptor actionImage) {
            this.actionImage = actionImage;
        }

        public ImageDescriptor getActionDisableImage() {
            return this.actionDisableImage;
        }

        public void setActionDisableImage(ImageDescriptor actionDisableImage) {
            this.actionDisableImage = actionDisableImage;
        }

        public String getActionTooltip() {
            return this.actionTooltip;
        }

        public void setActionTooltip(String actionTooltip) {
            this.actionTooltip = actionTooltip;
        }

        public String getLinkLabel() {
            return this.linkLabel;
        }

        public void setLinkLabel(String linkLabel) {
            this.linkLabel = linkLabel;
        }

        public ImageDescriptor getLinkImage() {
            return this.linkImage;
        }

        public void setLinkImage(ImageDescriptor linkImage) {
            this.linkImage = linkImage;
        }

        public ImageDescriptor getLinkHoverImage() {
            return this.linkHoverImage;
        }

        public void setLinkHoverImage(ImageDescriptor linkHoverImage) {
            this.linkHoverImage = linkHoverImage;
        }

        public boolean getAddToStartPage() {
            return this.addToStartPage;
        }

        public void setAddToStartPage(boolean addToStartPage) {
            this.addToStartPage = addToStartPage;
        }

        public void setActionLabel(String actionLabel) {
            this.actionLabel = actionLabel;
        }
    }
}

