/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.views.LogMasterDetailsBlock;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class ViewLogDialog
extends TrayDialog
implements IFormContext {
    private ManagedForm managedForm;
    private LogMasterDetailsBlock logBlock;
    private Composite leftContainer;
    private Composite rightContainer;
    private File logFile;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private static int DIALOG_DEFAULT_WIDTH = 750;
    private static int DIALOG_DEFAULT_HEIGHT = 650;
    private static int LOG_COL_DEFAULT_WIDTH = 150;
    private static int ASCENDING = 1;
    private static int DESCENDING = -1;
    private int leftContainerWidth = -1;
    private int rightContainerWidth = -1;
    private int logColWidth = -1;
    private int sortOrder = DESCENDING;
    private static final String LEFT_CONTAINER = "leftContainer";
    private static final String RIGHT_CONTAINER = "rightContainer";
    private static final String LOG_COL = "logCol";
    private static final String SORT_TYPE = "sortType";

    public ViewLogDialog(Shell parentShell, File logFile) {
        super(parentShell);
        this.logFile = logFile;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DisplayLogDialog_title);
        this.readConfiguration();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, JFaceResources.getString((String)"close"), true);
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(DIALOG_DEFAULT_WIDTH, DIALOG_DEFAULT_HEIGHT);
        }
        this.getButton(12).setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolKit = CicCommonUiPlugin.getDefault().getFormToolkit();
        Composite outer = (Composite)super.createDialogArea(parent);
        SashForm sashForm = new SashForm(outer, 0);
        toolKit.adapt((Control)sashForm, false, false);
        sashForm.setLayoutData((Object)new GridData(1808));
        sashForm.setOrientation(256);
        this.leftContainer = toolKit.createComposite((Composite)sashForm);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 1;
        this.leftContainer.setLayout((Layout)layout);
        this.leftContainer.setLayoutData((Object)new GridData(1808));
        int style = 68356;
        final TableViewer listViewer = new TableViewer(this.leftContainer, style);
        GridData gd = new GridData(1808);
        gd.heightHint = listViewer.getTable().getItemHeight() * 6;
        listViewer.getTable().setLayoutData((Object)gd);
        listViewer.getTable().setLinesVisible(false);
        listViewer.getTable().setHeaderVisible(true);
        final TableColumn logCol = new TableColumn(listViewer.getTable(), 0x800000);
        logCol.setText(Messages.ViewLogDialog_LogColLabel);
        logCol.setWidth(this.logColWidth);
        logCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewLogDialog.this.dialogSettings.put(ViewLogDialog.LOG_COL, logCol.getWidth());
            }
        });
        listViewer.getTable().setSortColumn(logCol);
        listViewer.getTable().setSortDirection(this.sortOrder == ASCENDING ? 128 : 1024);
        listViewer.setSorter(this.getViewerSorter());
        logCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewLogDialog viewLogDialog = ViewLogDialog.this;
                viewLogDialog.sortOrder = viewLogDialog.sortOrder * -1;
                listViewer.setSorter(ViewLogDialog.this.getViewerSorter());
                ViewLogDialog.this.dialogSettings.put(ViewLogDialog.SORT_TYPE, ViewLogDialog.this.sortOrder);
                listViewer.getTable().setSortDirection(ViewLogDialog.this.sortOrder == ASCENDING ? 128 : 1024);
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 80, true));
        listViewer.getTable().setLayout((Layout)tableLayout);
        listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        File[] logFiles = AgentUtil.getLogFiles((boolean)false);
        listViewer.setInput((Object)logFiles);
        if (logFiles != null && logFiles.length > 0) {
            if (this.logFile != null) {
                if (!this.logFile.exists()) {
                    final String wrongLogFilePath = this.logFile.getAbsolutePath();
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)listViewer.getControl().getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, (String)NLS.bind((String)Messages.ViewLogDialog_LogFileNotExist, (Object)wrongLogFilePath));
                        }
                    });
                    this.logFile = LogManager.getDefaultLogFile();
                } else {
                    TableItem[] items;
                    boolean found = false;
                    TableItem[] tableItemArray = items = listViewer.getTable().getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        Object data = item.getData();
                        if (data instanceof File && this.logFile.equals(data)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        final String wrongLogFilePath = this.logFile.getAbsolutePath();
                        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)listViewer.getControl().getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, (String)NLS.bind((String)Messages.ViewLogDialog_InvalidLogFile, (Object)wrongLogFilePath));
                            }
                        });
                        this.logFile = LogManager.getDefaultLogFile();
                    }
                }
            } else {
                this.logFile = LogManager.getDefaultLogFile();
            }
            listViewer.setSelection((ISelection)new StructuredSelection((Object)this.logFile));
        }
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (selectedElement = ((StructuredSelection)selection).getFirstElement()) instanceof File) {
                    ViewLogDialog.this.logBlock.setInput((File)selectedElement);
                }
            }
        });
        this.rightContainer = toolKit.createComposite((Composite)sashForm, 2048);
        this.rightContainer.setLayout((Layout)new FillLayout());
        this.createLogView(this.rightContainer);
        if (this.leftContainerWidth <= 0 || this.rightContainerWidth <= 0) {
            sashForm.setWeights(new int[]{30, 70});
        } else {
            sashForm.setWeights(new int[]{this.leftContainerWidth, this.rightContainerWidth});
        }
        return outer;
    }

    private void createLogView(Composite parent) {
        this.managedForm = new ManagedForm(CicCommonUiPlugin.getDefault().getFormToolkit(), CicCommonUiPlugin.getDefault().getFormToolkit().createScrolledForm(parent));
        this.managedForm.getForm().getBody().setLayout((Layout)new FillLayout());
        this.logBlock = new LogMasterDetailsBlock(this, this.logFile);
        this.logBlock.createContent((IManagedForm)this.managedForm);
        this.logBlock.setInput(this.logFile);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        this.writeConfiguration();
        this.logBlock.saveState();
        this.logBlock.dispose();
        return super.close();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(this.getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(this.getClass().getName());
        }
        return this.dialogSettings;
    }

    public IDialogSettings getLogSettings() {
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
            this.leftContainerWidth = s.getInt(LEFT_CONTAINER);
            this.rightContainerWidth = s.getInt(RIGHT_CONTAINER);
            this.logColWidth = s.getInt(LOG_COL);
            this.sortOrder = s.getInt(SORT_TYPE);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
            this.leftContainerWidth = -1;
            this.rightContainerWidth = -1;
            this.logColWidth = LOG_COL_DEFAULT_WIDTH;
            this.sortOrder = DESCENDING;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        s.put(LEFT_CONTAINER, this.leftContainer.getSize().x);
        s.put(RIGHT_CONTAINER, this.rightContainer.getSize().x);
        s.put(SORT_TYPE, this.sortOrder);
    }

    @Override
    public IManagedForm getForm() {
        return this.managedForm;
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return null;
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                File entry1 = (File)e1;
                File entry2 = (File)e2;
                int result = entry1.getName().compareTo(entry2.getName()) * ViewLogDialog.this.sortOrder;
                return result;
            }
        };
    }

    public static class LogLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final AgentUILabelProvider agentUILabelProvider = AgentUI.getDefault().getLabelProvider();
        private final File currentSessionLog;

        public LogLabelProvider() {
            this.agentUILabelProvider.connect((Object)this);
            this.currentSessionLog = LogManager.getDefaultLogFile();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (this.currentSessionLog != null && element instanceof File && this.currentSessionLog.equals(element)) {
                    if (CommonUIUtils.runningBiDiLocale()) {
                        return this.agentUILabelProvider.get(CICImages.DESC_CURRENT_LOG_FLIPPED);
                    }
                    return this.agentUILabelProvider.get(CICImages.DESC_CURRENT_LOG);
                }
                return this.agentUILabelProvider.get(CICImages.MENU_LOG);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof File && columnIndex == 0) {
                return TextProcessor.process((String)((File)element).getName());
            }
            return null;
        }
    }
}

