/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCheckBox;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateLabel;
import com.ibm.cic.agent.core.custompanel.api.TemplateMultiSelectList;
import com.ibm.cic.agent.core.custompanel.api.TemplateProperty;
import com.ibm.cic.agent.core.custompanel.api.TemplatePushButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioGroup;
import com.ibm.cic.agent.core.custompanel.api.TemplateReadonlyList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSingleSelectList;
import com.ibm.cic.agent.core.custompanel.api.TemplateText;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.cic.agent.core.custompanel.template.ICustomPanelGenerator;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.custompanel.GeneratedSWTCustomPanel;
import com.ibm.cic.agent.internal.ui.custompanel.PropertyComposite;
import com.ibm.cic.agent.internal.ui.custompanel.TextComposite;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SWTCustomPanelGenerator
implements ICustomPanelGenerator {
    private static SWTCustomPanelGenerator instance = new SWTCustomPanelGenerator();
    private static final int ControlDecorationSpace = 8;
    private static final int LabelDefaultWidth = 350;
    private static final int DefaultMultiLineTextHeight = 4;

    public static ICustomPanelGenerator getInstance() {
        if (instance == null) {
            instance = new SWTCustomPanelGenerator();
        }
        return instance;
    }

    public ICustomPanel generateCustomPanel(CustomPanelWrapper template) {
        return new GeneratedSWTCustomPanel(template);
    }

    public static Composite createComposite(FormToolkit toolkit, Composite parent, TemplateWidgetContainer container) {
        Composite returnComp = null;
        String containerLabel = container.getDisplayLabel();
        if (containerLabel != null && containerLabel.length() > 0) {
            Group group = new Group(parent, 0);
            group.setText(containerLabel);
            toolkit.adapt((Composite)group);
            returnComp = group;
        } else {
            int swtStyle;
            TemplateConstants.ContainerStyle containerStyle = container.getContainerStyle();
            switch (containerStyle) {
                case BORDER: {
                    swtStyle = 2048;
                    break;
                }
                default: {
                    swtStyle = 0;
                }
            }
            returnComp = toolkit.createComposite(parent, swtStyle);
        }
        if (container.isChildrenExclusive()) {
            StackLayout stackLayout = new StackLayout();
            stackLayout.marginWidth = 0;
            returnComp.setLayout((Layout)stackLayout);
        } else {
            GridLayout layout = new GridLayout();
            TemplateConstants.LayoutType layoutType = container.getLayout();
            if (layoutType.equals((Object)TemplateConstants.LayoutType.HORIZONTAL)) {
                int childrenNum;
                layout.numColumns = childrenNum = container.getChildren().size();
            }
            returnComp.setLayout((Layout)layout);
        }
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)container, (Control)returnComp);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)container, (Control)returnComp);
        return returnComp;
    }

    public static Control createLabel(FormToolkit toolkit, Composite parent, TemplateLabel labelTemplate) {
        Label generatedControlForLabel = null;
        TemplateConstants.LabelStyle style = labelTemplate.getStyle();
        if (style == TemplateConstants.LabelStyle.LINK) {
            Link link = new Link(parent, 64);
            link.setText(labelTemplate.getDisplayLabel());
            toolkit.adapt((Control)link, true, true);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String actionId = e.text;
                    AgentUI.getDefault().showURL(actionId);
                }
            });
            generatedControlForLabel = link;
        } else {
            Label label = null;
            label = toolkit.createLabel(parent, labelTemplate.getDisplayLabel(), labelTemplate.isWrapEnabled() ? 64 : 0);
            if (labelTemplate.getStyle() == TemplateConstants.LabelStyle.BOLD) {
                final Font boldFont = CommonUIUtils.createBoldFont((Display)DisplayKeeper.INSTANCE.getDisplay(), (Font)label.getFont());
                label.setFont(boldFont);
                label.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (boldFont != null && !boldFont.isDisposed()) {
                            boldFont.dispose();
                        }
                    }
                });
            }
            generatedControlForLabel = label;
        }
        if (labelTemplate.isWrapEnabled()) {
            SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)labelTemplate, (Control)generatedControlForLabel, 350);
        } else {
            SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)labelTemplate, (Control)generatedControlForLabel, -1);
        }
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)labelTemplate, (Control)generatedControlForLabel);
        return generatedControlForLabel;
    }

    private static void createTextCompositeChildren(FormToolkit toolkit, TextComposite textComp, TemplateWidget textOrPropertyTemplate, TemplateConstants.TextStyle style, String description, boolean ignoreIndent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = style == TemplateConstants.TextStyle.FILE || style == TemplateConstants.TextStyle.DIRECTORY ? 2 : 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textComp.setLayout((Layout)layout);
        SWTCustomPanelGenerator.setWidgetLayoutData(textOrPropertyTemplate, (Control)textComp, -1, true, ignoreIndent);
        int swtTextStyle = 0;
        if (style == TemplateConstants.TextStyle.PASSWORD) {
            swtTextStyle = 0x400000;
        } else if (style == TemplateConstants.TextStyle.MULTI_LINE) {
            swtTextStyle = 514;
        }
        Text text = toolkit.createText((Composite)textComp, "", swtTextStyle | 0x800);
        SWTCustomPanelGenerator.setWidgetLayoutData(textOrPropertyTemplate, (Control)text, -1, false, ignoreIndent);
        if (style == TemplateConstants.TextStyle.MULTI_LINE) {
            GridData gridData = (GridData)text.getLayoutData();
            gridData.heightHint = text.getLineHeight() * 4;
        }
        text.setEnabled(true);
        if (description != null && description.length() > 0) {
            text.setToolTipText(description);
        }
        textComp.setTextWidget(text);
        if (style == TemplateConstants.TextStyle.FILE || style == TemplateConstants.TextStyle.DIRECTORY) {
            String browseLabel = style == TemplateConstants.TextStyle.FILE ? Messages.AgentInstallLocationPage_browseButton : Messages.LicenseImportPage_browse;
            Button browseButton = toolkit.createButton((Composite)textComp, browseLabel, 8);
            textComp.setBrowseButton(browseButton);
        }
        SWTCustomPanelGenerator.setWidgetInitialStatus(textOrPropertyTemplate, (Control)textComp);
    }

    public static TextComposite createTextComposite(FormToolkit toolkit, Composite parent, TemplateText textTemplate) {
        TextComposite container = new TextComposite(parent, 0);
        toolkit.adapt((Composite)container);
        SWTCustomPanelGenerator.createTextCompositeChildren(toolkit, container, (TemplateWidget)textTemplate, textTemplate.getStyle(), textTemplate.getDescription(), false);
        return container;
    }

    public static PropertyComposite createPropertyControl(FormToolkit toolkit, Composite parent, TemplateProperty propertyTemplate) {
        Label label = toolkit.createLabel(parent, propertyTemplate.getDisplayLabel());
        int indent = propertyTemplate.getIndent();
        if (indent > 0) {
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = indent;
            label.setLayoutData((Object)layoutData);
        }
        PropertyComposite propertyComposite = new PropertyComposite(parent, 0, label);
        toolkit.adapt((Composite)propertyComposite);
        SWTCustomPanelGenerator.createTextCompositeChildren(toolkit, propertyComposite, (TemplateWidget)propertyTemplate, propertyTemplate.getStyle(), propertyTemplate.getDescription(), true);
        return propertyComposite;
    }

    public static Button createPushButton(FormToolkit toolkit, Composite parent, TemplatePushButton buttonTemplate) {
        Button button = toolkit.createButton(parent, buttonTemplate.getDisplayLabel(), 8);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)buttonTemplate, (Control)button);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)buttonTemplate, (Control)button);
        return button;
    }

    public static Composite createRadioButtonGroup(FormToolkit toolkit, Composite parent, TemplateRadioGroup radioGroupTemplate) {
        Composite radioGroupComposite = toolkit.createComposite(parent);
        radioGroupComposite.setLayout((Layout)new GridLayout());
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)radioGroupTemplate, (Control)radioGroupComposite);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)radioGroupTemplate, (Control)radioGroupComposite);
        return radioGroupComposite;
    }

    public static Button createRadioButton(FormToolkit toolkit, Composite parent, TemplateRadioButton radioButtonTemplate) {
        Button radioButton = toolkit.createButton(parent, radioButtonTemplate.getDisplayLabel(), 16);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)radioButtonTemplate, (Control)radioButton);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)radioButtonTemplate, (Control)radioButton);
        return radioButton;
    }

    public static Button createCheckButton(FormToolkit toolkit, Composite parent, TemplateCheckBox checkButtonTemplate) {
        Button checkButton = toolkit.createButton(parent, checkButtonTemplate.getDisplayLabel(), 32);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)checkButtonTemplate, (Control)checkButton);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)checkButtonTemplate, (Control)checkButton);
        return checkButton;
    }

    public static Combo createCombo(FormToolkit toolkit, Composite swtContainer, TemplateSingleSelectList tempList) {
        Combo dropDownCombo = new Combo(swtContainer, 12);
        toolkit.adapt((Composite)dropDownCombo);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)tempList, (Control)dropDownCombo, true);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)tempList, (Control)dropDownCombo);
        dropDownCombo.setItems(tempList.getLabels());
        return dropDownCombo;
    }

    public static List createReadonlyList(FormToolkit toolkit, Composite swtContainer, TemplateReadonlyList templateList) {
        List swtList = new List(swtContainer, 2564);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)templateList, (Control)swtList, true);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)templateList, (Control)swtList);
        swtList.setItems(templateList.getLabels());
        return swtList;
    }

    public static List createList(FormToolkit toolkit, Composite swtContainer, TemplateSelectableList templateList) {
        int selectionStyle = templateList instanceof TemplateMultiSelectList ? 2 : 4;
        List swtList = new List(swtContainer, 0xA00 | selectionStyle);
        SWTCustomPanelGenerator.setWidgetLayoutData((TemplateWidget)templateList, (Control)swtList, true);
        SWTCustomPanelGenerator.setWidgetInitialStatus((TemplateWidget)templateList, (Control)swtList);
        swtList.setItems(templateList.getLabels());
        return swtList;
    }

    private static void setWidgetLayoutData(TemplateWidget widget, Control control) {
        SWTCustomPanelGenerator.setWidgetLayoutData(widget, control, -1);
    }

    private static void setWidgetLayoutData(TemplateWidget widget, Control control, int widthHint) {
        SWTCustomPanelGenerator.setWidgetLayoutData(widget, control, widthHint, false, false);
    }

    private static void setWidgetLayoutData(TemplateWidget widget, Control control, boolean addControlDecoration) {
        SWTCustomPanelGenerator.setWidgetLayoutData(widget, control, -1, addControlDecoration, false);
    }

    private static void setWidgetLayoutData(TemplateWidget widget, Control control, int widthHint, boolean addControlDecoration, boolean ignoreIndent) {
        TemplateWidgetContainer parent;
        int layoutData = SWTCustomPanelGenerator.getHorizontalLayoutData(widget) | SWTCustomPanelGenerator.getVerticalLayoutData(widget);
        GridData data = new GridData(layoutData);
        if (widthHint > -1) {
            data.widthHint = widthHint;
        }
        if (!ignoreIndent && (parent = widget.getParent()) != null) {
            TemplateConstants.LayoutType layoutType = parent.getLayout();
            if (layoutType == TemplateConstants.LayoutType.VERTICAL) {
                data.horizontalIndent = widget.getIndent();
            } else {
                data.verticalIndent = widget.getIndent();
            }
        }
        if (addControlDecoration) {
            data.horizontalIndent += 8;
        }
        control.setLayoutData((Object)data);
    }

    private static void setWidgetInitialStatus(TemplateWidget widget, Control control) {
        boolean enabled = widget.getEnabled();
        control.setEnabled(enabled);
        boolean visible = widget.getVisible();
        control.setVisible(visible);
    }

    private static int getHorizontalLayoutData(TemplateWidget widget) {
        int layoutData;
        TemplateConstants.Alignment alignment = widget.getHorizontalAlignment();
        switch (alignment) {
            case CENTER: {
                layoutData = 64;
                break;
            }
            case END: {
                layoutData = 128;
                break;
            }
            case FILL: {
                layoutData = 256;
                break;
            }
            default: {
                layoutData = 32;
            }
        }
        if (widget.getExtendHorizontal()) {
            layoutData |= 0x200;
        }
        return layoutData;
    }

    private static int getVerticalLayoutData(TemplateWidget widget) {
        int layoutData;
        TemplateConstants.Alignment alignment = widget.getVerticalAlignment();
        switch (alignment) {
            case CENTER: {
                layoutData = 4;
                break;
            }
            case END: {
                layoutData = 8;
                break;
            }
            case FILL: {
                layoutData = 16;
                break;
            }
            default: {
                layoutData = 2;
            }
        }
        if (widget.getExtendVertical()) {
            layoutData |= 0x400;
        }
        return layoutData;
    }
}

