/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.response.Response;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentReopenRepositoryPrompter;
import com.ibm.cic.agent.internal.ui.AgentUIBufferedEventManager;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchAdvisor;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogErrorDialog;
import com.ibm.cic.agent.internal.ui.utils.GetInitDataParser;
import com.ibm.cic.agent.ui.api.IAgentUI;
import com.ibm.cic.common.core.internal.preferences.UserContext;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.core.volrepo.DiskPrompter;
import com.ibm.cic.common.core.volrepo.IDiskChangePrompter;
import com.ibm.cic.common.core.volrepo.IDiskInsertedValidator;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.INonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.JavaProxyAuthenticator;
import com.ibm.cic.common.downloads.NonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.InsertDiskDialog;
import com.ibm.cic.common.ui.internal.dialogs.SSLErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.UserPasswordDialog;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.misc.PaUserFeedbackProvider;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizard;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.utils.UIPlatformUtils;
import com.ibm.cic.eclipse.internals.dialogs.TimeTriggeredProgressMonitorDialog;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.prefs.Preferences;

public class AgentUI
extends AbstractUIPlugin
implements IAdaptable,
IAgentUI {
    public static final String PLUGIN_ID = "com.ibm.cic.agent.ui";
    private static final String URL_PREFIX = "iim://installmanager@";
    private static AgentUI plugin;
    private AbstractCicWizard currentWizard;
    private String profileId;
    private Agent agent;
    private IStatus agentStartStatus;
    private IPreferenceStore agentPreferenceStore;
    private AgentUILabelProvider labelProvider;
    private static boolean purgeAgentAllOnStartup;
    private static boolean purgeAgentDataOnStartup;
    private static boolean preserveAgentPreferences;
    private static boolean isAgentInValidatingMode;
    private transient ListenerList propertyChangeListeners = null;
    private String recordFile = null;
    private static final String IBM_PA_TEST_SITE_TAG = "ibmPassportAdvantageTestSite";
    private static final Logger logger;
    private AgentUIWorkbenchAdvisor workbenchAdvisor = null;

    static {
        purgeAgentAllOnStartup = false;
        purgeAgentDataOnStartup = false;
        preserveAgentPreferences = false;
        isAgentInValidatingMode = false;
        logger = Logger.getLogger(AgentUI.class);
    }

    public AgentUIWorkbenchAdvisor getWorkbenchAdvisor() {
        return this.workbenchAdvisor;
    }

    public void setWorkbenchAdvisor(AgentUIWorkbenchAdvisor workbenchAdvisor) {
        this.workbenchAdvisor = workbenchAdvisor;
    }

    public AgentUI() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public Agent getAgent() {
        final IStatus[] status = new IStatus[1];
        if (this.agent == null) {
            String gtk = UIPlatformUtils.getWS();
            logger.info(Messages.WindowingSystem, new Object[]{gtk});
            IStatus accessRightsStatus = Agent.getAccessRightsStatus();
            if (!accessRightsStatus.isOK()) {
                AgentUI.reportStatus(accessRightsStatus, false);
                if (accessRightsStatus.getSeverity() == 4) {
                    this.agentStartStatus = accessRightsStatus;
                    return null;
                }
            }
            if (AgentUI.isCurrentThreadSwtThread()) {
                status[0] = this.initialize();
            } else {
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        status[0] = AgentUI.this.initialize();
                    }
                });
            }
        }
        return this.agent;
    }

    public static boolean isCurrentThreadSwtThread() {
        return Thread.currentThread().equals(DisplayKeeper.INSTANCE.getDisplay().getThread());
    }

    public void preprocessInputCommands() {
        final IInput input = AgentInput.getInstance().getInput();
        if (input != null) {
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        CicMultiStatus multiStatus;
                        IStatus st1 = null;
                        st1 = !input.isNewFormat() ? input.executeCommands(AgentUI.this.agent, 2, monitor) : input.getResponse().initializeAgentPreferences(AgentUI.this.agent);
                        if (!st1.isOK()) {
                            if (AgentUI.this.agentStartStatus.isOK()) {
                                AgentUI.this.agentStartStatus = st1;
                            } else {
                                multiStatus = Statuses.ST.createMultiStatus(AgentUI.this.agentStartStatus.getPlugin(), AgentUI.this.agentStartStatus.getSeverity(), AgentUI.this.agentStartStatus.getCode(), AgentUI.this.agentStartStatus.getChildren(), AgentUI.this.agentStartStatus.getException(), AgentUI.this.agentStartStatus.getMessage());
                                multiStatus.add(st1);
                                AgentUI.this.agentStartStatus = (IStatus)multiStatus;
                            }
                            AgentUI.reportStatus(st1, false);
                        }
                        if (!(st1 = !input.isNewFormat() ? input.executeCommands(AgentUI.this.agent, 8, monitor) : input.getResponse().initializeAgentRepositories(AgentUI.this.agent)).isOK()) {
                            if (AgentUI.this.agentStartStatus.isOK()) {
                                AgentUI.this.agentStartStatus = st1;
                            } else {
                                multiStatus = Statuses.ST.createMultiStatus(AgentUI.this.agentStartStatus.getPlugin(), AgentUI.this.agentStartStatus.getSeverity(), AgentUI.this.agentStartStatus.getCode(), AgentUI.this.agentStartStatus.getChildren(), AgentUI.this.agentStartStatus.getException(), AgentUI.this.agentStartStatus.getMessage());
                                multiStatus.add(st1);
                                AgentUI.this.agentStartStatus = (IStatus)multiStatus;
                            }
                            AgentUI.reportStatus(st1, false);
                        }
                    }
                }, 1000);
            }
            catch (Exception e) {
                AgentUI.reportException(e);
            }
        }
        this.getAgentPreferenceStore();
    }

    private IStatus initialize() {
        IStatus status = Status.OK_STATUS;
        this.agent = Agent.getInstance();
        this.agent.setEventManager((IAgentEventManager)new AgentUIBufferedEventManager());
        if (purgeAgentAllOnStartup) {
            purgeAgentAllOnStartup = false;
            purgeAgentDataOnStartup = false;
            status = this.agent.purgeAll(preserveAgentPreferences);
        } else if (purgeAgentDataOnStartup) {
            purgeAgentDataOnStartup = false;
            status = this.agent.purgeAgentData();
        }
        this.agent.initializeAgentPreferences();
        IInput input = AgentInput.getInstance().getInput();
        if (input == null) {
            this.agent.setCleanTemporaryMode(false, false);
            CacheLocationManager.getInstance().setSettingCacheLocationByPreference(false);
        } else if (!input.isNewFormat()) {
            this.agent.setCleanTemporaryMode(input.isCleanMode(), input.isTemporaryMode());
            if (input.isRebootLater()) {
                RebootRequest.setRebootLater();
            }
            input.executeCommands(this.agent, 1, (IProgressMonitor)new NullProgressMonitor());
            CacheLocationManager.getInstance().setSettingCacheLocationByPreference(input.isSettingEclipseCacheLocation());
            ICommand[] commands = input.getCommands(12);
            AgentInput.getInstance().setMode(commands != null && commands.length > 0 ? 1 : 0);
        } else {
            Response response = input.getResponse();
            response.initializeAgentPreferences(this.agent);
            response.initializeAgentRepositories(this.agent);
        }
        IStatus iStatus = this.agentStartStatus = status.isOK() ? this.agent.start() : status;
        if (!this.agentStartStatus.isOK()) {
            AgentUI.reportStatus(this.agentStartStatus, false);
            return this.agentStartStatus;
        }
        if (input != null) {
            this.agent.logInputFile(input);
        }
        this.agent.setValidating(isAgentInValidatingMode);
        if (this.recordFile != null && !(status = this.agent.setRecordMode(this.recordFile)).isOK()) {
            AgentUI.reportStatus(status, true);
        }
        return status;
    }

    public IStatus getAgentStartStatus() {
        return this.agentStartStatus;
    }

    public IPreferenceStore getAgentPreferenceStore() {
        if (this.agentPreferenceStore == null) {
            UserContext context = new UserContext();
            String qualifier = Agent.getBundleId();
            this.agentPreferenceStore = new ScopedPreferenceStore((IScopeContext)context, qualifier);
        }
        return this.agentPreferenceStore;
    }

    boolean isOnlyUninstallAgentCommand() {
        IInput input = AgentInput.getInstance().getInput();
        if (input != null) {
            return input.onlyUninstallAgent();
        }
        return false;
    }

    void processArguments() {
        String installUrl;
        Version installedVersion;
        Version installerVersion;
        String value = CmdLine.CL.getParam1StrVal("-accessRights");
        CicCommonSettings.setAccessRightsMode((String)value);
        AgentUI.setPurgeAgentAllOnStartup(CmdLine.CL.containsCommand("-purgeAgentAll"));
        AgentUI.setPurgeAgentDataOnStartup(CmdLine.CL.containsCommand("-purgeAgentData"));
        AgentUI.setPreservePreferencesOnStartup(CmdLine.CL.containsCommand("-preservePreferences"));
        AgentUI.setAgentInValidatingMode(CmdLine.CL.containsCommand("-validate"));
        CicCommonSettings.setIgnoreRepositoryDigest((boolean)CmdLine.CL.containsCommand("-ignoreRepositoryDigest"));
        this.recordFile = CmdLine.CL.getParam1StrVal("-record");
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        IStatus status = AgentUtil.validateAndSetDataLocation();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            AgentUI.reportStatus(status, false);
        }
        String url = CmdLine.CL.getParam1StrVal("-url");
        if (AgentInstall.getInstance().isAgentInstallerRunning() && (installerVersion = AgentInstall.getInstance().getInstallerInternalVersion()).compareTo(installedVersion = AgentInstall.getInstance().getInstalledAgentInternalVersion()) > 0 && (installUrl = CmdLine.CL.getParam1StrVal("-installUrl")) != null) {
            url = installUrl;
        }
        try {
            final String fUrl = url;
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
                    if (fUrl != null && fUrl.length() > 0) {
                        AgentUI.this.reEvaluateArguments(fUrl, spm.next());
                    }
                    AgentInput.getInstance().loadInput(spm.next());
                    spm.done();
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    /*
     * Loose catch block
     */
    private boolean reEvaluateArguments(String urlStr, IProgressMonitor monitor) {
        InputStream stream;
        IEclipsePreferences defaultPrefs;
        IEclipsePreferences currentPrefs;
        block9: {
            currentPrefs = new UserContext().getNode(Agent.getBundleId());
            defaultPrefs = DefaultScope.INSTANCE.getNode(Agent.getBundleId());
            IEclipsePreferences[] prefs = new IEclipsePreferences[]{currentPrefs, defaultPrefs};
            Platform.getPreferencesService().get("cic.appDataLocation", null, (Preferences[])prefs);
            PreferencesHolder.INSTANCE.add(currentPrefs);
            PreferencesHolder.INSTANCE.add(defaultPrefs);
            stream = null;
            try {
                URL url = this.getUrl(urlStr);
                if (url == null) break block9;
                this.setPaSystemPropertyFromQuery(url);
                stream = AgentInput.getInstance().getInputStream(this.getUrlWithoutQueryString(url), monitor);
                if (stream == null) break block9;
                GetInitDataParser parser = new GetInitDataParser(super.getBundle().getBundleContext(), PLUGIN_ID);
                List list = parser.parse(stream);
                IStatus parserStatus = parser.getStatus();
                if (StatusUtil.isError((IStatus)parserStatus)) {
                    throw new CoreException((IStatus)Statuses.ST.createMultiStatusWithChild(parserStatus, com.ibm.cic.agent.internal.core.Messages.Input_FailedReadResponseFile, new Object[0]));
                }
                String[] args = list.toArray(new String[list.size()]);
                CmdLine.CL.loadCommandLineData(args);
            }
            catch (MalformedURLException e) {
                AgentUI.reportException(e, true);
                return false;
            }
            catch (Exception e2) {
                block10: {
                    IStatus status = AgentUI.reportException(e2, false);
                    if (status.getCode() == 200) {
                        this.stopAgent();
                        PlatformUI.getWorkbench().close();
                        break block10;
                    }
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                FileUtil.close((Closeable)stream);
                PreferencesHolder.INSTANCE.remove(currentPrefs);
                PreferencesHolder.INSTANCE.remove(defaultPrefs);
                return false;
            }
        }
        FileUtil.close(stream);
        PreferencesHolder.INSTANCE.remove(currentPrefs);
        PreferencesHolder.INSTANCE.remove(defaultPrefs);
        return true;
        {
            finally {
                FileUtil.close(stream);
                PreferencesHolder.INSTANCE.remove(currentPrefs);
                PreferencesHolder.INSTANCE.remove(defaultPrefs);
            }
        }
    }

    private void setPaSystemPropertyFromQuery(URL url) {
        String property;
        String query;
        if (url != null && (query = url.getQuery()) != null && (property = this.getPassportAdvantageTestSite(query)) != null) {
            System.setProperty("ibm.entitlement.url", property);
        }
    }

    private URL getUrlWithoutQueryString(URL url) {
        try {
            return new URL(url.toExternalForm().split("\\?")[0]);
        }
        catch (MalformedURLException e) {
            AgentUI.reportException(e);
            return url;
        }
    }

    private String getPassportAdvantageTestSite(String query) {
        String[] tagAndValues;
        String[] stringArray = tagAndValues = query.split("&");
        int n = tagAndValues.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String tagAndValue = stringArray[n2];
            if (tagAndValue.startsWith(IBM_PA_TEST_SITE_TAG) && (index = tagAndValue.indexOf("=")) > -1 && index < tagAndValue.length() - 1) {
                return tagAndValue.substring(index + 1);
            }
            ++n2;
        }
        return null;
    }

    private URL getUrl(String url) {
        String actualUrl = url;
        if (url != null) {
            int index = url.indexOf(URL_PREFIX);
            if (index > -1) {
                actualUrl = url.substring(URL_PREFIX.length());
            }
            try {
                return new URL(actualUrl);
            }
            catch (MalformedURLException e) {
                AgentUI.reportException(e, true);
            }
        }
        return null;
    }

    public void setWizardJobs() {
        AgentInput.getInstance().setWizardJobs((UserFeedbackProvider)new PaUserFeedbackProvider());
    }

    public void stop(BundleContext context) throws Exception {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.stop(context);
        plugin = null;
    }

    public void stopAgent() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent.setEventManager(null);
            this.agent = null;
        }
    }

    public static AgentUI getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(AbstractCicWizard.class)) {
            return this.currentWizard;
        }
        if (adapter.equals(IAgent.class) || adapter.equals(Agent.class)) {
            return this.getAgent();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public AbstractCicWizard getCurrentWizard() {
        return this.currentWizard;
    }

    public static IStatus reportException(Throwable e) {
        return AgentUI.reportException(e, true);
    }

    public static IStatus reportException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e instanceof RuntimeStatusException) {
            status = ((RuntimeStatusException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        AgentUI.reportStatus(status, showErrorDialog);
        return status;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = AgentUI.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getDisplay().getActiveShell();
        }
        return DisplayKeeper.INSTANCE.getDisplay().getActiveShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = AgentUI.getDefault().getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    public static void reportStatus(IStatus status, boolean showDialog) {
        if (!status.isOK()) {
            AgentUI.logOnly(status);
            if (showDialog) {
                if (StatusUtil.isErrorOrCancel((IStatus)status) || StatusUtil.isWarning((IStatus)status)) {
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
                } else if (status.matches(1)) {
                    MessageDialog.openInformation((Shell)AgentUI.getActiveWorkbenchShell(), null, (String)status.getMessage());
                }
            }
        }
    }

    public static void logOnly(IStatus status) {
        Logger.getLogger((String)PLUGIN_ID).status(status);
    }

    public AgentUILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new AgentUILabelProvider();
        }
        return this.labelProvider;
    }

    public void setCurrentWizard(AbstractCicWizard wizard) {
        this.currentWizard = wizard;
        if (wizard == null && this.getAgent().isRepositoryGroupSet()) {
            ServiceRepositoryUtils.unloadServiceRepositories((IRepositoryGroup)this.getAgent().getRepositoryGroup());
        }
    }

    public void showURL(String urlName) {
        URL url;
        try {
            url = new URL(urlName);
        }
        catch (MalformedURLException e) {
            AgentUI.reportException(e);
            return;
        }
        try {
            boolean canOpenEditor = UiServices.getInstance().launchProgram(urlName);
            if (!canOpenEditor) {
                UiServices.getInstance().openUrlInBrowser(url);
            }
        }
        catch (PartInitException e) {
            AgentUI.reportException(e);
        }
    }

    void initializeDiskPrompterAndAuthenticationDialog() {
        AgentReopenRepositoryPrompter reopenRepositoryPrompter = new AgentReopenRepositoryPrompter();
        CacheManager.setReopenRepositoryPrompter((String)"cache", (IReopenRepositoryPrompter)reopenRepositoryPrompter);
        DiskPrompter.INSTANCE.setPrompter(new IDiskChangePrompter(){

            public IStatus promptInsertDisk(final IDiskInsertedValidator validator, final ICicLocation rootDir, final String diskLabel, String diskSetId, final int diskNum) {
                final IStatus[] retStatus = new IStatus[1];
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                        InsertDiskDialog dialog = new InsertDiskDialog(shell, validator, rootDir, diskLabel, diskNum);
                        int rc = dialog.open();
                        if (rc == 1) {
                            retStatus[0] = Status.CANCEL_STATUS;
                            return;
                        }
                        if (rc == 0) {
                            retStatus[0] = dialog.getOkStatus();
                            return;
                        }
                        retStatus[0] = null;
                    }
                });
                return retStatus[0];
            }
        });
        CredentialPrompter.INSTANCE.setPrompter(new ICredentialPrompter(){

            public IStatus askUserIdAndPassword(final ICredentialValidator validator, final String connectMessage, final CredentialRequested requested, final CredentialInfo previous, final CredentialInfo[] ret) {
                final IStatus[] retStatus = new IStatus[1];
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UserPasswordDialog dialog;
                        int rc;
                        Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                        if (shell != null) {
                            shell.forceActive();
                            if (shell.getMinimized()) {
                                shell.setMinimized(false);
                            }
                        }
                        if ((rc = (dialog = new UserPasswordDialog(shell, validator, connectMessage, requested, previous)).open()) == 1) {
                            retStatus[0] = Status.CANCEL_STATUS;
                            return;
                        }
                        if (rc == 0) {
                            retStatus[0] = dialog.getOkStatus();
                            ret[0] = dialog.getCredentialInfo();
                            return;
                        }
                        retStatus[0] = null;
                    }
                });
                return retStatus[0];
            }
        });
        Authenticator.setDefault((Authenticator)JavaProxyAuthenticator.INSTANCE);
        NonsecureConnectionPrompter.INSTANCE.setPrompter(new INonsecureConnectionPrompter(){

            public int promptEnterNonsecureSSLMode(String host, X509Certificate[] certificates, String authType, CertificateException ce) {
                final CicMultiStatus status = Statuses.ST.createMultiStatus();
                ICicStatus childStatus = Statuses.ERROR.get(ce.getLocalizedMessage(), new Object[0]);
                status.add((IStatus)childStatus);
                final int[] retCode = new int[1];
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                        SSLErrorDialog dlg = new SSLErrorDialog(shell, (IStatus)status, 4, Messages.AgentUI_IM_Name);
                        int rc = dlg.open();
                        retCode[0] = rc == 2 ? dlg.getModeSelection() : 3;
                    }
                });
                return retCode[0];
            }
        });
    }

    public String getProfileId() {
        return this.profileId;
    }

    public Profile getSingleProfile() {
        if (this.profileId == null) {
            return null;
        }
        return this.getAgent().getProfile(this.profileId);
    }

    public static void setPurgeAgentAllOnStartup(boolean doPurge) {
        purgeAgentAllOnStartup = doPurge;
    }

    public static void setPreservePreferencesOnStartup(boolean preserve) {
        preserveAgentPreferences = preserve;
    }

    public static void setPurgeAgentDataOnStartup(boolean doPurge) {
        purgeAgentDataOnStartup = doPurge;
    }

    private static void setAgentInValidatingMode(boolean validate) {
        isAgentInValidatingMode = validate;
    }

    public boolean isEclipseCacheChangeable() {
        return CacheLocationManager.getInstance().isCacheLocationChangeable();
    }

    public boolean isInstallLocationChangeable(Profile profile) {
        return profile.isInstallLocationChangeable();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.getPropertyChangeListeners().add((Object)listener);
    }

    public void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        Object[] listeners;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        Object[] objectArray = listeners = this.getPropertyChangeListeners().getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    private ListenerList getPropertyChangeListeners() {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ListenerList();
        }
        return this.propertyChangeListeners;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.getPropertyChangeListeners().remove((Object)listener);
    }

    public IStatus prepareOfferings(final IOfferingOrFix[] offeringOrFix) {
        final CicMultiStatus[] status = new CicMultiStatus[]{Statuses.ST.createMultiStatus()};
        int mode = AgentInput.getInstance().getMode();
        if (mode == 1 && offeringOrFix != null) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IOfferingOrFix[] iOfferingOrFixArray = offeringOrFix;
            int n = offeringOrFix.length;
            int n2 = 0;
            while (n2 < n) {
                IOfferingOrFix element = iOfferingOrFixArray[n2];
                status[0].add(this.getAgent().prepare(element, ExtensionCategory.ALL, (IProgressMonitor)monitor));
                ++n2;
            }
        } else {
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        status[0].add(SharedUIUtils.prepareOfferingsAndFixes((IOfferingOrFix[])offeringOrFix, (IProgressMonitor)monitor));
                    }
                });
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
        }
        if (!status[0].isOK()) {
            new ViewLogErrorDialog(AgentUI.getActiveWorkbenchShell()).open();
        }
        return status[0];
    }

    public void run(boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(AgentUI.getActiveWorkbenchShell(), CicCommonUiPlugin.getDefault().getLongOperationDelay());
        dialog.run(true, cancelable, runnable);
    }

    @Override
    public FormToolkit getFormToolkit() {
        return CicCommonUiPlugin.getDefault().getFormToolkit();
    }

    public void setTotalSizeMap(Map sizeMap) {
        Agent.getInstance().setTotalSizeMap(sizeMap);
    }

    @Override
    public Map getTotalSizeMap() {
        return Agent.getInstance().getTotalSizeMap();
    }

    public static void showPerspective(String perspectiveId, IWorkbenchWindow window) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveRegistry perspectiveRegistry = workbench.getPerspectiveRegistry();
        IPerspectiveDescriptor desc = perspectiveRegistry.findPerspectiveWithId(perspectiveId);
        IWorkbenchPage page = window.getActivePage();
        page.setPerspective(desc);
    }

    public void flushDialogSettings() {
        super.saveDialogSettings();
    }
}

