/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.AbstractNTLMMessageGenerator;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.AuthenticateMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMCrypto;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.SendMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.TargetInfo;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.httpclient.auth.AuthenticationException;

public class NTLMv2MessageGenerator
extends AbstractNTLMMessageGenerator {
    public NTLMv2MessageGenerator(NTLMUserCredentials userCredentials, String clientWorkStation) {
        super(userCredentials, clientWorkStation);
    }

    @Override
    protected byte[] createNegotiateMessage() throws IOException {
        return NegotiateMessage.createMessage();
    }

    @Override
    protected byte[] computeAuthenticateMessage() throws UnsupportedEncodingException, GeneralSecurityException, DecodeBytes.DecodeBytesException, IOException {
        this.computeResponse();
        int flags = 0x8207 & this.challenge.getNegotiateFlags();
        byte[] authenticate = AuthenticateMessage.createAuthenticateMessage(this.challenge, this.userCredentials, null, flags, this.lmChallengeResponse, this.ntChallengeResponse);
        return authenticate;
    }

    private void computeResponse() throws UnsupportedEncodingException, GeneralSecurityException, DecodeBytes.DecodeBytesException, AuthenticationException {
        byte[] time;
        TargetInfo.AVPair avp;
        assert (this.challenge.getChallenge().length == 8);
        String password = this.userCredentials.getPassword();
        byte[] random = NTLMv2MessageGenerator.genRandom(this.challenge);
        byte[] responseKeyNT = NTLMCrypto.NTOWFv2(password, this.userCredentials.getUsername(), this.userCredentials.getDomain());
        if (log.isDebugLoggable()) {
            log.debug("NTLMv2 computing using server challenge [{0}], client random [{1}]", new Object[]{BitUtil.bytesToHexString(this.challenge.getChallenge()), BitUtil.bytesToHexString(random)});
        }
        TargetInfo targetInfo = this.challenge.getTargetInfo();
        if (log.isDebugLoggable()) {
            LogNTLMMessage.logTargetInfo(log, 2, targetInfo);
        }
        TargetInfo.AVPair aVPair = avp = targetInfo != null ? targetInfo.getAVPair(7) : null;
        if (avp != null) {
            time = avp.getData();
            if (log.isDebugLoggable()) {
                log.debug("NTLMv2 computing using time from challenge.target info [{0}]", new Object[]{BitUtil.bytesToHexString(time)});
            }
        } else {
            time = this.getTime();
            if (log.isDebugLoggable()) {
                log.debug("NTLMv2 computing using current time [{0}]", new Object[]{BitUtil.bytesToHexString(time)});
            }
        }
        this.ntChallengeResponse = NTLMCrypto.v2NtChallengeResponse(responseKeyNT, time, targetInfo != null ? targetInfo.getData() : new byte[]{}, this.challenge.getChallenge(), random);
        this.lmChallengeResponse = NTLMCrypto.v2LmChallengeResponse(responseKeyNT, this.challenge.getChallenge(), random);
    }

    private byte[] getTime() {
        return NTLMCrypto.currenttime();
    }

    @Override
    public boolean isLoggingDetails() {
        return true;
    }

    private static class NegotiateMessage
    extends SendMessage {
        public static final int FLAGS = 33287;

        private NegotiateMessage() {
        }

        public static byte[] createMessage() throws IOException {
            int size = NTLMConstants.SIGNATURE_BYTES.length + 4 + 4 + 2 + 2 + 4 + 2 + 2 + 4;
            ByteArrayOutputStream bs = new ByteArrayOutputStream(size);
            bs.write(NTLMConstants.SIGNATURE_BYTES);
            NegotiateMessage.writeInt(bs, 1);
            NegotiateMessage.writeInt(bs, 33287);
            int offsetPtrUserDomain = NegotiateMessage.field(bs, 0);
            int offsetPtrWorkStation = NegotiateMessage.field(bs, 0);
            int pos = bs.size();
            byte[] buf = bs.toByteArray();
            pos = NegotiateMessage.writeData(buf, offsetPtrUserDomain, pos, EMPTY_BYTES);
            NegotiateMessage.writeData(buf, offsetPtrWorkStation, pos, EMPTY_BYTES);
            return buf;
        }
    }
}

