/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMFlags;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NTLMUtil
implements NTLMConstants {
    private static final Logger log;
    private static String oemEncoding;
    private static final Map maskToFlag;

    static {
        Field[] fields;
        log = CustomNTLM.log;
        maskToFlag = new HashMap();
        Field[] fieldArray = fields = NTLMFlags.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                String name = field.getName();
                try {
                    int value = field.getInt(null);
                    assert (value != 0);
                    int n3 = NTLMUtil.countbits(value);
                    assert (n3 == 1);
                    maskToFlag.put(value, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static String getOEMEncoding() {
        if (oemEncoding == null) {
            oemEncoding = "Cp850";
            try {
                "".getBytes(oemEncoding);
            }
            catch (UnsupportedEncodingException e) {
                oemEncoding = "US-ASCII";
                log.warning(Messages.NTLMUtil_encodingNotSupported, new Object[]{"Cp850", "US-ASCII"});
            }
        }
        return oemEncoding;
    }

    public static List getFlagNames(int flags) {
        ArrayList<String> list = new ArrayList<String>(NTLMUtil.countbits(flags));
        int mask = 1;
        int i = 0;
        while (i < 32) {
            if ((flags & mask) != 0) {
                String name = (String)maskToFlag.get(mask);
                list.add(0, name);
            }
            ++i;
            mask <<= 1;
        }
        return list;
    }

    public static String getFlagsDebugString(int flags) {
        return NLS.bind((String)"0x{0} {1}", (Object)Integer.toHexString(flags), (Object)NTLMUtil.getFlagNames(flags));
    }

    private static int countbits(int value) {
        int n = 0;
        int mask = 1;
        int i = 0;
        while (i < 32) {
            if ((value & mask) != 0) {
                ++n;
            }
            ++i;
            mask <<= 1;
        }
        return n;
    }
}

