/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLMPrefsHook;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.NtlmAuthGeneratorExtension;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGeneratorFactory;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMAuthGeneratorException;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import org.apache.commons.httpclient.HttpClient;
import org.eclipse.core.runtime.CoreException;

public class NTLMIntegrated
extends ICicPreferenceConstants {
    public static final Logger log = CustomNTLM.log;
    private INTLMAuthGeneratorFactory ntlmAuthFactory = null;
    private Integer failedLogEntry = null;

    public NTLMIntegrated(HttpClient httpClient, boolean enabled) {
        if (!enabled) {
            return;
        }
        try {
            this.ntlmAuthFactory = NtlmAuthGeneratorExtension.INSTANCE.getFactory(true);
            if (this.ntlmAuthFactory != null) {
                log.info(Messages.NTLMIntegrated_usingIntegratedNTLMAuthentication);
            }
        }
        catch (CoreException e) {
            LogEntry logEntry = log.status(e.getStatus());
            this.failedLogEntry = logEntry.getNum();
        }
    }

    public boolean isEnabled() {
        return this.ntlmAuthFactory != null || this.failedLogEntry != null;
    }

    public static NTLMIntegrated init(HttpClient httpClient, NTLMIntegrated previous, boolean forceProviderReinit) {
        String pref = "http.ntlm.auth.enableIntegrated." + CicCommonSettings.getOs();
        boolean enableIntegrated = CustomNTLMPrefsHook.getPreferenceProvider().getBoolean(pref, false);
        if (previous == null) {
            return new NTLMIntegrated(httpClient, enableIntegrated);
        }
        if (!forceProviderReinit && previous.isEnabled() == enableIntegrated) {
            log.debug("Skipping reinitialization of ntlmAuthFactory as preference has not changed: {0}={1}", new Object[]{pref, enableIntegrated});
            return previous;
        }
        if (!forceProviderReinit) {
            log.debug("Reinitialization of ntlmAuthFactory as preference has changed: {0}={1}.", new Object[]{pref, enableIntegrated});
        }
        return new NTLMIntegrated(httpClient, enableIntegrated);
    }

    public INTLMAuthGenerator newNTLMMessageGenerator(NTLMUserCredentials userCredentials) throws NTLMAuthGeneratorException {
        if (this.ntlmAuthFactory == null) {
            throw new NTLMAuthGeneratorException(NLS.bind((String)Messages.NTLMIntegrated_loadingIntegratedNTLMAuthenticationFailes, (Object)this.failedLogEntry));
        }
        return this.ntlmAuthFactory.createAuthGenerator(userCredentials);
    }
}

