/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.notify;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class Utils {
    private static final String AGENT_UNKNOWN = "Unknown agent version";
    public static final String PARAMETER_UID = "uniqueId";
    public static final String PAREMETER_OS = "os";
    public static final String PARAMETER_EXECUTABLE_NAME = "executableName";
    private static Properties iwmMessageProperties = new Properties();

    static {
        iwmMessageProperties.setProperty(PARAMETER_EXECUTABLE_NAME, Utils.getAgentVersionDescription());
        iwmMessageProperties.setProperty(PARAMETER_UID, Agent.getInstance().getUniqueInstanceId());
        iwmMessageProperties.setProperty(PAREMETER_OS, Utils.getOS());
    }

    private static String getAgentVersionDescription() {
        IOffering offering = Agent.getInstance().getAgentOffering();
        if (offering == null) {
            return AGENT_UNKNOWN;
        }
        return String.valueOf(offering.getInformation().getDescription()) + " " + offering.getVersion().toString();
    }

    private static String getOS() {
        String os = Platform.getOS();
        if (os.equals("win32")) {
            if (CicCommonSettings.isWindows7()) {
                return "win7";
            }
            if (CicCommonSettings.isWindows8()) {
                return "win8";
            }
            if (CicCommonSettings.isWindows10()) {
                return "win10";
            }
            if (CicCommonSettings.isWindowsVista()) {
                return "vista";
            }
            if (CicCommonSettings.isWindows2008Server()) {
                return "win2008server";
            }
            if (CicCommonSettings.isWindows2008ServerR2()) {
                return "win2008serverR2";
            }
            if (CicCommonSettings.isWindows2012Server()) {
                return "win2012server";
            }
            if (CicCommonSettings.isWindows2016Server()) {
                return "win2016server";
            }
            if (CicCommonSettings.isWindowsXP()) {
                return "winxp";
            }
        }
        return os;
    }

    public static Properties getIwmMessageProperties() {
        return iwmMessageProperties;
    }
}

