/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.internal.core.history.IHistory;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.agent.internal.core.history.ProfileIdentity;
import com.ibm.cic.agent.internal.core.history.impl.FileCache;
import com.ibm.cic.agent.internal.core.history.impl.HistoryImpl;
import java.io.File;
import java.io.IOException;

public class ProfileInfoImpl
implements IProfileInfo {
    private ProfileIdentity profileIdentity = null;
    private File historyFile;
    private final FileCache fileCache = FileCache.getInstance();

    public ProfileInfoImpl(ProfileIdentity profileIdentity, File historyFile) {
        this.profileIdentity = profileIdentity;
        this.historyFile = historyFile;
    }

    @Override
    public ProfileIdentity getProfileIdentity() {
        return this.profileIdentity;
    }

    @Override
    public IHistory getHistory() {
        String historyFilePath = this.getHistoryFilePath();
        IHistory history = (IHistory)this.fileCache.getFileObject(historyFilePath);
        if (history == null) {
            history = new HistoryImpl(this);
            this.fileCache.putFileObject(historyFilePath, history);
        }
        return history;
    }

    @Override
    public String getHistoryFilePath() {
        try {
            return this.historyFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void setHistoryFile(File historyFile) {
        String oldFilePath = this.getHistoryFilePath();
        this.historyFile = historyFile;
        if (this.fileCache.getFileObject(oldFilePath) != null) {
            this.fileCache.moveFileObject(oldFilePath, this.getHistoryFilePath());
        }
    }
}

