/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.debug;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugValue;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugValue;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import java.io.IOException;
import java.rmi.server.UnicastRemoteObject;

public class InstallOperationDebugVariable
extends UnicastRemoteObject
implements IInstallOperationDebugVariable {
    private static final long serialVersionUID = 1L;
    private static final CicCommonCorePluginTrace trace = AgentActivator.getDefault().getTrace();
    public static final IInstallOperationDebugVariable[] EMPTY_VARIABLES = new IInstallOperationDebugVariable[0];
    private final String name;
    private final InstallOperationDebugValue value;

    public InstallOperationDebugVariable(String name, InstallOperationDebugValue value) throws IOException {
        this.name = name;
        this.value = value;
        value.variable = this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + ": " + this.value.toString();
    }

    public String getName() {
        trace.entering();
        trace.exiting((Object)this.name);
        return this.name;
    }

    public String getTypeName() {
        return this.value.getTypeName();
    }

    public IInstallOperationDebugValue getValue() {
        trace.entering();
        trace.exiting((Object)this.value);
        return this.value;
    }

    public boolean supportsValueModification() {
        trace.entering();
        boolean supportsModification = this.value.supportsModification();
        trace.exiting((Object)supportsModification);
        return supportsModification;
    }

    public boolean verifyValue(String expression) {
        trace.entering((Object)expression);
        boolean result = this.value.verifyValue(expression);
        trace.exiting((Object)result);
        return result;
    }

    public void setValue(String expression) {
        trace.entering((Object)expression);
        this.value.setValue(expression);
        trace.exiting();
    }

    protected static InstallOperationDebugVariable createArrayVariable(String name, InstallOperationDebugValue parentValue, InstallOperationDebugValue.TypeInfo elementTypeInfo) throws IOException {
        InstallOperationDebugValue.ArrayValue val = new InstallOperationDebugValue.ArrayValue(parentValue, elementTypeInfo);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createPropertiesVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.PropertiesValue val = new InstallOperationDebugValue.PropertiesValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createStringVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.StringValue val = new InstallOperationDebugValue.StringValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createIntVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.IntValue val = new InstallOperationDebugValue.IntValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createBooleanVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.BooleanValue val = new InstallOperationDebugValue.BooleanValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createWhenVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.WhenValue val = new InstallOperationDebugValue.WhenValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createForceStatusVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.ForceStatusValue val = new InstallOperationDebugValue.ForceStatusValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createOperationVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Operation val = new InstallOperationDebugValue.Operation(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createResumeActionVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.ResumeActionValue val = new InstallOperationDebugValue.ResumeActionValue(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createUnitVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Unit val = new InstallOperationDebugValue.Unit(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createPairVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Pair val = new InstallOperationDebugValue.Pair(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createContextVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Context val = new InstallOperationDebugValue.Context(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createEngineOperationVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.EngineOperation val = new InstallOperationDebugValue.EngineOperation(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createPackageVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Package val = new InstallOperationDebugValue.Package(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createPackageGroupVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.PackageGroup val = new InstallOperationDebugValue.PackageGroup(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createFeatureVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Feature val = new InstallOperationDebugValue.Feature(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createJobVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.Job val = new InstallOperationDebugValue.Job(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }

    protected static InstallOperationDebugVariable createInstallInfoVariable(String name, InstallOperationDebugValue parentValue) throws IOException {
        InstallOperationDebugValue.InstallInfo val = new InstallOperationDebugValue.InstallInfo(parentValue);
        return new InstallOperationDebugVariable(name, val);
    }
}

