/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.template.ICustomPanelGenerator;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.ITemplateCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class TemplateCommonCustomPanelFactory
extends TemplateCustomPanelFactory
implements ITemplateCustomPanelFactory {
    private static final String TAG_TEMPLATE_COMMON_CUSTOM_PANELS = "templateCommonCustomPanel";
    private static final String PROJECT_TO_SKIP_IU_CHECK = "com.ibm.cic.agent.core.tests";
    private static final TemplateCommonCustomPanelFactory INSTANCE = new TemplateCommonCustomPanelFactory();

    public static TemplateCommonCustomPanelFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public CustomPanelJobPair[] createCustomPanels(Class<? extends ICustomPanel> panelType, ICustomPanelGenerator customPanelGenerator, WizardType wizardType, AgentJob[] allProductJobs, boolean isMultipleProfile) throws CoreException {
        List<CustomPanelWrapperProfilePair> pairs = this.getCustomPanelWrapperProfilePairsFromExtensions(allProductJobs, false, isMultipleProfile);
        if (pairs.isEmpty()) {
            return new CustomPanelJobPair[0];
        }
        LinkedList<CustomPanelJobPair> result = new LinkedList<CustomPanelJobPair>();
        for (CustomPanelWrapperProfilePair pair : pairs) {
            CustomPanelWrapper wrapper = pair.cpWrapper;
            ICustomPanel customPanel = customPanelGenerator.generateCustomPanel(wrapper);
            if (customPanel == null) continue;
            if (!panelType.isInstance(customPanel)) {
                throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)"Instance of class {0} is expected; actual type is {1}.", (Object)panelType.getName(), (Object)customPanel.getClass().getName())));
            }
            CustomPanelJobPair cpJobPair = new CustomPanelJobPair(customPanel, null);
            cpJobPair.setProfile(pair.profileWithCP);
            result.add(cpJobPair);
        }
        return result.toArray(new CustomPanelJobPair[result.size()]);
    }

    @Override
    public CustomPanelWrapper[] createCustomPanelTemplates(AgentJob[] allProductJobs) throws CoreException {
        List<CustomPanelWrapperProfilePair> pairs = this.getCustomPanelWrapperProfilePairsFromExtensions(allProductJobs, true, false);
        if (pairs.isEmpty()) {
            return new CustomPanelWrapper[0];
        }
        LinkedList<CustomPanelWrapper> result = new LinkedList<CustomPanelWrapper>();
        for (CustomPanelWrapperProfilePair pair : pairs) {
            result.add(pair.cpWrapper);
        }
        return result.toArray(new CustomPanelWrapper[result.size()]);
    }

    private List<CustomPanelWrapperProfilePair> getCustomPanelWrapperProfilePairsFromExtensions(AgentJob[] allProductJobs, boolean isSilentInstall, boolean isMultipleProfile) throws CoreException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.core", TAG_TEMPLATE_COMMON_CUSTOM_PANELS);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            return Collections.EMPTY_LIST;
        }
        WizardType wizardType = SharedUIUtils.decideFlowType(allProductJobs);
        if (wizardType == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<CustomPanelWrapperProfilePair> result = new LinkedList<CustomPanelWrapperProfilePair>();
        Collection<AgentJob[]> jobArrays = this.getSortedJobs(allProductJobs, isSilentInstall, isMultipleProfile, wizardType.equals(WizardType.UNINSTALL));
        for (IAgentJob[] iAgentJobArray : jobArrays) {
            LinkedHashMap<IExtension, OfferingAndBundleNum> extensionsInJob = new LinkedHashMap<IExtension, OfferingAndBundleNum>();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IContributor contributor = extension.getContributor();
                String name = contributor.getName();
                if (SharedUIUtils.nameIsInJobs(name, (AgentJob[])iAgentJobArray, new String[]{PROJECT_TO_SKIP_IU_CHECK})) {
                    OfferingAndBundleNum offeringAndBundleNum = this.getOfferingAndBundleNum(name, (AgentJob[])iAgentJobArray);
                    extensionsInJob.put(extension, offeringAndBundleNum);
                }
                ++n2;
            }
            if (extensionsInJob.isEmpty()) continue;
            Profile profile = iAgentJobArray[0].getProfile();
            int extensionCount = 0;
            ArrayList<TemplateCustomPanelFactory.TemplatePanelDefinition> panelExtensions = new ArrayList<TemplateCustomPanelFactory.TemplatePanelDefinition>();
            for (Map.Entry entry : extensionsInJob.entrySet()) {
                IExtension extension = (IExtension)entry.getKey();
                OfferingAndBundleNum offAndBundleNum = (OfferingAndBundleNum)entry.getValue();
                this.parseTemplatePanelDefinitions(extension.getConfigurationElements(), panelExtensions, offAndBundleNum.offeringNum, offAndBundleNum.bundleNum, ++extensionCount, 0);
            }
            ProfileTemplatePanelExtList profileTemplatePanelExtList = new ProfileTemplatePanelExtList(profile);
            profileTemplatePanelExtList.addTemplatePanels(panelExtensions);
            List<TemplateCustomPanelFactory.TemplatePanelDefinition> sortedPanels = profileTemplatePanelExtList.getSortedPanelDefinition();
            for (TemplateCustomPanelFactory.TemplatePanelDefinition commonPanelExt : sortedPanels) {
                CustomPanelWrapper cpTemplateWrapper;
                if (!commonPanelExt.getWizardTypes().contains(wizardType.getType()) || (cpTemplateWrapper = commonPanelExt.createCustomPanelTemplateInstance()) == null) continue;
                try {
                    CustomPanelData data = new CustomPanelData(allProductJobs, iAgentJobArray);
                    cpTemplateWrapper.initCustomPanelData(data);
                    if (!cpTemplateWrapper.canAddPanelToWizard()) continue;
                    result.add(new CustomPanelWrapperProfilePair(cpTemplateWrapper, profileTemplatePanelExtList.getProfile()));
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus(null, cpTemplateWrapper.getPanelTitle(), (Throwable)e);
                    throw new CoreException(status);
                }
            }
        }
        return result;
    }

    private OfferingAndBundleNum getOfferingAndBundleNum(String bundleName, AgentJob[] jobs) {
        int i = 0;
        while (i < jobs.length) {
            int bundleNum = SharedUIUtils.getOfferingBundleNum(bundleName, jobs[i]);
            if (bundleNum != 0) {
                return new OfferingAndBundleNum(i + 1, bundleNum);
            }
            ++i;
        }
        return new OfferingAndBundleNum(0, 0);
    }

    private static class CustomPanelWrapperProfilePair {
        CustomPanelWrapper cpWrapper;
        Profile profileWithCP;

        CustomPanelWrapperProfilePair(CustomPanelWrapper wrapper, Profile profile) {
            this.cpWrapper = wrapper;
            this.profileWithCP = profile;
        }
    }

    private static class OfferingAndBundleNum {
        int offeringNum;
        int bundleNum;

        OfferingAndBundleNum(int a_offeringNum, int a_bundleNum) {
            this.offeringNum = a_offeringNum;
            this.bundleNum = a_bundleNum;
        }
    }

    private static class ProfileTemplatePanelExtList
    extends TemplateCustomPanelFactory.BaseTemplatePanelExtList {
        private final Profile profile;

        public ProfileTemplatePanelExtList(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }
}

