/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.AgentContextState;
import com.ibm.cic.agent.core.internal.expander.AgentSelectorExpander;
import com.ibm.cic.agent.core.internal.expander.CompatibilityCheck;
import com.ibm.cic.agent.core.internal.expander.ExpanderCache;
import com.ibm.cic.agent.core.internal.expander.IExpanderInput;
import com.ibm.cic.agent.core.internal.expander.InstallContextMerger;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ExpansionResult
implements IExpanderInput {
    private Profile profile;
    private final AgentJob[] jobs;
    private final Map<IOffering, Collection<IFeature>> offerings;
    private final Set<IFix> fixes;
    private final AgentContextState contextState;
    private IStatus status;
    private boolean doCompatibilityCheck = false;
    private final boolean hasToleranceError;
    private InstallContextTree contextTree = null;
    private ExpanderCache expanderCache = null;

    public static ExpansionResult expand(Profile profile, IProgressMonitor monitor) {
        return new AgentSelectorExpander(profile).expandCached(monitor);
    }

    public static ExpansionResult expand(AgentJob[] jobs, IProgressMonitor monitor) {
        return new AgentSelectorExpander(jobs, true).expandCached(monitor);
    }

    static ExpansionResult expandWithoutInstalled(AgentJob[] jobs, IProgressMonitor monitor) {
        return new AgentSelectorExpander(jobs, false).expandCached(monitor);
    }

    static ExpansionResult success(AgentSelectorExpander expander, AgentContextState contextState) {
        return new ExpansionResult(expander, contextState, Status.OK_STATUS, false, false);
    }

    static ExpansionResult failure(AgentSelectorExpander expander, IStatus status, boolean doCompatibilityCheck, boolean hasToleranceError) {
        return new ExpansionResult(expander, null, status, doCompatibilityCheck, hasToleranceError || status.getCode() == 9001);
    }

    private ExpansionResult(AgentSelectorExpander expander, AgentContextState contextState, IStatus status, boolean doCompatibilityCheck, boolean hasToleranceError) {
        assert (!status.isOK() || contextState != null);
        this.profile = expander.getProfile();
        this.jobs = expander.getJobs();
        this.offerings = expander.getOfferings();
        this.fixes = expander.getFixes();
        this.status = status;
        this.contextState = contextState;
        this.doCompatibilityCheck = doCompatibilityCheck;
        this.hasToleranceError = hasToleranceError;
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            assert (job.getProfile() == this.profile);
            ++n2;
        }
    }

    void setCache(ExpanderCache expanderCache) {
        this.expanderCache = expanderCache;
    }

    void reset(Profile newProfile) {
        this.profile = newProfile;
        this.contextTree = null;
    }

    public void clearCache() {
        if (this.expanderCache != null) {
            this.expanderCache.clearCache();
        }
    }

    public IContextState getRootContext() {
        return this.contextState;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public AgentJob[] getJobs() {
        return this.jobs;
    }

    @Override
    public Map<IOffering, Collection<IFeature>> getOfferings() {
        return this.offerings;
    }

    @Override
    public Set<IFix> getFixes() {
        return this.fixes;
    }

    public boolean isOK() {
        return this.status.isOK();
    }

    public boolean isCancel() {
        return StatusUtil.isCancel((IStatus)this.status);
    }

    public IStatus getStatus() {
        if (!this.isOK() && !this.isCancel() && this.doCompatibilityCheck) {
            this.doCompatibilityCheck = false;
            this.status = new CompatibilityCheck(this.profile, this.status).perform(this.jobs, this.jobs.length);
        }
        return this.status;
    }

    public boolean hasToleranceError() {
        return this.hasToleranceError;
    }

    public IStatus saveInstallRegistry(IProgressMonitor monitor) {
        InstallRegistry.ProfileInstallRegistry registry = this.getProfile().getInstallRegistry();
        registry.markInstalledOfferings(this.getOfferings());
        registry.markInstalledFixes(this.getFixes());
        registry.clearIUs();
        for (InstallContextTree tree : this.getFullContextTree()) {
            InstallRegistry.ContextInstallRegistry contextRegistry = tree.getInstallRegistry();
            for (InstallableUnitPair pair : tree.getOriginalPairs()) {
                if (pair.getTo() == null) continue;
                contextRegistry.markInstalled(pair.getTo());
            }
        }
        try {
            registry.commit(monitor);
            InstallRegistry.getInstance().purgeMetadata();
        }
        catch (CoreException e) {
            return Statuses.ERROR.get((Throwable)e, Messages.Director_Error_Saving_Install_Registry, new Object[]{e.getMessage()});
        }
        return Status.OK_STATUS;
    }

    public InstallContextTree getRootContextTree() {
        if (this.contextTree == null && this.contextState != null) {
            this.contextTree = new InstallContextTree(this.profile, this.contextState);
            this.resolveInstallContexts();
        }
        return this.contextTree;
    }

    public List<InstallContextTree> getFullContextTree() {
        return this.getRootContextTree().getFullTree();
    }

    private void resolveInstallContexts() {
        this.fixRootInstallContext();
        if (InstallRegistry.getInstance().getProfile(this.profile.getProfileId()) != null) {
            this.contextTree.resolveInstallContexts(this.getOneOffering());
        }
        InstallContextMerger.merge(this.contextTree, null);
    }

    private void fixRootInstallContext() {
        InstallContext rootContext = this.profile.getRootContext();
        if (rootContext.getProperty("configLocation") == null && this.contextTree.getSubTrees().isEmpty() && rootContext.getSubcontexts().length == 0) {
            File config = new File(rootContext.getProperty("installLocation"), "configuration");
            rootContext.setLocalProperty("configLocation", config.getPath());
            rootContext.setCreatedDirectory(config);
            rootContext.addAdaptorType("eclipse");
        }
    }

    private IOffering getOneOffering() {
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                return offering;
            }
            ++n2;
        }
        return null;
    }

    public void setProfileIntuitiveInstallOrder(boolean b) {
        String prev;
        String s = String.valueOf(b);
        if (!s.equals(prev = this.profile.getData(Profile.INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED))) {
            this.profile.setData(Profile.INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED, s);
        }
    }

    public IStatus getCapabilityStatus() {
        ArrayList<AbstractMap.SimpleEntry<String, VersionRange>> suppliedCapabilities = new ArrayList<AbstractMap.SimpleEntry<String, VersionRange>>();
        ArrayList<IOffering> baseOfferings = new ArrayList<IOffering>();
        for (IOffering offering : this.offerings.keySet()) {
            if (offering == null) continue;
            if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                String capabilityProp = OfferingProperty.getProvidesExtensionCapability((IOfferingOrFix)offering);
                String capId = OfferingProperty.extractCapabilityId((String)capabilityProp);
                VersionRange tolerance = OfferingProperty.extractCapabilityVersion((String)capabilityProp);
                suppliedCapabilities.add(new AbstractMap.SimpleEntry<String, VersionRange>(capId, tolerance));
                continue;
            }
            baseOfferings.add(offering);
        }
        block1: for (IOffering offering : baseOfferings) {
            String[] capabilitySet;
            String requiredCapabilities;
            int n;
            String excludedProperty = OfferingProperty.getCapabilityPlatformExclusions((IOfferingOrFix)offering);
            HashMap<String, String> excludedCapsByPlatform = new HashMap<String, String>();
            if (excludedProperty != null && !excludedProperty.isEmpty()) {
                String[] excludeProps;
                String[] stringArray = excludeProps = excludedProperty.split(";");
                n = excludeProps.length;
                int n2 = 0;
                while (n2 < n) {
                    String excludeProp = stringArray[n2];
                    String[] capAndPlatforms = excludeProp.split(":");
                    excludedCapsByPlatform.put(capAndPlatforms[0], capAndPlatforms[1]);
                    ++n2;
                }
            }
            if ((requiredCapabilities = OfferingProperty.getRequiresExtensions((IOfferingOrFix)offering)) == null || requiredCapabilities.isEmpty()) continue;
            String[] stringArray = capabilitySet = requiredCapabilities.split(";");
            int n3 = capabilitySet.length;
            n = 0;
            while (n < n3) {
                PlatformFilter platformFilter;
                String capabilityProp = stringArray[n];
                String[] props = capabilityProp.split(":");
                String capability = props[0];
                String capId = OfferingProperty.extractCapabilityId((String)capability);
                VersionRange capVersion = OfferingProperty.extractCapabilityVersion((String)capability);
                Boolean capabilitySatisfied = false;
                String excludedPlatforms = (String)excludedCapsByPlatform.get(capId);
                if (excludedPlatforms != null && (platformFilter = new PlatformFilter(excludedPlatforms)).matchesPlatform(Platform.getOS(), Platform.getOSArch()).isOK()) continue block1;
                for (AbstractMap.SimpleEntry simpleEntry : suppliedCapabilities) {
                    if (capabilitySatisfied.booleanValue()) break;
                    if (!capId.equals(simpleEntry.getKey()) || ((VersionRange)simpleEntry.getValue()).intersection(new org.osgi.framework.VersionRange[]{capVersion}).isEmpty()) continue;
                    capabilitySatisfied = true;
                }
                if (!capabilitySatisfied.booleanValue()) {
                    String string = OfferingProperty.getCapabilityName((IOfferingOrFix)offering, (String)capId);
                    return Statuses.ERROR.get(Messages.UnsatisfiedOfferingCapabilityDuringUninstall, new Object[]{offering.getName(), string});
                }
                ++n;
            }
        }
        return Status.OK_STATUS;
    }
}

