/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class AgentContextState
implements IContextState {
    private final IIdentity id;
    private final IContextState parent;
    private final IInstallationContext ic;
    private final boolean hasToleranceError;
    private final Map<IIdentity, AgentContextState> subContexts = new LinkedHashMap<IIdentity, AgentContextState>(2);
    private final List<IShareableEntity> ses;
    private final List<IInstallableUnit> ius;
    private final MapSet<IShareableEntity, IContentSelector> selections;

    static AgentContextState create(IContextState original, Map<IIdentity, Version> selected) throws CoreException {
        original.checkRSEs(selected);
        Collection candidateSEs = original.getShareableEntities();
        ArrayList<IShareableEntity> ses = new ArrayList<IShareableEntity>(candidateSEs.size());
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(2 * candidateSEs.size());
        MapSet selections = MapSet.newLinkedHash();
        for (IShareableEntity se : Util.join((Iterable)candidateSEs, (Iterable)original.getParentSEs())) {
            if (!se.getVersion().equals((Object)selected.get(se.getIdentity()))) continue;
            ses.add(se);
            ius.addAll(original.getIUs((IShareableItem)se));
            selections.addAll((Object)se, (Collection)original.getSelected(se));
        }
        MapSet candidateFragments = original.getSuFragments();
        for (IIdentity id : candidateFragments.keySet()) {
            Set fragments;
            Version version = selected.get(id);
            ISuFragment fragment = AgentContextState.findByVersion(version, fragments = candidateFragments.get((Object)id));
            if (fragment != null) {
                ius.addAll(original.getIUs((IShareableItem)fragment));
                continue;
            }
            AgentContextState.checkFragmentStrictness(selected, fragments);
        }
        return new AgentContextState(original.getIdentity(), original.getParent(), original.getInstallationContext(), original.hasToleranceError(), ses, ius, (MapSet<IShareableEntity, IContentSelector>)selections);
    }

    private static ISuFragment findByVersion(Version version, Set<ISuFragment> fragments) {
        for (ISuFragment fragment : fragments) {
            if (!fragment.getVersion().equals((Object)version)) continue;
            return fragment;
        }
        return null;
    }

    private static void checkFragmentStrictness(Map<IIdentity, Version> selected, Set<ISuFragment> fragments) throws CoreException {
        for (ISuFragment f : fragments) {
            Version suVersion;
            if (!f.isStrict() || (suVersion = selected.get(f.getTargetId())) == null || f.getTargetTolerance().getMinimum().compareTo(suVersion) <= 0) continue;
            throw new CoreException((IStatus)Statuses.ERROR.get(208, Messages.ContextState_Strict_Fragment_Does_Not_Apply, new Object[]{f.getIdentity(), f.getVersion(), f.getTargetId(), suVersion}));
        }
    }

    private AgentContextState(IIdentity id, IContextState parent) {
        this(id, parent, null, false, Collections.emptyList(), Collections.emptyList(), (MapSet<IShareableEntity, IContentSelector>)MapSet.empty());
    }

    private AgentContextState(IIdentity id, IContextState parent, IInstallationContext ic, boolean hasToleranceError, List<IShareableEntity> ses, List<IInstallableUnit> ius, MapSet<IShareableEntity, IContentSelector> selections) {
        this.id = id;
        this.parent = parent;
        this.ic = ic;
        this.hasToleranceError = hasToleranceError;
        this.ses = ses;
        this.ius = ius;
        this.selections = selections;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append(this.isRoot() ? "root" : this.id.getId()).append(" (");
        sb.append(this.getShareableEntities().size()).append(" SEs");
        if (!this.getSubContexts().isEmpty()) {
            sb.append(' ').append(this.getSubContexts());
        }
        sb.append(')');
        return sb.toString();
    }

    public Collection<IShareableEntity> getShareableEntities() {
        return this.ses;
    }

    public Collection<IInstallableUnit> getIUs() {
        return this.ius;
    }

    public Collection<AgentContextState> getSubContexts() {
        return Collections.unmodifiableCollection(this.subContexts.values());
    }

    void addSubContext(AgentContextState subContext) {
        this.subContexts.put(subContext.getIdentity(), subContext);
    }

    public void ensureSubContext(IIdentity childId) {
        if (!this.subContexts.containsKey(childId)) {
            this.subContexts.put(childId, new AgentContextState(childId, this));
        }
    }

    public String getFullId() {
        if (this.isRoot()) {
            return "<root>";
        }
        if (this.parent.isRoot()) {
            return this.id.getId();
        }
        return String.valueOf(this.parent.getFullId()) + '/' + this.id.getId();
    }

    public IIdentity getIdentity() {
        return this.id;
    }

    public IInstallationContext getInstallationContext() {
        return this.ic;
    }

    public IContextState getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasToleranceError() {
        return this.hasToleranceError;
    }

    public List<IInstallableUnit> getIUs(IShareableItem si) {
        throw new UnsupportedOperationException();
    }

    public Set<IShareableEntity> getParentSEs() {
        throw new UnsupportedOperationException();
    }

    public Set<IContentSelector> getSelected(IShareableEntity se) {
        return this.selections.get((Object)se);
    }

    public Map<IIdentity, VersionRange> getTolerances(IShareableEntity se) {
        throw new UnsupportedOperationException();
    }

    public void checkRSEs(Map<IIdentity, Version> selectedSEs) {
        throw new UnsupportedOperationException();
    }

    public MapSet<IIdentity, ISuFragment> getSuFragments() {
        throw new UnsupportedOperationException();
    }

    public List<IInstallableUnit> getSelectedIUs(IShareableUnit su, ISuFragment fragment) {
        throw new UnsupportedOperationException();
    }

    public MapList<ISuFragment, IShareableUnit> getFragmentMap() {
        throw new UnsupportedOperationException();
    }
}

