/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.LockedFilesChecker;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractAcceptLicenseCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.RollbackCommand;
import com.ibm.cic.agent.core.internal.commands.UninstallCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IAbstractInstallCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.CmdRepositoryUtils;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.SilentRepositoryUtils;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

abstract class AbstractInstallCommand
extends AbstractAcceptLicenseCommand
implements IAbstractInstallCommand {
    private final List actualProfiles = new ArrayList();
    private boolean agentUpdate = false;
    private static final Logger log = Logger.getLogger(AbstractInstallCommand.class);

    protected AbstractInstallCommand(String name) {
        super(name);
    }

    protected abstract IStatus execute(Agent var1, AgentJob[] var2, IProgressMonitor var3);

    protected abstract AgentJob[] getAsInputJob(Agent var1, XMLElement var2, boolean var3, Profile var4);

    private Profile findProfile(Agent agent, String id) {
        String installationDirectory = CmdLine.CL.getInstallationDirectory();
        if (installationDirectory != null) {
            return agent.getProfileByInstallLocation(installationDirectory);
        }
        List pList = agent.getProfilesByOfferingOrFixId(id);
        if (pList.size() == 1) {
            return (Profile)pList.get(0);
        }
        return null;
    }

    protected List getOfferingsToOpenServiceRepositories(Agent agent, String id, String version, IProgressMonitor monitor) {
        Profile p = this.findProfile(agent, id);
        if (p != null) {
            IOffering[] installedOfferings = agent.getInstalledOfferings(p);
            ArrayList<IOffering> offerings = new ArrayList<IOffering>(installedOfferings.length + 1);
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                offerings.add(installedOffering);
                ++n2;
            }
            return offerings;
        }
        return new ArrayList(1);
    }

    private IStatus handleOpenServiceRepositoryStatus(Agent agent, IStatus status) {
        if (status.isOK() || status.matches(1)) {
            return status;
        }
        if (!status.matches(2)) {
            status = MultiStatusUtil.recodeLevel((IStatus)status, (int)2);
        }
        OutputFormatter output = agent.getStdoutBuffer();
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        CmdUtils.reportNotOKResult((IStatus)status, (PrintWriter)pWriter, (PrintWriter)pWriter);
        output.appendNT(sWriter.toString());
        return status;
    }

    private void openServiceRepositories(Agent agent, IProgressMonitor monitor) {
        if (CmdLine.CL.getResponseFile() != null) {
            return;
        }
        if (CmdLine.CL.isConsoleMode()) {
            return;
        }
        if (!CmdRepositoryUtils.useServiceRepositoryCmd((ACmdLine)CmdLine.CL)) {
            return;
        }
        ArrayList offerings = new ArrayList();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.getNumChildren() + 1);
        for (XMLElement child : this.children()) {
            if (!child.getName().equals("offering")) continue;
            String id = child.getAttribute("id");
            String version = child.getAttribute("version");
            offerings.addAll(this.getOfferingsToOpenServiceRepositories(agent, id, version, spm.next()));
        }
        if (offerings.size() > 0) {
            CicMultiStatus s = SilentRepositoryUtils.openServiceRepositories((boolean)true, (IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])offerings.toArray(new IOffering[offerings.size()]), (IProgressMonitor)spm.next());
            this.handleOpenServiceRepositoryStatus(agent, (IStatus)s);
        }
        spm.done();
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    private IStatus checkPortableStatus(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob aj = agentJobArray[n2];
            Profile profile = aj.getProfile();
            if (profile != null) {
                if (profile.isPortable() && !CicCommonSettings.isPortable()) {
                    return Statuses.ERROR.get(Messages.AbstractInstallCommand_Portable_package_without_portable_switch, new Object[]{profile.getProfileId()});
                }
                if (CicCommonSettings.isPortable() && !OfferingOrFixProperty.supportsPortable((IOfferingOrFix)aj.getOfferingOrFix())) {
                    return Statuses.ERROR.get(Messages.AbstractInstallCommand_Offering_does_not_support_portable, new Object[]{profile.getProfileId()});
                }
                if (!profile.isPortable() && CicCommonSettings.isPortable()) {
                    return Statuses.ERROR.get(Messages.AbstractInstallCommand_Non_portable_package_with_portable_switch, new Object[]{profile.getProfileId()});
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    @Override
    public final IStatus execute(Agent agent, IProgressMonitor monitor) {
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 2, 36});
        try {
            if (CmdLine.CL.getResponseFile() == null && !CmdLine.CL.isConsoleMode()) {
                result.add(this.checkInstalledAtOneLocation(this.isModify()));
                if (result.isErrorOrCancel()) {
                    CicMultiStatus cicMultiStatus = result;
                    return cicMultiStatus;
                }
            }
            this.openServiceRepositories(agent, spm.next());
            AgentJob[] agentJobs = this.getAsInputJobs(agent, false);
            IStatus status = this.checkPortableStatus(agentJobs);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            IProgressMonitor iauMon = spm.next();
            if (!AbstractInstallCommand.isAgentUninstallOnly(agentJobs)) {
                boolean agentUpdateOnly;
                boolean bl = agentUpdateOnly = this.agentUpdate && agentJobs.length < 1;
                if (this.installAgentUpdate(agent, result, agentUpdateOnly, iauMon)) {
                    CicMultiStatus cicMultiStatus = result;
                    return cicMultiStatus;
                }
            }
            try {
                AgentJob[] agentJobArray = agentJobs = this.getSelectedJobs(agentJobs);
                int n = agentJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob agentJob = agentJobArray[n2];
                    agentJob.setRelatedJobs(agentJobs);
                    ++n2;
                }
                ArrayList<AgentJob> jobs = new ArrayList<AgentJob>();
                AgentJob[] agentJobArray2 = agentJobs;
                int n3 = agentJobs.length;
                n = 0;
                while (n < n3) {
                    AgentJob job = agentJobArray2[n];
                    if (job.isError()) {
                        result.add(((ErrorJob)job).getErrorStatus());
                    } else {
                        IStatus platformsStatus;
                        IOffering offering = job.getOffering();
                        if (offering != null && !AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet() && !OfferingProperty.isSupportedOS((IOffering)offering)) {
                            result.add((IStatus)Statuses.ERROR.get(Messages.AbstractInstallCommand_NotSupportedOS, new Object[]{offering.getName(), offering.getVersion()}));
                            break;
                        }
                        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                        if (offeringOrFix != null && !AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet() && !(platformsStatus = AbstractInstallCommand.checkPlatformSupport(agent, job)).isOK()) {
                            result.add(platformsStatus);
                            break;
                        }
                        if (job instanceof InstallJob || job instanceof RollbackJob) {
                            if (offering != null && OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)offering)) {
                                result.add((IStatus)Statuses.ERROR.get(Messages.AbstractInstallCommand_NonAdminError0, new Object[]{offering.getName(), offering.getVersion()}));
                                break;
                            }
                            if (offering != null && OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)offering)) {
                                result.add((IStatus)Statuses.ERROR.get(Messages.OfferingsDoNotSupportGroupMode, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)}));
                                break;
                            }
                        }
                        jobs.add(job);
                        this.actualProfiles.add(job.getProfile());
                    }
                    ++n;
                }
                if (!result.isErrorOrCancel()) {
                    result.add(this.checkDuplicateOfferingOrFixId(AgentJob.toArray(jobs)));
                }
                if (!result.isErrorOrCancel()) {
                    result.add((IStatus)this.checkForBlockingProcesses(jobs));
                }
                if (!result.isErrorOrCancel()) {
                    AgentJob[] jobsArray = AgentJob.toArray(jobs);
                    result.add(this.execute(agent, jobsArray, spm.next()));
                    if (this instanceof UninstallCommand) {
                        this.outputCompletedAgentJobs(agent, jobsArray);
                    }
                }
            }
            catch (RuntimeStatusException e) {
                result.add(e.getStatus());
            }
            catch (Throwable e) {
                result.add((IStatus)Statuses.ERROR.get(e, e.toString(), new Object[0]));
            }
        }
        finally {
            spm.done();
            monitor.done();
            credentialPrompts.restore();
        }
        return result;
    }

    private IStatus checkDuplicateOfferingOrFixId(AgentJob[] productJobs) {
        Collection profileJobsList = AgentUtil.groupByProfile(productJobs, false);
        for (AgentJob[] profileJobs : profileJobsList) {
            HashSet<IOfferingOrFix> offeringsOrFixes = new HashSet<IOfferingOrFix>();
            AgentJob[] agentJobArray = profileJobs;
            int n = profileJobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                if (job.isInstall() || job.isModify() || job.isUpdate() || job.isRollback()) {
                    IStatus status = this.checkDuplicateOfferingOrFixId(offeringsOrFixes, job.getOfferingOrFix());
                    if (StatusUtil.isError((IStatus)status)) {
                        return status;
                    }
                    offeringsOrFixes.add(job.getOfferingOrFix());
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus checkDuplicateOfferingOrFixId(Set<IOfferingOrFix> offeringOrFixSet, IOfferingOrFix offeringOrFix) {
        for (IOfferingOrFix existingOfferingOrFix : offeringOrFixSet) {
            if (!existingOfferingOrFix.getIdentity().equals(offeringOrFix.getIdentity())) continue;
            return Statuses.ERROR.get(Messages.AbstractInstallCommand_DuplicatePackageId, new Object[]{existingOfferingOrFix.getIdentity()});
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkPlatformSupport(Agent agent, AgentJob job) {
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        IStatus platformStatus = SliceUtils.checkPlatform((IOfferingOrFix)offeringOrFix, (String)job.getProfile().getOS(), (String)job.getProfile().getArch());
        if (!platformStatus.isOK()) {
            status = Statuses.ERROR.getMultiStatus(Messages.AbstractInstallCommand_PlatformValidationError, new Object[]{offeringOrFix.getName(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)offeringOrFix), offeringOrFix.getRepository().getLocationStr()});
            status.addAll((IStatus)Statuses.ERROR.get(Messages.AbstractInstallCommand_Repo_Incorrect_Architecture_For_Profile, new Object[]{BitModeUtils.getBitModeText(job.getProfile()), job.getProfile().getProfileId(), Util.toString((Collection)SliceUtils.getListOfPlatformSlices((IContent)offeringOrFix), (Util.Formatter)new Util.Formatter(", "))}));
        } else {
            platformStatus = BitModeUtils.checkSupportedPlatformsAgainstProfile(offeringOrFix, job.getProfile());
            if (!platformStatus.isOK()) {
                status = Statuses.ERROR.getMultiStatus(Messages.AbstractInstallCommand_PlatformValidationError, new Object[]{offeringOrFix.getName(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)offeringOrFix), offeringOrFix.getRepository().getLocationStr()});
                status.addAll(platformStatus);
            }
        }
        return status;
    }

    private AgentJob[] getSelectedJobs(AgentJob[] agentJobs) {
        ArrayList<AgentJob> selectedAgentJobs = new ArrayList<AgentJob>();
        AgentJob[] agentJobArray = agentJobs;
        int n = agentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob agentJob = agentJobArray[n2];
            if (agentJob.isSelected()) {
                selectedAgentJobs.add(agentJob);
            }
            ++n2;
        }
        agentJobs = AgentJob.toArray(selectedAgentJobs);
        return agentJobs;
    }

    private static IStatus checkPrerequisite(Agent agent, AgentJob job, IFeatureGroup group) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        if (group.isRequired()) {
            result.add(agent.checkPrerequisite((IFeatureBase)group, job));
            if (result.isErrorOrCancel()) {
                return result;
            }
        } else {
            return Status.OK_STATUS;
        }
        List features = group.getFeatures();
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            if (feature.isRequired()) {
                result.add(agent.checkPrerequisite((IFeatureBase)feature, job));
                if (result.isErrorOrCancel()) {
                    return result;
                }
            }
            ++i;
        }
        List groups = group.getGroups();
        int i2 = 0;
        while (i2 < groups.size()) {
            IFeatureGroup featureGroup = (IFeatureGroup)groups.get(i2);
            if (featureGroup.isRequired()) {
                result.add(agent.checkPrerequisite((IFeatureBase)featureGroup, job));
                if (result.isErrorOrCancel()) {
                    return result;
                }
                result.add(AbstractInstallCommand.checkPrerequisite(agent, job, featureGroup));
                if (result.isErrorOrCancel()) {
                    return result;
                }
            }
            ++i2;
        }
        return result;
    }

    @Override
    public void addOffering(String id, String version, String profile, String features) {
        this.addOfferingInternal(id, version, profile, features, null, true, null, null, null);
    }

    @Override
    public void addOffering(String id, String version, String profile, String features, String installLocation) {
        this.addOfferingInternal(id, version, profile, features, null, true, null, null, installLocation);
    }

    @Override
    public void addOffering(String id, String version, String profile, String features, String installLocation, InstallFixesAction installFixes) {
        this.addOfferingInternal(id, version, profile, features, null, true, installFixes, null, installLocation);
    }

    public void addOffering(String id, String version, String profile, String features, InstallFixesAction installFixes) {
        this.addOfferingInternal(id, version, profile, features, null, true, installFixes, null, null);
    }

    protected void addOfferingInternal(String id, String version, String profile, String features, Boolean expandFeatureTree, boolean selected, InstallFixesAction installFixes, InstallFixesAction showFixes, String installLocation) {
        XMLElement childElement = new XMLElement("offering");
        if (profile != null) {
            childElement.addAttribute("profile", profile);
        }
        if (id != null) {
            childElement.addAttribute("id", id);
        }
        if (version != null) {
            childElement.addAttribute("version", version);
        }
        if (features != null) {
            childElement.addAttribute("features", features);
        }
        if (expandFeatureTree != null) {
            childElement.addAttribute("expandFeatureTree", expandFeatureTree.toString());
        }
        if (installLocation != null) {
            childElement.addAttribute("installLocation", installLocation);
        }
        if (!selected) {
            childElement.addAttribute("selected", Boolean.FALSE.toString());
        }
        if (installFixes != null) {
            childElement.addAttribute("installFixes", installFixes.getName());
        }
        if (showFixes != null) {
            childElement.addAttribute("showFixes", showFixes.getName());
        }
        this.addChild(childElement);
    }

    @Override
    public AgentJob[] getAsInputJobs(Agent agent, boolean isWizardMode) {
        ArrayList<AgentJob> result = new ArrayList<AgentJob>();
        for (XMLElement child : this.children()) {
            result.addAll(Arrays.asList(this.getAsInputJob(agent, child, isWizardMode, null)));
        }
        AgentJob[] jobs = AgentJob.toArray(result);
        this.initializeProfilePlatformProperties(jobs);
        this.setAcceptLicense(jobs);
        return jobs;
    }

    protected void initializeProfilePlatformProperties(AgentJob[] jobs) {
        Collection profileJobsList = AgentUtil.groupByProfile(this.getSelectedJobs(jobs), false);
        for (AgentJob[] profileJobs : profileJobsList) {
            Profile profile = profileJobs[0].getProfile();
            BitModeUtils.initializeProfilePlatformProperties(profile, profileJobs, false);
        }
    }

    @Override
    public void addOffering(IOfferingOrFix offeringOrFix, Profile profile, IFeature[] features) {
        this.addOffering(offeringOrFix, profile, features, null);
    }

    @Override
    public void addOffering(IOfferingOrFix offeringOrFix, Profile profile, IFeature[] features, InstallFixesAction installFixes) {
        this.addOffering(offeringOrFix.getIdentity().getId(), offeringOrFix.getVersion().toString(), profile == null ? null : profile.getProfileId(), this.toFeatureIdString(offeringOrFix, features), installFixes);
    }

    private String toFeatureIdString(IOfferingOrFix offeringOrFix, IFeature[] features) {
        if (offeringOrFix instanceof IFix || this instanceof RollbackCommand) {
            return null;
        }
        if (features == null) {
            return this instanceof UninstallCommand ? null : "";
        }
        if (features.length == 0) {
            return "-";
        }
        return Util.toFeatureIdString((IFeature[])features);
    }

    @Override
    public boolean isModify() {
        return Boolean.valueOf(this.getAttribute("modify"));
    }

    @Override
    public void setModify(boolean modify) {
        this.addAttribute("modify", Boolean.toString(modify));
    }

    @Override
    public List getOfferingIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (XMLElement child : this.children()) {
            String idString = child.getAttribute("id");
            if (idString == null) continue;
            result.add(idString);
        }
        return result;
    }

    @Override
    public List getProfileIds() {
        ArrayList<String> idList = new ArrayList<String>();
        for (XMLElement child : this.children()) {
            String profileId = child.getAttribute("profile");
            if (profileId == null) continue;
            idList.add(profileId);
        }
        return idList;
    }

    @Override
    public List getActualProfiles() {
        return this.actualProfiles;
    }

    protected void setAcceptLicense(AgentJob[] jobs) {
        if (this.isAcceptLicense()) {
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                job.setAcceptLicense(true);
                ++n2;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    protected IOffering getInstalledOffering(Agent agent, Profile profile, String idString, String versionString) throws HeadlessApplicationException {
        IOffering[] offerings;
        if (versionString == null) {
            return null;
        }
        SimpleIdentity identity = new SimpleIdentity(idString);
        Version version = AbstractInstallCommand.getVersion(idString, versionString);
        IOffering[] iOfferingArray = offerings = agent.getInstalledOfferings(profile, (IIdentity)identity);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (offering.getVersion().equals((Object)version)) {
                return offering;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isAgentUninstallOnly(AgentJob[] jobs) {
        return jobs.length == 1 && jobs[0] instanceof UninstallJob && jobs[0].getProfile().isAgentProfile();
    }

    public static IStatus performLocationPermissionCheck(AgentJob[] jobs) {
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        TreeSet<Profile> profiles = new TreeSet<Profile>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Profile profile1 = (Profile)arg0;
                Profile profile2 = (Profile)arg1;
                return profile1.getProfileId().compareTo(profile2.getProfileId());
            }
        });
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            Profile jobProfile = job.getProfile();
            if (jobProfile != null) {
                profiles.add(job.getProfile());
            }
            ++n2;
        }
        for (Profile profile : profiles) {
            status.add(AgentUtil.validateInstallDirectoryPermissions(profile.getInstallLocation()));
        }
        return status;
    }

    public static IStatus checkIfInstallFixesSpecifiedForFix(IOfferingOrFix offeringOrFix, boolean attributeSpecified, String attribute) {
        IStatus status = Status.OK_STATUS;
        if (!(offeringOrFix instanceof IOffering) && attributeSpecified) {
            status = Statuses.ERROR.get(Messages.AbstractInstallCommand_InstallFixesInvalidForFix, new Object[]{attribute, offeringOrFix.getName()});
        }
        return status;
    }

    public static IStatus checkPrerequisite(Agent agent, AgentJob job, Set offeringsSeenBefore, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        try {
            Collection offeringsForPreReqCheck = job.getOfferingsForPreReqCheck(offeringsSeenBefore);
            result.add(AbstractInstallCommand.prepareOfferings(agent, offeringsForPreReqCheck, monitor));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            for (IOffering offeringForPrereqCheck : offeringsForPreReqCheck) {
                result.add(AbstractInstallCommand.checkPrerequisite(agent, job, offeringForPrereqCheck.getFeatureGroup()));
                if (!StatusUtil.isErrorOrCancel((IStatus)result)) continue;
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static IStatus prepareOfferings(Agent agent, Collection offerings, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        SplitProgressMonitor jobLoopMonitor = new SplitProgressMonitor(monitor, offerings.size());
        try {
            for (IOffering offering : offerings) {
                IProgressMonitor jobMonitor = jobLoopMonitor.next();
                status.add(agent.prepare((IOfferingOrFix)offering, ExtensionCategory.ALL, jobMonitor));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                if (!jobLoopMonitor.isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            jobLoopMonitor.done();
            monitor.done();
        }
        return status;
    }

    public boolean isAgentUpdate() {
        return this.agentUpdate;
    }

    public void setAgentUpdate(boolean agentUpdate) {
        this.agentUpdate = agentUpdate;
    }

    protected IStatus checkInstalledAtOneLocation(boolean isModify) {
        return Status.OK_STATUS;
    }

    public IStatus setProfileData(Profile profile) {
        return this.setProfileData(profile, false);
    }

    public IStatus setProfileData(Profile profile, boolean override) {
        for (XMLElement child : this.children()) {
            if (!"data".equals(child.getName())) continue;
            String key = child.getAttribute("key");
            String value = child.getAttribute("value");
            String currentValue = null;
            boolean modifiableProperty = true;
            if (key.equals("installLocation")) {
                currentValue = profile.getInstallLocation();
                modifiableProperty = false;
            } else if (!override) {
                if (key.equals("cic.selector.arch")) {
                    currentValue = profile.getArch();
                    modifiableProperty = false;
                } else if (key.equals("eclipseLocation") || key.equals("locale")) {
                    currentValue = profile.getData(key);
                    modifiableProperty = false;
                }
            }
            if (!modifiableProperty) {
                if (currentValue.equals(value)) continue;
                log.warning(Messages.AbstractCommand_PropertyCannotBeModified, new Object[]{key, currentValue, value});
                continue;
            }
            IStatus status = profile.setData(key, value);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private ICicStatus checkForBlockingProcesses(List<AgentJob> agentJobs) {
        return new LockedFilesChecker(agentJobs).checkForLockedFiles();
    }
}

