/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ResponseFileGenerator;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.VariableSubstitution;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.TemplateOfferingCustomPanelFactory;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.BaseEvaluationContext;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionContainer;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapMap;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResponseFileFromRepositories
extends ResponseFileGenerator {
    private static final String FEATURES_VAR = "features";
    private final Collection<IRepository> repos;

    public ResponseFileFromRepositories(Collection<IRepository> repos) {
        this.repos = repos;
    }

    @Override
    protected <T extends IOfferingOrFix> Collection<T> filterPackages(Collection<T> pkgs) {
        TreeMap<IIdentity, IOfferingOrFix> idToPkg = new TreeMap<IIdentity, IOfferingOrFix>(Comparators.IDENTITY);
        for (IOfferingOrFix pkg : super.filterPackages(pkgs)) {
            IIdentity id;
            if (pkg.compareVersion((IContent)idToPkg.get(id = pkg.getIdentity())) < 0) continue;
            idToPkg.put(id, pkg);
        }
        return idToPkg.values();
    }

    @Override
    protected IStatus missingPackageError(String idv) {
        return Statuses.ERROR.get(Messages.ResponseFileFromRepositories_Package_Not_Found_In_Repos, new Object[]{idv});
    }

    @Override
    protected IStatus nothingIncludedError() {
        return Statuses.ERROR.get(Messages.ResponseFileFromRepositories_No_Packages_Found_In_Repos, new Object[0]);
    }

    @Override
    protected void doGenerate() throws CoreException {
        LinkedHashSet<IRepository> neededRepos = new LinkedHashSet<IRepository>();
        GroupedProfiles groupedProfiles = new GroupedProfiles();
        for (IRepository repo : this.repos) {
            Collection<IOffering> offerings = this.filterPackages(repo.getAllOfferings(null));
            if (offerings.isEmpty()) continue;
            groupedProfiles.addOfferings(offerings);
            neededRepos.add(repo);
        }
        for (IRepository repo : this.repos) {
            Collection<IFix> fixes = this.filterPackages(repo.getAllFixes(null));
            if (fixes.isEmpty()) continue;
            groupedProfiles.addFixes(fixes);
            neededRepos.add(repo);
        }
        groupedProfiles.group();
        for (IRepository repo : neededRepos) {
            this.rfb.repository(repo.getLocation());
        }
        IOffering first = groupedProfiles.getFirstOffering();
        if (first != null) {
            this.genShared(first);
            this.rfb.addVariable(FEATURES_VAR, FeatureValues.DEFAULT.toString()).addComment(NLS.bind((String)Messages.ResponseFileFromRepositories_Feature_Var_Comment, (Object[])new Object[]{FEATURES_VAR, FeatureValues.REQUIRED, FeatureValues.DEFAULT, FeatureValues.ALL}));
        }
        for (IFix fix : groupedProfiles.getExtraFixes()) {
            this.install(fix);
        }
        for (String profileId : groupedProfiles.getProfileIds()) {
            List<IOffering> offerings = groupedProfiles.getOfferings(profileId);
            this.genProfile(groupedProfiles, profileId);
            for (IOffering offering : offerings) {
                String featuresVar = "features." + offering.getIdentity();
                IVariablesCommand.IVariable variable = this.rfb.addVariable(featuresVar, null);
                variable.addComment(NLS.bind((String)Messages.ResponseFileFromRepositories_Features_For, (Object)offering.getName()));
                this.genFeatures(variable, offering, FeatureValues.REQUIRED);
                this.genFeatures(variable, offering, FeatureValues.DEFAULT);
                this.genFeatures(variable, offering, FeatureValues.ALL);
                this.install(offering, PlatformUtils.variableRef((String)featuresVar));
            }
            for (IFix fix : groupedProfiles.getFixes(profileId)) {
                this.install(fix);
            }
        }
    }

    private void genShared(IOffering offering) {
        if (OfferingProperty.isExtension((IOfferingOrFix)offering)) {
            return;
        }
        String defaultLocation = PlatformUtils.OS.DEFAULT.getOsDefaultSharedLocation(offering);
        IVariablesCommand.IVariable variable = this.rfb.addVariable("sharedLocation", this.fixLocationVar(defaultLocation));
        this.rfb.preference("com.ibm.cic.common.core.preferences.eclipseCache", PlatformUtils.variableRef((String)"sharedLocation"));
        for (PlatformUtils.OS os : PlatformUtils.OS.getValues()) {
            String location = os.getOsDefaultSharedLocation(offering);
            if (location.isEmpty() || location.equals(defaultLocation)) continue;
            variable.addIf(ResponseFileFromRepositories.platformVar("os"), os.toString(), this.fixLocationVar(location));
        }
    }

    private void genProfile(GroupedProfiles groupedProfiles, String profileId) throws CoreException {
        List<IOffering> offerings = groupedProfiles.getOfferings(profileId);
        IOffering firstOffering = offerings.get(0);
        String defaultLocation = PlatformUtils.OS.DEFAULT.getOsDefaultInstallLocation(firstOffering);
        IVariablesCommand.IVariable variable = this.profile(profileId, this.fixLocationVar(defaultLocation), groupedProfiles.isMultiProfile(), offerings);
        for (PlatformUtils.OS os : PlatformUtils.OS.getValues()) {
            String location = os.getOsDefaultInstallLocation(firstOffering);
            if (location.isEmpty() || location.equals(defaultLocation)) continue;
            variable.addIf(ResponseFileFromRepositories.platformVar("os"), os.toString(), this.fixLocationVar(location));
        }
        StatusUtil.throwIfError((IStatus)SharedUIUtils.prepareOfferingsAndFixes(offerings, null));
        AgentJob[] jobs = AgentJob.toArray(groupedProfiles.getJobs(profileId));
        this.genProfileData(Messages.ResponseFileFromRepositories_Common_Data_Label, TemplateCommonCustomPanelFactory.getInstance().createCustomPanelTemplates(jobs));
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            this.genProfileData(NLS.bind((String)Messages.ResponseFileFromRepositories_Data_For_Offering_Label, (Object)job.getOfferingOrFix().getName()), TemplateOfferingCustomPanelFactory.getInstance().createCustomPanelTemplates(new AgentJob[]{job}));
            ++n2;
        }
    }

    private String fixLocationVar(String location) {
        if (location == null) {
            return null;
        }
        String mdVar = PlatformUtils.variableRef((String)"defaultInstallRootLocation");
        try {
            if (location.startsWith(mdVar)) {
                String rfVar = PlatformUtils.variableRef((String)ResponseFileFromRepositories.platformVar("installRoot"));
                return String.valueOf(rfVar) + ResponseFileFromRepositories.substituteVariables(location.substring(mdVar.length()));
            }
            return ResponseFileFromRepositories.substituteVariables(location);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            return location;
        }
    }

    private static String substituteVariables(String s) throws AbstractVariableSubstitution.VariableSubstitutionException {
        return VariableSubstitution.getInstance().performVariableSubstitutions(s);
    }

    private void genProfileData(String comment, CustomPanelWrapper[] panels) {
        CustomPanelWrapper[] customPanelWrapperArray = panels;
        int n = panels.length;
        int n2 = 0;
        while (n2 < n) {
            CustomPanelWrapper panel = customPanelWrapperArray[n2];
            for (TemplateCustomPanel.AbstractUserData userData : panel.getProfileUserData()) {
                String description;
                String value = !userData.isSensitive() ? userData.getValue() : "****";
                this.rfb.profileData(panel.getProfileKey(userData.getId()), value);
                if (comment != null) {
                    this.rfb.comment(comment);
                    comment = null;
                }
                if ((description = userData.getDescription()) == null) continue;
                this.rfb.comment(description);
            }
            ++n2;
        }
    }

    private void genFeatures(IVariablesCommand.IVariable variable, IOffering offering, FeatureValues kind) {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add(kind.desc);
        IFeature[] iFeatureArray = kind.getFeaturesDelta(offering);
        int n = iFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            comment.add(NLS.bind((String)"  {0}: {1}", (Object)feature.getIdentity(), (Object)feature.getInformation().getName()));
            ++n2;
        }
        PlatformFeatures platformFeatures = new PlatformFeatures(offering, kind);
        IVariablesCommand.IVariableIf varIf = variable.addIf(FEATURES_VAR, kind.toString(), platformFeatures.getFeatures());
        varIf.addComment(comment);
        for (String os : platformFeatures.getOsValues()) {
            IVariablesCommand.IVariableIf osIf = varIf.addIf(ResponseFileFromRepositories.platformVar("os"), os, platformFeatures.getFeatures(os));
            for (String arch : platformFeatures.getArchValues(os)) {
                osIf.addIf(ResponseFileFromRepositories.platformVar("arch"), arch, platformFeatures.getFeatures(os, arch));
            }
        }
    }

    private static String platformVar(String arg) {
        return AbstractVariableSubstitution.getVarFromNameAndArg("platform", arg);
    }

    private static class EvalContext
    extends BaseEvaluationContext {
        static final EvalContext ANY = new EvalContext();
        final String os;
        final String arch;

        EvalContext(String os, String arch) {
            super(true, true);
            this.os = os;
            this.arch = arch;
        }

        private EvalContext() {
            this(null, null);
        }

        public String toString() {
            return NLS.bind((String)"os={0} arch={1}", (Object)this.os, (Object)this.arch);
        }

        public IStatus evaluate(String id, String value) {
            if (id.equals("os") && this.os != null) {
                return this.os.equals(value) ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
            if (id.equals("arch") && this.arch != null) {
                return this.arch.equals(value) ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
            return Statuses.INFO.get("", new Object[0]);
        }

        boolean isApplicable(IFeatureBase featureBase) {
            ISelectionExpression expr = ((ISelectionExpressionContainer)featureBase).getExpression();
            return expr == null || !StatusUtil.isErrorOrCancel((IStatus)expr.evaluate((ISelectionExpression.EvaluationContext)this));
        }
    }

    private static enum FeatureValues {
        NONE(null),
        REQUIRED(Messages.ResponseFileFromRepositories_Required_Features),
        DEFAULT(Messages.ResponseFileFromRepositories_Default_Features),
        ALL(Messages.ResponseFileFromRepositories_Non_Default_Features);

        final String desc;

        private FeatureValues(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        IFeature[] getFeatures(IOffering offering) {
            return this.getFeatures(offering, EvalContext.ANY);
        }

        IFeature[] getFeatures(IOffering offering, final EvalContext context) {
            OfferingUtil.FeatureCollector collector = new OfferingUtil.FeatureCollector(){

                protected boolean include(IFeatureBase featureBase) {
                    if (!context.isApplicable(featureBase)) {
                        return false;
                    }
                    switch (this) {
                        case NONE: {
                            return false;
                        }
                        case REQUIRED: {
                            return featureBase.isRequired();
                        }
                        case DEFAULT: {
                            return featureBase.isSelectedByDefault((ISelectionExpression.EvaluationContext)context);
                        }
                        case ALL: {
                            return true;
                        }
                    }
                    throw new AssertionError();
                }
            };
            collector.walk(offering);
            return collector.getFeatures();
        }

        IFeature[] getFeaturesDelta(IOffering offering) {
            LinkedHashSet<IFeature> features = new LinkedHashSet<IFeature>(Arrays.asList(this.getFeatures(offering)));
            FeatureValues prevKind = FeatureValues.values()[this.ordinal() - 1];
            features.removeAll(Arrays.asList(prevKind.getFeatures(offering)));
            return features.toArray(new IFeature[features.size()]);
        }
    }

    private static class GroupedProfiles {
        private final List<IOffering> allOfferings = new ArrayList<IOffering>();
        private final List<IFix> allFixes = new ArrayList<IFix>();
        private final MapList<String, IOffering> offeringGroups = MapList.newMapList();
        private final MapList<String, IFix> fixGroups = MapList.newMapList();
        private final List<IFix> extraFixes = new ArrayList<IFix>();

        GroupedProfiles() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String profileId : this.getProfileIds()) {
                sb.append(profileId).append(':');
                for (IOffering offering : this.getOfferings(profileId)) {
                    sb.append(' ').append(offering.getIdentity()).append('_').append(offering.getVersion());
                }
                sb.append('\n');
            }
            return sb.toString();
        }

        IOffering getFirstOffering() {
            if (this.offeringGroups.isEmpty()) {
                return null;
            }
            return (IOffering)((List)((Map.Entry)this.offeringGroups.entrySet().iterator().next()).getValue()).get(0);
        }

        Set<String> getProfileIds() {
            return this.offeringGroups.keySet();
        }

        boolean isMultiProfile() {
            return this.getProfileIds().size() > 1;
        }

        public List<AgentJob> getJobs(String profileId) {
            ArrayList<Object> all = new ArrayList<Object>();
            all.addAll(this.getOfferings(profileId));
            all.addAll(this.getFixes(profileId));
            all.addAll(this.getExtraFixes());
            Profile profile = new Profile(profileId, "product");
            ArrayList<AgentJob> jobs = new ArrayList<AgentJob>();
            for (IOfferingOrFix iOfferingOrFix : all) {
                jobs.add(new InstallJob(profile, iOfferingOrFix));
            }
            return jobs;
        }

        List<IOffering> getOfferings(String profileId) {
            return this.offeringGroups.get((Object)profileId);
        }

        List<IFix> getFixes(String profileId) {
            return this.fixGroups.get((Object)profileId);
        }

        List<IFix> getExtraFixes() {
            return this.extraFixes;
        }

        void addFixes(Collection<IFix> fixes) {
            this.allFixes.addAll(fixes);
        }

        void addOfferings(Collection<IOffering> offerings) {
            this.allOfferings.addAll(offerings);
        }

        void group() {
            IOffering[] offeringArray = this.allOfferings.toArray(new IOffering[this.allOfferings.size()]);
            SortUtil.sortOfferings((IOfferingOrFix[])offeringArray);
            IOffering[] iOfferingArray = offeringArray;
            int n = offeringArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                this.addOffering(offering);
                ++n2;
            }
            IFix[] fixArray = this.allFixes.toArray(new IFix[this.allFixes.size()]);
            SortUtil.sortOfferings((IOfferingOrFix[])offeringArray);
            IFix[] iFixArray = fixArray;
            int n3 = fixArray.length;
            n = 0;
            while (n < n3) {
                IFix fix = iFixArray[n];
                this.addFix(fix);
                ++n;
            }
        }

        private void addOffering(IOffering offering) {
            String profileId2;
            for (String profileId2 : this.offeringGroups.keySet()) {
                this.offeringGroups.add((Object)profileId2, (Object)offering);
                if (this.checkCompatible(this.offeringGroups.get((Object)profileId2))) {
                    return;
                }
                this.offeringGroups.remove((Object)profileId2, (Object)offering);
            }
            profileId2 = Profile.makeNewProfileIdForOffering(offering, this.offeringGroups.keySet());
            this.offeringGroups.add((Object)profileId2, (Object)offering);
        }

        private void addFix(IFix fix) {
            boolean foundProfile = false;
            for (Map.Entry entry : this.offeringGroups.entrySet()) {
                String profileId = (String)entry.getKey();
                List offerings = (List)entry.getValue();
                if (!FixUtil.isFixApplicable((IFix)fix, (Collection)offerings)) continue;
                foundProfile = true;
                this.fixGroups.add((Object)profileId, (Object)fix);
            }
            if (!foundProfile) {
                this.extraFixes.add(fix);
            }
        }

        private boolean checkCompatible(List<IOffering> offerings) {
            IOffering[] array = offerings.toArray(new IOffering[offerings.size()]);
            return AgentUtil.validateCompatibleOfferingsWithoutPlatform(array).isOK();
        }
    }

    private static class PlatformFeatures {
        private static final Logger log = Logger.getLogger();
        private final String defaultFeatures;
        private final Map<String, String> osToFeatures;
        private final MapMap<String, String, String> platformToFeatures;

        PlatformFeatures(IOffering offering, FeatureValues kind) {
            this.platformToFeatures = this.buildPlatformToFeatures(offering, kind);
            log.debug("=== {0} features before grouping:\n{1}", new Object[]{kind, this});
            this.defaultFeatures = this.findCommonFeatures();
            this.osToFeatures = this.buildOsToFeatures();
            this.filterDefaultFeatures();
            log.debug("=== {0} features after grouping:\n{1}", new Object[]{kind, this});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("defaultFeatures: ").append(this.defaultFeatures);
            sb.append("\nosToFeatures:");
            if (this.osToFeatures == null || this.osToFeatures.isEmpty()) {
                sb.append(" (none)");
            } else {
                for (Map.Entry<String, String> entry : this.osToFeatures.entrySet()) {
                    sb.append("\n  ").append(entry.getKey()).append(": ").append(entry.getValue());
                }
            }
            sb.append("\nplatformToFeatures:");
            if (this.platformToFeatures == null || this.platformToFeatures.isEmpty()) {
                sb.append(" (none)");
            } else {
                for (String os : this.platformToFeatures.keySet()) {
                    sb.append("\n  ").append(os).append(':');
                    for (String arch : this.platformToFeatures.keySet((Object)os)) {
                        String featureList = (String)this.platformToFeatures.get((Object)os, (Object)arch);
                        sb.append("\n    ").append(arch).append(": ").append(featureList);
                    }
                }
            }
            return sb.toString();
        }

        Iterable<String> getOsValues() {
            return Util.join(this.osToFeatures.keySet(), (Iterable)this.platformToFeatures.keySet());
        }

        Iterable<String> getArchValues(String os) {
            return this.platformToFeatures.get((Object)os).keySet();
        }

        String getFeatures() {
            return this.defaultFeatures;
        }

        String getFeatures(String os) {
            return this.osToFeatures.get(os);
        }

        String getFeatures(String os, String arch) {
            return (String)this.platformToFeatures.get((Object)os, (Object)arch);
        }

        private MapMap<String, String, String> buildPlatformToFeatures(IOffering offering, FeatureValues kind) {
            MapMap result = MapMap.newHashHash();
            PlatformFilter supportedPlatforms = this.getSupportedPlatformsFilter(offering);
            for (String os : SupportedPlatforms.getInstance().getOsValues()) {
                for (String arch : SupportedPlatforms.getInstance().getArchValues(os)) {
                    if (!supportedPlatforms.matchesPlatform(os, arch).isOK()) continue;
                    IFeature[] features = kind.getFeatures(offering, new EvalContext(os, arch));
                    result.put((Object)os, (Object)arch, (Object)Util.toFeatureIdString((IFeature[])features));
                }
            }
            return result;
        }

        private PlatformFilter getSupportedPlatformsFilter(IOffering offering) {
            String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offering);
            if (filter != null) {
                return new PlatformFilter(filter);
            }
            return new PlatformFilter(null){

                public IStatus matchesPlatform(String os, String arch) {
                    return Status.OK_STATUS;
                }
            };
        }

        private String findCommonFeatures() {
            if (this.platformToFeatures.isEmpty()) {
                return "";
            }
            final HashMap<String, Integer> frequency = new HashMap<String, Integer>();
            for (String os : this.platformToFeatures.keySet()) {
                for (String arch : this.platformToFeatures.keySet((Object)os)) {
                    String featureList;
                    Integer count = (Integer)frequency.get(featureList = (String)this.platformToFeatures.get((Object)os, (Object)arch));
                    frequency.put(featureList, count == null ? 1 : count + 1);
                }
            }
            ArrayList featureLists = new ArrayList(frequency.keySet());
            Collections.sort(featureLists, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return (Integer)frequency.get(s2) - (Integer)frequency.get(s1);
                }
            });
            String mostCommon = (String)featureLists.get(0);
            if (featureLists.size() == 1) {
                this.platformToFeatures.clear();
                return mostCommon;
            }
            if (((Integer)frequency.get(mostCommon)).equals(frequency.get(featureLists.get(1)))) {
                return null;
            }
            return mostCommon;
        }

        private Map<String, String> buildOsToFeatures() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (String os : this.platformToFeatures.keySet()) {
                TreeSet featureLists = new TreeSet(this.platformToFeatures.get((Object)os).values());
                if (featureLists.size() != 1) continue;
                result.put(os, (String)featureLists.first());
            }
            Iterator i = result.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String os = (String)entry.getKey();
                String featureList = (String)entry.getValue();
                if (featureList.equals(this.defaultFeatures)) {
                    i.remove();
                }
                this.platformToFeatures.remove((Object)os);
            }
            return result;
        }

        private void filterDefaultFeatures() {
            MapList osArchToRemove = MapList.newMapList();
            for (String os : this.platformToFeatures.keySet()) {
                for (String arch : this.platformToFeatures.keySet((Object)os)) {
                    String featureList = (String)this.platformToFeatures.get((Object)os, (Object)arch);
                    if (this.defaultFeatures == null || !this.defaultFeatures.equals(featureList)) continue;
                    osArchToRemove.add((Object)os, (Object)arch);
                }
            }
            for (String os : osArchToRemove.keySet()) {
                for (String arch : osArchToRemove.get((Object)os)) {
                    this.platformToFeatures.remove((Object)os, (Object)arch);
                }
            }
        }
    }
}

