/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IModifyJob;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ModifyJob
extends AbstractJob
implements IModifyJob {
    private final AgentJob.AgentJobType subType;

    public ModifyJob(Profile profile, IOfferingOrFix offering) {
        this(profile, offering, AgentJob.AgentJobType.MODIFY_JOB);
    }

    public ModifyJob(Profile profile, IOfferingOrFix offering, Collection features, AgentJob.AgentJobType subType) {
        this(profile, offering, subType);
        this.setFeatures(features);
    }

    public ModifyJob(Profile profile, IOfferingOrFix offering, AgentJob.AgentJobType subType) {
        super(AgentJob.AgentJobType.MODIFY_JOB, profile, offering);
        this.subType = subType;
    }

    @Override
    public void determineFeaturesToAddRemove(IAgent agent, List addedFeatures, List removedFeatures) {
        List selectedFeatures = this.getFeatures();
        if (this.getSubType().isUninstall()) {
            removedFeatures.addAll(selectedFeatures);
            return;
        }
        IFeature[] installedFeatures = agent.getInstalledFeatures(this.getProfile(), this.getOffering());
        HashSet<IFeature> installedFeatureSet = new HashSet<IFeature>(Arrays.asList(installedFeatures));
        int i = 0;
        while (i < selectedFeatures.size()) {
            IFeature feature = (IFeature)selectedFeatures.get(i);
            if (!installedFeatureSet.remove(feature)) {
                addedFeatures.add(feature);
            }
            ++i;
        }
        removedFeatures.addAll(installedFeatureSet);
    }

    @Override
    public AgentJob.AgentJobType getSubType() {
        return this.subType;
    }
}

