/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.ProcessInfo;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class LockedFilesChecker {
    private static final Logger log = Logger.getLogger(LockedFilesChecker.class);
    private final List<AbstractJob> m_jobs = new ArrayList<AbstractJob>();
    private final HashSet<String> m_directories = new HashSet();
    private List<String> m_filters = new ArrayList<String>();
    long m_currentProcessId = 0L;

    public LockedFilesChecker(List<AgentJob> agentJobs) {
        if (this.shouldSkipLockedFileCheck()) {
            return;
        }
        this.m_currentProcessId = NativeUtils.getCurrentProcId();
        for (AgentJob job : agentJobs) {
            if (!(job instanceof AbstractJob) || !OfferingOrFixProperty.checkForLockedModules((IOfferingOrFix)job.getOfferingOrFix())) continue;
            this.m_jobs.add((AbstractJob)job);
        }
    }

    private boolean shouldSkipLockedFileCheck() {
        return !CicCommonSettings.isWindows() || AgentUserOptions.CIC_CHECK_FOR_LOCKED_MODULES_SKIP.isSet() || Agent.getInstance().isSkipInstall();
    }

    public boolean hasJobsRequiringLockedFilesCheck() {
        return !this.m_jobs.isEmpty();
    }

    public Set<String> getSearchedDirectories() {
        return this.m_directories;
    }

    private void refreshDirectoriesAndFilters() {
        if (this.shouldSkipLockedFileCheck()) {
            return;
        }
        this.m_filters.clear();
        this.m_directories.clear();
        boolean m_for64bit = BitModeUtils.jobsSupport64bits(this.m_jobs) && !BitModeUtils.jobsDefaultProfileIs32bit(this.m_jobs);
        for (AbstractJob job : this.m_jobs) {
            IOfferingOrFix oof = job.getOfferingOrFix();
            SubstitutionOperation sub = new SubstitutionOperation(job.getProfile().getRootContext(), m_for64bit);
            Set dirs = OfferingOrFixProperty.getLockedModulesDirectories((IOfferingOrFix)oof);
            if (!dirs.isEmpty()) {
                for (String d : dirs) {
                    String dir = LockedFilesChecker.substituteVariables(sub, d);
                    if (dir.length() <= 0) continue;
                    this.m_directories.add(dir);
                }
            } else {
                String dir = String.valueOf(LockedFilesChecker.substituteVariables(sub, "${profile:installLocation}")) + File.separatorChar;
                if (dir.length() > 1) {
                    this.m_directories.add(dir);
                }
            }
            List filters = OfferingOrFixProperty.getLockedModulesFilter((IOfferingOrFix)oof);
            this.m_filters = filters.isEmpty() ? LockedFilesChecker.mergeFilters(sub, this.m_filters, Collections.singletonList("${specialFolder:WINDOWS}\\")) : LockedFilesChecker.mergeFilters(sub, this.m_filters, filters);
        }
    }

    private static String substituteVariables(SubstitutionOperation sub, String var) {
        String return_value = var;
        if (sub != null && var.length() > 0) {
            try {
                return_value = sub.performVariableSubstitutions(var);
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {
                // empty catch block
            }
        }
        return return_value;
    }

    private String toStringPath(Set<String> a_dirs) {
        StringBuffer sb = new StringBuffer();
        for (String d : a_dirs) {
            sb.append(d);
            sb.append(';');
        }
        return sb.toString();
    }

    private String toStringProcessInfo(Set<ProcessInfo> a_pi) {
        OutputFormatter of = new OutputFormatter();
        of.incTab();
        for (ProcessInfo pi : a_pi) {
            of.appendT(new long[]{pi.getProcID()});
            of.appendT(new String[]{" : ", pi.getFileName()});
        }
        return of.toString();
    }

    private boolean matchesFilter(String a_fileName) {
        String name = a_fileName.toLowerCase();
        if (this.m_filters != null) {
            for (String f : this.m_filters) {
                if (!(LockedFilesChecker.isDir(f) ? name.startsWith(f) : name.endsWith(f))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDir(String a_path) {
        return a_path.endsWith("\\") || a_path.endsWith("/");
    }

    private static String resolvePath(SubstitutionOperation a_sub, String a_path) {
        String return_value = LockedFilesChecker.substituteVariables(a_sub, a_path).toLowerCase();
        if (!return_value.isEmpty()) {
            if (LockedFilesChecker.isDir(return_value)) {
                return_value = String.valueOf(FileUtil.getCanonicalPath((String)return_value).toLowerCase()) + File.separatorChar;
            }
            return_value = return_value.toLowerCase();
            return_value = PathUtil.fixSlashes((String)return_value);
        }
        return return_value;
    }

    @Deprecated
    public static List<String> mergeFilters(SubstitutionOperation sub, List<String> a_currentFilters, List<String> a_newFilters) {
        List<String> return_value = a_currentFilters;
        for (String nf : a_newFilters) {
            Boolean UseNewFilter;
            String aFilter = LockedFilesChecker.resolvePath(sub, nf);
            if (aFilter.isEmpty()) continue;
            block1: do {
                UseNewFilter = null;
                for (String of : return_value) {
                    String mFilter = LockedFilesChecker.resolvePath(sub, of);
                    if (mFilter.equals(aFilter)) {
                        UseNewFilter = Boolean.FALSE;
                        continue block1;
                    }
                    if (LockedFilesChecker.isDir(mFilter)) {
                        if (aFilter.startsWith(mFilter)) {
                            UseNewFilter = Boolean.FALSE;
                            continue block1;
                        }
                        if (!LockedFilesChecker.isDir(aFilter) || !mFilter.startsWith(aFilter)) continue;
                        return_value.remove(of);
                        UseNewFilter = Boolean.TRUE;
                        continue block1;
                    }
                    if (LockedFilesChecker.isDir(aFilter)) {
                        if (!mFilter.startsWith(aFilter)) continue;
                        return_value.remove(of);
                        UseNewFilter = Boolean.TRUE;
                        continue block1;
                    }
                    if (mFilter.endsWith(aFilter)) {
                        return_value.remove(of);
                        UseNewFilter = Boolean.TRUE;
                        continue block1;
                    }
                    if (!aFilter.endsWith(mFilter)) continue;
                    UseNewFilter = Boolean.FALSE;
                    continue block1;
                }
            } while (Boolean.TRUE.equals(UseNewFilter));
            if (UseNewFilter != null) continue;
            return_value.add(aFilter);
        }
        return return_value;
    }

    public Set<ProcessInfo> getFilteredLockingFiles() {
        HashSet<ProcessInfo> return_value = new HashSet<ProcessInfo>();
        this.refreshDirectoriesAndFilters();
        if (!this.m_directories.isEmpty()) {
            List psi = NativeUtils.getLockingProcesses((String)this.toStringPath(this.m_directories));
            for (ProcessInfo p : psi) {
                if (p.getProcID() == this.m_currentProcessId || this.matchesFilter(p.getFileName())) continue;
                return_value.add(p);
            }
        }
        return return_value;
    }

    public Set<ProcessInfo> killRunningProcesses(Set<ProcessInfo> a_pi) {
        if (AgentUserOptions.CIC_CHECK_FOR_LOCKED_MODULES_DO_NOT_KILL.isSet() || this.shouldSkipLockedFileCheck()) {
            return a_pi;
        }
        for (ProcessInfo pi : a_pi) {
            long processToKill = pi.getProcID();
            if (processToKill == this.m_currentProcessId) continue;
            log.note(Messages.LockedFilesChecker_ProcessTerminationInfo, new Object[]{pi.getFileName(), pi.getProcID()});
            NativeUtils.stopProcess((long)processToKill);
        }
        return this.getFilteredLockingFiles();
    }

    public ICicStatus checkForLockedFiles() {
        CicMultiStatus return_value = Statuses.OK.getMultiStatus();
        Set<ProcessInfo> pi = this.getFilteredLockingFiles();
        if (!pi.isEmpty()) {
            if (CmdLine.CL.containsCommand("-stopBlockingProcesses")) {
                Set<ProcessInfo> piUnstopped = this.killRunningProcesses(pi);
                if (!piUnstopped.isEmpty()) {
                    return_value.add((IStatus)Statuses.ERROR.get(Messages.CheckLockedProcesses_CouldNotStop, new Object[]{this.toStringProcessInfo(piUnstopped)}));
                }
            } else {
                return_value.add((IStatus)Statuses.ERROR.get(Messages.CheckLockedProcesses_MustStop, new Object[]{this.toStringProcessInfo(pi)}));
            }
        }
        return return_value;
    }
}

