/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.cmd.CmdInputBuilder;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.Input;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IInstallKitContext;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.EclipseUtil;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.install.info.IInstallInfo;
import com.ibm.cic.install.info.ILocation;
import com.ibm.cic.install.info.ILocationFilter;
import com.ibm.cic.install.info.IPackage;
import com.ibm.cic.install.info.IPackageFilter;
import com.ibm.cic.install.info.InstallInfoUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class AgentInstall {
    private static final Logger log = Logger.getLogger(AgentInstall.class);
    static final String IM_INSTALLER_VERSION = "im.installer.version";
    static final String IM_INSTALLER_INTERNAL_VERSION = "im.installer.internal.version";
    private static final String IM_INSTALLER_JRE_VERSION = "im.installer.jre.version";
    private static final String INSTALL_FROM_MULTIPLE_DISKS = ".multiple-disks";
    private static final String POST_AGENT_INSTALL_INPUT_PREFIX = "post-";
    private static final String NATIVE_DIR_NAME = "native";
    private static final String PLUGINS_DIR_NAME = "plugins";
    private static final String PLACEHOLDER_NAME = "placeholder";
    private static final String BACKUP_SUFFIX = ".backup";
    private static final String IM_EDITION_PROPERTY_KEY = "cic.imEdition";
    private static final String IM_LITE_PROPERTY = "lite";
    private static AgentInstall instance = null;
    private File installerLocation = null;
    private Version installerVersion = Version.emptyVersion;
    private Version installerInternalVersion = Version.emptyVersion;
    private Version installerJreVersion = Version.emptyVersion;
    private File installerRepositoryLocation = null;
    private IRepository installerRepository = null;
    private Boolean installFromMultipleDisks = null;
    private final HashMap explodedInstallerArtifacts = new HashMap(64);
    private AgentRegistry installedRegistry = null;
    private File renamedInstalledImDir = null;
    private List<File> installRegistryBackup = null;
    private Boolean isAgentBeingInstalled = null;

    public static AgentInstall getInstance() {
        if (instance == null) {
            instance = new AgentInstall();
        }
        return instance;
    }

    @Deprecated
    public static void refresh() {
        instance = null;
        AgentRegistry.refresh();
        AgentRelaunch.refresh();
    }

    public IStatus checkForAgentInstall() {
        IStatus status;
        int cmp;
        IStatus status2;
        AgentRelaunch.getInstance().logArguments();
        boolean reinstallIM = CmdLine.CL.reinstallIM();
        if (!this.isAgentInstallerRunning()) {
            IStatus validateStatus;
            this.cleanupTemporaryInstaller();
            if (reinstallIM) {
                return this.getReinstallImOnlyForImInstallerStatus();
            }
            if (this.isAgentInstalled() && this.sameDataLocation() && !(validateStatus = this.validateAgentRegistry()).isOK()) {
                return validateStatus;
            }
            return Status.OK_STATUS;
        }
        if (!this.isAgentInstalled()) {
            IStatus validateStatus = this.validateAgentRegistry();
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
            if (reinstallIM) {
                return this.getReinstallImOnlyWhenImInstalledStatus();
            }
            return Status.OK_STATUS;
        }
        if (this.isAgentBeingInstalled() && !(status2 = this.checkRegistryFileConflict()).isOK()) {
            return status2;
        }
        boolean sameDataLocation = this.sameDataLocation();
        if (sameDataLocation) {
            ILocation imLoc = this.getImLocationFromCurDataLoc();
            if (imLoc == null) {
                if (reinstallIM) {
                    return this.getReinstallImOnlyWhenImInstalledStatus();
                }
                this.installedRegistry.reset();
                return Status.OK_STATUS;
            }
            IStatus validateStatus = this.validateAgentRegistry();
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
        } else if (this.isAgentBeingInstalled()) {
            return this.getImInstalledAlreadyWithDifferentAppDataLocationStatus();
        }
        if ((cmp = this.installedRegistry.getInstalledAgentInternalVersion().compareTo(this.installerInternalVersion)) > 0) {
            IStatus status3;
            if (reinstallIM) {
                return this.getReinstallImWhenInstalledImIsNewerStatus();
            }
            if (sameDataLocation && !(status3 = this.relaunchWithInstalledAgent()).isOK()) {
                return status3;
            }
        }
        if (reinstallIM) {
            if (!this.isAgentBeingInstalled()) {
                return this.getReinstallImOnlyWhenImBeingInstalledStatus();
            }
            this.installedRegistry.reset();
            return Status.OK_STATUS;
        }
        if (cmp < 0) {
            if (!this.isAgentBeingInstalled()) {
                if (sameDataLocation) {
                    return this.getImInstalledAlreadyStatus(4);
                }
                ILocation imLoc = this.getImLocationFromCurDataLoc();
                if (imLoc != null) {
                    return this.getImInstalledAlreadyAtDataLocStatus(imLoc);
                }
            }
            return Status.OK_STATUS;
        }
        if (!sameDataLocation) {
            return Status.OK_STATUS;
        }
        File postInputFile = null;
        boolean isInteractive = CmdLine.CL.isInteractiveMode();
        if (isInteractive) {
            postInputFile = this.getPostAgentInstallInputFile();
        }
        if (postInputFile == null || !postInputFile.isFile()) {
            if (CmdLine.CL.isLiveInput() || CmdLine.CL.isUrlInput() || this.moreInstallCommandsInInputFile()) {
                return Status.OK_STATUS;
            }
            AgentRelaunch.getInstance().setNeedsRelaunch(false);
            return this.getImInstalledAlreadyStatus(isInteractive ? 4 : 2);
        }
        if (cmp == 0 && !(status = this.relaunchWithInstalledAgent()).isOK()) {
            return status;
        }
        AgentRelaunch.getInstance().addRelaunchApplicationArguments(new String[]{"input", postInputFile.getPath()});
        return Status.OK_STATUS;
    }

    public IStatus backupOriginalIM(File installLocation, File[] installRegistryFiles) {
        if (!this.isAgentInstallerRunning() || !CmdLine.CL.reinstallIM()) {
            return Status.OK_STATUS;
        }
        log.info(Messages.AgentInstall_reinstallIm);
        IStatus status = this.renameInstalledImDir(installLocation);
        if (!status.isOK()) {
            return status;
        }
        return this.backupInstallRegistryFiles(installRegistryFiles);
    }

    public IStatus restoreOriginalIM() {
        if (!this.isAgentInstallerRunning() || !CmdLine.CL.reinstallIM()) {
            return Status.OK_STATUS;
        }
        IStatus status = this.restoreInstallRegistryFiles();
        if (!status.isOK()) {
            return status;
        }
        return this.restoreRenamedInstalledImDir();
    }

    public boolean reinstallIM() {
        return this.isAgentInstallerRunning() && CmdLine.CL.reinstallIM() && (this.renamedInstalledImDir != null || this.installRegistryBackup != null);
    }

    private IStatus renameInstalledImDir(File installLocation) {
        File dir = this.getLogicalInstallLocation(installLocation);
        if (!dir.isDirectory()) {
            this.renamedInstalledImDir = null;
            return Status.OK_STATUS;
        }
        this.renamedInstalledImDir = this.getBackup(dir);
        try {
            FileUtil.renameTo((File)dir, (File)this.renamedInstalledImDir, (boolean)false);
            log.debug(Messages.AgentInstall_reinstallImRenameImDirSucceeded, new Object[]{dir, this.renamedInstalledImDir});
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            ICicStatus status = Statuses.ERROR.get((Throwable)e, Messages.AgentInstall_reinstallImRenameImDirFailed, new Object[]{dir, this.renamedInstalledImDir});
            this.renamedInstalledImDir = null;
            return status;
        }
    }

    private IStatus removeRenamedInstalledImDir() {
        IStatus result = Status.OK_STATUS;
        if (this.renamedInstalledImDir != null && this.renamedInstalledImDir.isDirectory()) {
            FileUtil.rm_r((File)this.renamedInstalledImDir, (boolean)true);
            if (this.renamedInstalledImDir.isDirectory()) {
                result = Statuses.WARNING.get(Messages.AgentInstall_reinstallImRemoveOrigImDirFailed, new Object[]{this.renamedInstalledImDir});
            } else {
                log.debug(Messages.AgentInstall_reinstallImRemoveOrigImDirSucceeded, new Object[]{this.renamedInstalledImDir});
            }
        }
        this.renamedInstalledImDir = null;
        return result;
    }

    private IStatus restoreRenamedInstalledImDir() {
        IStatus result = Status.OK_STATUS;
        if (this.renamedInstalledImDir != null && this.renamedInstalledImDir.isDirectory()) {
            File originalInstalledImDir = this.getOriginal(this.renamedInstalledImDir);
            try {
                FileUtil.renameTo((File)this.renamedInstalledImDir, (File)originalInstalledImDir, (boolean)false);
                log.debug(Messages.AgentInstall_reinstallImRestoreImDirSucceeded, new Object[]{originalInstalledImDir, this.renamedInstalledImDir});
            }
            catch (IOException e) {
                result = Statuses.ERROR.get((Throwable)e, Messages.AgentInstall_reinstallImRestoreImDirFailed, new Object[]{originalInstalledImDir, this.renamedInstalledImDir});
            }
        }
        this.renamedInstalledImDir = null;
        return result;
    }

    private IStatus backupInstallRegistryFiles(File[] installRegistryFiles) {
        this.installRegistryBackup = new ArrayList<File>();
        File[] fileArray = installRegistryFiles;
        int n = installRegistryFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File backup = this.getBackup(file);
            try {
                FileUtil.copyFile((File)file, (File)backup);
                this.installRegistryBackup.add(backup);
                log.debug(Messages.AgentInstall_reinstallImBackupInstallRegistryDataSucceeded, new Object[]{file, backup});
            }
            catch (IOException e) {
                if (this.installRegistryBackup.isEmpty()) {
                    this.installRegistryBackup = null;
                }
                return Statuses.ERROR.get((Throwable)e, Messages.AgentInstall_reinstallImBackupInstallRegistryDataFailed, new Object[]{file, backup});
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private IStatus removeInstallRegistryBackup() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        if (this.installRegistryBackup == null) {
            return result;
        }
        for (File backup : this.installRegistryBackup) {
            if (!backup.isFile()) continue;
            FileUtil.rm_r((File)backup, (boolean)false);
            if (backup.isFile()) {
                result.add((IStatus)Statuses.WARNING.get(Messages.AgentInstall_reinstallImRemoveBackupInstallRegistryDataFailed, new Object[]{backup}));
                continue;
            }
            log.debug(Messages.AgentInstall_reinstallImRemoveBackupInstallRegistryDataSucceeded, new Object[]{backup});
        }
        this.installRegistryBackup = null;
        return result;
    }

    private IStatus restoreInstallRegistryFiles() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        if (this.installRegistryBackup == null) {
            return result;
        }
        for (File backup : this.installRegistryBackup) {
            if (!backup.isFile()) continue;
            File file = this.getOriginal(backup);
            IStatus status = Status.OK_STATUS;
            try {
                FileUtil.copyFile((File)backup, (File)file);
                FileUtil.rm_r((File)backup, (boolean)false);
                if (backup.isFile()) {
                    status = Statuses.WARNING.get(Messages.AgentInstall_reinstallImRemoveBackupInstallRegistryDataFailed, new Object[]{backup});
                }
            }
            catch (IOException e) {
                status = Statuses.ERROR.get((Throwable)e, Messages.AgentInstall_reinstallImRestoreInstallRegistryDataFailed, new Object[]{file, backup});
            }
            if (!status.matches(4)) {
                log.debug(Messages.AgentInstall_reinstallImRestoreInstallRegistryDataSucceeded, new Object[]{file, backup});
            }
            result.add(status);
        }
        this.installRegistryBackup = null;
        return result;
    }

    private File getBackup(File file) {
        int i = 0;
        while (true) {
            File backup;
            String path = String.valueOf(file.getPath()) + BACKUP_SUFFIX;
            if (i != 0) {
                path = String.valueOf(path) + '_' + String.valueOf(i);
            }
            if (!(backup = new File(path)).exists()) {
                return backup;
            }
            ++i;
        }
    }

    private File getOriginal(File backup) {
        String path = backup.getPath();
        int i = path.indexOf(BACKUP_SUFFIX);
        return new File(path.substring(0, i));
    }

    private IStatus getReinstallImOnlyForImInstallerStatus() {
        return Statuses.ERROR.get(Messages.AgentInstall_reinstallImOnlyForImInstaller, new Object[]{"-reinstallIM"});
    }

    private IStatus getReinstallImOnlyWhenImInstalledStatus() {
        return Statuses.ERROR.get(Messages.AgentInstall_reinstallImOnlyWhenImInstalled, new Object[]{"-reinstallIM"});
    }

    private IStatus getReinstallImWhenInstalledImIsNewerStatus() {
        Version version = this.installedRegistry.getInstalledAgentVersion();
        Version internalVersion = this.installedRegistry.getInstalledAgentInternalVersion();
        File location = this.installedRegistry.getInstalledAgentLocation();
        File appDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        return Statuses.ERROR.get(Messages.AgentInstall_reinstallImWhenInstalledImIsNewer, new Object[]{version, internalVersion, location, appDataLocation, "-reinstallIM"});
    }

    private IStatus getReinstallImOnlyWhenImBeingInstalledStatus() {
        return Statuses.ERROR.get(Messages.AgentInstall_reinstallImOnlyWhenImBeingInstalled, new Object[]{"-reinstallIM"});
    }

    private IStatus getImInstalledAlreadyStatus(int severity) {
        Version version = this.installedRegistry.getInstalledAgentVersion();
        Version internalVersion = this.installedRegistry.getInstalledAgentInternalVersion();
        File location = this.installedRegistry.getInstalledAgentLocation();
        File appDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        return Statuses.ST.createStatus(severity, 0, null, Messages.AgentInstall_imInstalledAlready, new Object[]{version, internalVersion, location, appDataLocation});
    }

    private IStatus getImInstalledAlreadyAtDataLocStatus(ILocation imLoc) {
        IPackage imPkg = this.getInstallationManagerPackage(imLoc);
        Version version = new Version(imPkg.getProperty("cic.info.version"));
        Version internalVersion = imPkg.getVersion();
        File location = new File(imLoc.getPath());
        File appDataLocation = new File(CicCommonSettings.getApplicationDataLocation());
        return Statuses.ERROR.get(Messages.AgentInstall_imInstalledAlready, new Object[]{version, internalVersion, location, appDataLocation});
    }

    private IStatus getImInstalledAlreadyWithDifferentAppDataLocationStatus() {
        Version version = this.installedRegistry.getInstalledAgentVersion();
        Version internalVersion = this.installedRegistry.getInstalledAgentInternalVersion();
        File location = this.installedRegistry.getInstalledAgentLocation();
        File appDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        return Statuses.ERROR.get(Messages.AgentInstall_imInstalledAlreadyWithDifferentAppDataLocation, new Object[]{version, internalVersion, location, appDataLocation, CicCommonSettings.getApplicationDataLocation()});
    }

    private IStatus validateAgentRegistry() {
        IPackage imPkg;
        if (this.isIm100xInstalled()) {
            return Status.OK_STATUS;
        }
        Version versionFromRegistry = this.installedRegistry.getInstalledAgentVersion();
        Version internalVersionFromRegistry = this.installedRegistry.getInstalledAgentInternalVersion();
        File installLocationFromRegistry = this.installedRegistry.getInstalledAgentLocation();
        Version versionFromInstallInfo = Version.emptyVersion;
        Version internalVersionFromInstallInfo = Version.emptyVersion;
        File installLocationFromInstallInfo = null;
        ILocation imLoc = this.getImLocationFromCurDataLoc();
        IPackage iPackage = imPkg = imLoc == null ? null : this.getInstallationManagerPackage(imLoc);
        if (imPkg != null) {
            versionFromInstallInfo = new Version(imPkg.getProperty("cic.info.version"));
            internalVersionFromInstallInfo = imPkg.getVersion();
            installLocationFromInstallInfo = new File(imLoc.getPath());
        }
        String regInfoLoc = this.installedRegistry.getRegistryLocation();
        if (this.isAgentBeingInstalled() && !"win32".equals(Platform.getOS())) {
            File registryParentDir = new File(regInfoLoc).getParentFile();
            registryParentDir.mkdirs();
            if (!FileUtil.canWrite((File)registryParentDir)) {
                return Statuses.ERROR.get(Messages.AgentInstall_Registry_Dir_Not_Writable, new Object[]{regInfoLoc});
            }
        }
        File installedAppDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        ICicStatus details = null;
        if (installLocationFromInstallInfo == null) {
            if (installLocationFromRegistry != null) {
                details = Statuses.ERROR.get(Messages.AgentInstall_registryInconsistentWithAppDataLocationDetails1, new Object[]{regInfoLoc, versionFromRegistry, internalVersionFromRegistry, installLocationFromRegistry, installedAppDataLocation});
            }
        } else if (installLocationFromRegistry == null) {
            File curAppDataLocation = new File(CicCommonSettings.getApplicationDataLocation());
            details = Statuses.ERROR.get(Messages.AgentInstall_registryInconsistentWithAppDataLocationDetails2, new Object[]{regInfoLoc, curAppDataLocation, versionFromInstallInfo, internalVersionFromInstallInfo, installLocationFromInstallInfo});
        } else if (!versionFromRegistry.equals((Object)versionFromInstallInfo) || !internalVersionFromRegistry.equals((Object)internalVersionFromInstallInfo)) {
            details = Statuses.ERROR.get(Messages.AgentInstall_registryInconsistentWithAppDataLocationDetails3, new Object[]{regInfoLoc, versionFromRegistry, internalVersionFromRegistry, installLocationFromRegistry, installedAppDataLocation, versionFromInstallInfo, internalVersionFromInstallInfo, installLocationFromInstallInfo});
        }
        if (details != null) {
            CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.AgentInstall_registryInconsistentWithAppDataLocation, new Object[0]);
            status.add(details);
            return status;
        }
        return Status.OK_STATUS;
    }

    private ILocation getImLocationFromCurDataLoc() {
        File curAppDataLocation = new File(CicCommonSettings.getApplicationDataLocation());
        File installInfoFile = new File(curAppDataLocation, "installed.xml");
        try {
            return this.getImLocationFromDataLoc(installInfoFile);
        }
        catch (CoreException e) {
            log.status(e.getStatus());
            return null;
        }
    }

    private ILocation getImLocationFromDataLoc(File installInfoFile) throws CoreException {
        ILocationFilter locationFilter;
        if (!installInfoFile.isFile()) {
            return null;
        }
        IInstallInfo info = InstallInfoUtils.getInstallInfo((File)installInfoFile);
        ILocation[] locations = info.getLocations(locationFilter = new ILocationFilter(){

            public boolean accept(ILocation location) {
                return "self".equals(location.getKind());
            }
        });
        if (locations.length != 1) {
            return null;
        }
        ILocation imLoc = locations[0];
        File installLocation = new File(imLoc.getPath());
        if (!installLocation.isDirectory()) {
            imLoc = null;
        }
        return imLoc;
    }

    private IPackage getInstallationManagerPackage(ILocation imLoc) {
        IPackageFilter packageFilter = new IPackageFilter(){

            public boolean accept(IPackage pkg) {
                return "com.ibm.cic.agent".equals(pkg.getId());
            }
        };
        IPackage[] packages = imLoc.getPackages(packageFilter);
        if (packages.length != 1) {
            return null;
        }
        IPackage imPkg = packages[0];
        return imPkg;
    }

    private boolean sameDataLocation() {
        File installedAppDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        File curAppDataLocation = new File(CicCommonSettings.getApplicationDataLocation());
        return FileUtil.filesAreSame((File)installedAppDataLocation, (File)curAppDataLocation);
    }

    public void setPostAgentInstallInput(AgentJob job) {
        File postInputFile = this.getPostAgentInstallInputFile();
        if (postInputFile == null || !postInputFile.isFile()) {
            if (CmdLine.CL.isLiveInput() || this.newerVersionOfAgentInstalled(job) && this.moreInstallCommandsInInputFile()) {
                return;
            }
            try {
                postInputFile = FileUtil.createTempFile((String)POST_AGENT_INSTALL_INPUT_PREFIX, null);
                postInputFile = postInputFile.getCanonicalFile();
                Input input = new Input();
                input.setCleanMode(false);
                input.setTemporaryMode(false);
                input.save(postInputFile);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        AgentRelaunch.getInstance().addRelaunchApplicationArguments(new String[]{"input", postInputFile.getPath()});
    }

    private boolean newerVersionOfAgentInstalled(AgentJob job) {
        if (!this.isAgentInstallerRunning()) {
            return false;
        }
        IOffering offering = job.getOffering();
        if (offering == null) {
            return false;
        }
        if (!"com.ibm.cic.agent".equals(offering.getIdentity().getId())) {
            return false;
        }
        Version agentInternalVersion = offering.getVersion();
        return this.installerInternalVersion.compareTo(agentInternalVersion) < 0;
    }

    private IInput getInput() {
        String inputFileArg = CmdLine.CL.getResponseFile();
        if (inputFileArg != null) {
            Input input = new Input();
            try {
                IStatus status = input.load(new File(inputFileArg));
                if (status.getSeverity() == 4) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            return input;
        }
        return CmdInputBuilder.getCommandList();
    }

    private boolean moreInstallCommandsInInputFile() {
        IImportCommand[] importCommands;
        IInput input = this.getInput();
        if (input == null) {
            return false;
        }
        if (!CmdLine.CL.isInteractiveMode() && (importCommands = input.getImportCommands()).length != 0) {
            return true;
        }
        IInstallCommand[] installCommands = input.getInstallCommands();
        if (installCommands.length > 1) {
            return true;
        }
        if (installCommands.length != 1) {
            return false;
        }
        IInstallCommand installCommand = installCommands[0];
        List offeringIds = installCommand.getOfferingIds();
        if (offeringIds.size() > 1) {
            return true;
        }
        if (offeringIds.size() != 1) {
            return false;
        }
        return !"com.ibm.cic.agent".equals(offeringIds.get(0));
    }

    public IStatus addInstallerArtifactRepository() {
        if (!this.isAgentInstallerRunning()) {
            return Status.OK_STATUS;
        }
        System.setProperty("SKIP_AGENT_PLATFORM_XML_FIXUP", "true");
        RepositoryGroup group = RepositoryGroup.getDefault();
        int origGroupSize = group.size();
        if (this.installerRepositoryLocation == null) {
            IRepositoryInfo info;
            IRepository repo;
            IStatus status = this.createInstallerArtifactRepository();
            if (!status.isOK()) {
                return status;
            }
            if (origGroupSize > 1 && (repo = group.findRepository(info = group.createRepositoryInfo("Installer Repository", "Dir", "0.0.0.1", (ICicLocation)new CicFileLocation(this.installerLocation.getPath()), null))) != null) {
                int numMoves = origGroupSize - 1;
                int i = 0;
                while (i < numMoves) {
                    group.moveUp(repo);
                    ++i;
                }
            }
        }
        IRepositoryInfo info = group.createRepositoryInfo("Installer Artifact Repository", "Dir", "0.0.0.1", (ICicLocation)new CicFileLocation(this.installerRepositoryLocation.getPath()), null);
        RepositoryContext.setRequiredContext((IRepositoryInfo)info, (String)"InstallKit");
        IRepository repo = null;
        try {
            repo = group.addExistingRepository(info, true);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        if (repo == null) {
            return new Status(4, AgentActivator.getPluginId(), 0, NLS.bind((String)Messages.AgentInstall_jreArtifactRepositoryOpenFailed, (Object)this.installerRepositoryLocation.toString()), null);
        }
        int i = 0;
        while (i < origGroupSize) {
            group.moveUp(repo);
            ++i;
        }
        this.installerRepository = repo;
        return Status.OK_STATUS;
    }

    public void closeInstallerArtifactRepository() {
        if (this.isAgentInstallerRunning() && this.installerRepository != null) {
            RepositoryGroup.getDefault().removeRepository(this.installerRepository);
            this.installerRepository = null;
        }
    }

    public IStatus removeInstallerArtifactRepository() {
        if (!this.isAgentInstallerRunning() || this.installerRepositoryLocation == null) {
            return Status.OK_STATUS;
        }
        if (this.installerRepositoryLocation.isDirectory()) {
            FileUtil.rm_r((File)this.installerRepositoryLocation, (boolean)true);
        }
        this.installerRepositoryLocation = null;
        this.explodedInstallerArtifacts.clear();
        return Status.OK_STATUS;
    }

    public boolean isAgentInstallerRunning() {
        return !Version.emptyVersion.equals((Object)this.installerInternalVersion);
    }

    public boolean isAgentInstalled() {
        return !Version.emptyVersion.equals((Object)this.getInstalledAgentInternalVersion()) || this.isIm100xInstalled();
    }

    private boolean isIm100xInstalled() {
        Version installedAgentVersion = this.getInstalledAgentVersion();
        return installedAgentVersion.getMajor() == 1 && installedAgentVersion.getMinor() == 0;
    }

    public File getInstallerLocation() {
        return this.installerLocation;
    }

    public Version getInstallerVersion() {
        return this.installerVersion;
    }

    public Version getInstallerInternalVersion() {
        return this.installerInternalVersion;
    }

    public Version getInstallerJreVersion() {
        return this.installerJreVersion;
    }

    public Version getInstalledAgentInternalVersion() {
        return this.installedRegistry.getInstalledAgentInternalVersion();
    }

    public Version getInstalledAgentVersion() {
        return this.installedRegistry.getInstalledAgentVersion();
    }

    public File getInstallerRepositoryLocation() {
        return this.installerRepositoryLocation;
    }

    public String massageAgentInstallLocation(String location) {
        if (!this.isAgentInstallerRunning()) {
            return location;
        }
        File f = new File(location);
        if (!f.getName().equals("eclipse")) {
            f = new File(f, "eclipse");
            return f.getPath();
        }
        return location;
    }

    public File getLogicalInstallLocation(File location) {
        if ("eclipse".equals(location.getName())) {
            return location.getParentFile();
        }
        return location;
    }

    public File getPostAgentInstallInputFile(String inputFileArg) {
        File inputFile = new File(inputFileArg);
        File postInputFile = new File(inputFile.getParentFile(), POST_AGENT_INSTALL_INPUT_PREFIX + inputFile.getName());
        return postInputFile;
    }

    public boolean isInstallFromMultipleDisks() {
        if (this.installFromMultipleDisks == null) {
            this.installFromMultipleDisks = this.isInstallFromMultiDisks();
        }
        return this.installFromMultipleDisks;
    }

    public IStatus relaunchWithTemporaryInstaller(IProgressMonitor monitor) {
        String[] fileExclusions = new String[]{INSTALL_FROM_MULTIPLE_DISKS};
        try {
            IStatus iStatus = AgentRelaunch.getInstance().setRelaunchWithTemporaryInstaller(this.installerLocation, fileExclusions, monitor);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public IStatus cancelRelaunchWithTemporaryInstaller() {
        return AgentRelaunch.getInstance().cancelRelaunchWithTemporaryInstaller();
    }

    public File getExplodedInstallerArtifact(File file) {
        if (!this.isAgentInstallerRunning() || this.installerRepository == null) {
            return null;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return (File)this.explodedInstallerArtifacts.get(String.valueOf(parentFile.getName()) + '/' + file.getName());
    }

    public IStatus installExplodedInstallerArtifact(File explodedArtifact, File dest, String taskName, IProgressMonitor monitor) {
        return this.installExplodedInstallerArtifact(explodedArtifact, dest, null, taskName, monitor);
    }

    public IStatus installExplodedInstallerArtifact(File explodedArtifact, File dest, String perm, String taskName, IProgressMonitor monitor) {
        try {
            if (!explodedArtifact.exists()) {
                String m = NLS.bind((String)Messages.AgentInstall_explodedDirectoryNoLongerExists, (Object)explodedArtifact.toString());
                return new Status(4, AgentActivator.getPluginId(), 0, m, null);
            }
            FileUtil.copyDir((File)explodedArtifact, (File)dest, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (String)perm, (String)taskName, (IProgressMonitor)monitor);
            if (!dest.exists() || !dest.isDirectory()) {
                String m = NLS.bind((String)Messages.AgentInstall_errorCopyingExplodedDirectory, (Object)explodedArtifact, (Object)dest);
                return new Status(4, AgentActivator.getPluginId(), 0, m, null);
            }
        }
        catch (IOException e) {
            String m = NLS.bind((String)Messages.AgentInstall_errorCopyingExplodedDirectory, (Object)explodedArtifact, (Object)dest);
            return new Status(4, AgentActivator.getPluginId(), 0, m, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean isAgentInstallerLocation(IRepository repo) {
        if (!this.isAgentInstallerRunning()) {
            return false;
        }
        if (repo == null) {
            return false;
        }
        String repoLoc = repo.getLocationStr();
        if (repoLoc == null) {
            return false;
        }
        File repoDir = new File(repoLoc);
        boolean isInstallerLocation = FileUtil.filesAreSame((File)repoDir, (File)this.installerLocation);
        if (!isInstallerLocation && this.installerRepositoryLocation != null) {
            isInstallerLocation = FileUtil.filesAreSame((File)repoDir, (File)this.installerRepositoryLocation);
        }
        return isInstallerLocation;
    }

    public IStatus finish(String installLocation) {
        if (!this.isAgentInstallerRunning()) {
            return Status.OK_STATUS;
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        status.add(this.removeRenamedInstalledImDir());
        status.add(this.removeInstallRegistryBackup());
        status.add(this.removeInstallerArtifactRepository());
        return status;
    }

    private void initialize() {
        File eclipseConfiguration = EclipseUtil.getCurrentEclipseConfiguration();
        String installerLocationValue = System.getProperty("AGENT_INSTALLER_LOCATION", eclipseConfiguration != null ? eclipseConfiguration.getParent() : null);
        if (installerLocationValue != null) {
            File file = new File(installerLocationValue);
            try {
                this.installerLocation = file.getCanonicalFile();
            }
            catch (IOException e) {
                this.installerLocation = file;
            }
        }
        this.installerVersion = AgentRegistry.getVersion(System.getProperty(IM_INSTALLER_VERSION));
        this.installerInternalVersion = AgentRegistry.getVersion(System.getProperty(IM_INSTALLER_INTERNAL_VERSION));
        this.installerJreVersion = AgentRegistry.getVersion(System.getProperty(IM_INSTALLER_JRE_VERSION));
        IInstallKitContext installKitContext = (IInstallKitContext)RepositoryContext.getInstance().findContext("InstallKit");
        installKitContext.setRunningInstallerVersions(new IInstallKitContext.IProvideAgentVersions(){

            public Version getDisplayVersion() {
                return AgentInstall.this.getInstallerVersion();
            }

            public Version getInternalVersion() {
                return AgentInstall.this.getInstallerInternalVersion();
            }
        });
        if (this.installerLocation != null) {
            this.installedRegistry = AgentRegistry.getInstance();
        }
    }

    private IStatus relaunchWithInstalledAgent() {
        AgentRelaunch relaunch = AgentRelaunch.getInstance();
        boolean succeeded = relaunch.setRelaunchWithInstalledLauncherIniArguments(this.installedRegistry.getInstalledAgentLocation());
        if (!succeeded) {
            return new Status(4, AgentActivator.getPluginId(), 0, Messages.AgentInstall_relaunchProblem, null);
        }
        relaunch.setNeedsRelaunch(true);
        return Status.OK_STATUS;
    }

    private IStatus createInstallerArtifactRepository() {
        File placeHolderZip = null;
        try {
            placeHolderZip = this.createPlaceholderZip();
            this.installerRepositoryLocation = FileUtil.createTempFile((String)"installerRepository", null);
            this.installerRepositoryLocation = this.installerRepositoryLocation.getCanonicalFile();
            if (!this.installerRepositoryLocation.delete()) {
                ICicStatus iCicStatus = Statuses.ERROR.get(Messages.CacheManager_Failed_To_DeleteError, new Object[]{this.installerRepositoryLocation.getPath()});
                return iCicStatus;
            }
            try {
                File installerRepNativeDir = new File(this.installerRepositoryLocation, NATIVE_DIR_NAME);
                File installerRepPluginsDir = new File(this.installerRepositoryLocation, PLUGINS_DIR_NAME);
                installerRepNativeDir.mkdirs();
                installerRepPluginsDir.mkdirs();
                File installerPluginsLocation = new File(this.installerLocation, PLUGINS_DIR_NAME);
                File[] explodedPlugins = installerPluginsLocation.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                if (explodedPlugins != null) {
                    File[] fileArray = explodedPlugins;
                    int n = explodedPlugins.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File explodedPlugin = fileArray[n2];
                        File explodedPluginArtifact = new File(installerRepPluginsDir, String.valueOf(explodedPlugin.getName()) + CicConstants.getJarFileDotExt());
                        FileUtil.copyFile((File)placeHolderZip, (File)explodedPluginArtifact);
                        this.explodedInstallerArtifacts.put("plugins/" + explodedPluginArtifact.getName(), explodedPlugin);
                        ++n2;
                    }
                }
                File installerJreLocation = new File(this.installerLocation, "jre_" + this.installerJreVersion.toString());
                String jreArch = Platform.getOSArch().equals("sparcv9") ? "sparc64" : Platform.getOSArch();
                File jreArtifact = new File(installerRepNativeDir, "jre." + Platform.getOS() + '.' + jreArch + '_' + this.installerJreVersion.toString() + CicConstants.getZipFileDotExt());
                FileUtil.copyFile((File)placeHolderZip, (File)jreArtifact);
                this.explodedInstallerArtifacts.put("native/" + jreArtifact.getName(), installerJreLocation);
                String repCfg = "repository.config";
                FileUtil.copyFile((File)new File(this.installerLocation, repCfg), (File)new File(this.installerRepositoryLocation, repCfg));
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.AgentInstall_artifactCreationFailed, (Object)e.toString());
                log.error(msg);
                Status status = new Status(4, AgentActivator.getPluginId(), 0, msg, null);
                return status;
            }
        }
        finally {
            if (placeHolderZip != null && placeHolderZip.isFile()) {
                placeHolderZip.delete();
            }
        }
        return Status.OK_STATUS;
    }

    private File createPlaceholderZip() throws IOException {
        File file = FileUtil.createTempFile((String)PLACEHOLDER_NAME, (String)CicConstants.getZipFileDotExt());
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(file));
        stream.putNextEntry(new ZipEntry(PLACEHOLDER_NAME));
        stream.closeEntry();
        stream.close();
        return file;
    }

    private boolean isInstallFromMultiDisks() {
        if (!this.isAgentInstallerRunning()) {
            return false;
        }
        if (AgentRelaunch.getInstance().isTemporaryInstaller()) {
            return false;
        }
        File mdFile = new File(this.installerLocation, INSTALL_FROM_MULTIPLE_DISKS);
        if (mdFile.isFile()) {
            return true;
        }
        if (System.getProperty("SINGLE_DISK_INSTALL") != null) {
            return false;
        }
        IInput input = this.getInput();
        if (input == null) {
            return false;
        }
        File installerMountPoint = DeviceSystem.getMountPoint((File)this.installerLocation);
        List locations = input.getRepositories();
        for (String location : locations) {
            if (FileURLUtil.isURLString((String)location, (boolean)true)) continue;
            File file = new File(location);
            File mountPoint = DeviceSystem.getMountPoint((File)this.installerLocation);
            if (!FileUtil.directoriesAreRelated((File)mountPoint, (File)installerMountPoint) || !this.isPartiallyUnavailableMultiDiskVolumeRepository(file)) continue;
            return true;
        }
        return false;
    }

    private boolean isPartiallyUnavailableMultiDiskVolumeRepository(File location) {
        RepositoryGroup group = new RepositoryGroup("Installer");
        IRepositoryInfo info = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)group, (String)"Installer", null, null, (String)location.toString(), null);
        this.checkAndSetInstallerContext(info);
        IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
        try {
            IRepository repo = null;
            try {
                repo = group.addExistingRepository(info, true);
            }
            catch (Exception e) {
                group.removeAllRepositories();
                session.close();
                return false;
            }
            if (repo == null) {
                return false;
            }
            IVolumeAccessByDisk byDisk = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)repo);
            if (byDisk == null) {
                return false;
            }
            IVolumeAccessByDisk.IDiskSet[] diskSets = byDisk.getDiskSets(session, (IProgressMonitor)new NullProgressMonitor());
            if (diskSets == null || diskSets.length == 0) {
                return false;
            }
            if (diskSets.length == 1 && diskSets[0].getDiskCount() < 2) {
                return false;
            }
            IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets;
            int n = diskSets.length;
            int n2 = 0;
            while (n2 < n) {
                IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
                IVolumeAccessByDisk.IDiskSetDisks disks = diskSet.useAllDisks();
                if (!byDisk.disksAvailable(session, disks, (IProgressMonitor)new NullProgressMonitor())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        finally {
            group.removeAllRepositories();
            session.close();
        }
    }

    private AgentInstall() {
        this.initialize();
    }

    private File getPostAgentInstallInputFile() {
        String inputFileArg = CmdLine.CL.getResponseFile();
        if (inputFileArg == null) {
            return null;
        }
        return this.getPostAgentInstallInputFile(inputFileArg);
    }

    private void cleanupTemporaryInstaller() {
        File tempInstallerLocation;
        String tempInstaller = System.getProperty("cleanup.temporary.installer");
        if (tempInstaller != null && (tempInstallerLocation = new File(tempInstaller)).isDirectory()) {
            String inputFileArg = CmdLine.CL.getResponseFile();
            File inputFile = null;
            if (inputFileArg != null && (inputFile = new File(inputFileArg)).getPath().startsWith(tempInstallerLocation.getPath())) {
                try {
                    File tempInputFile = FileUtil.createTempFile((String)"install", null);
                    FileUtil.copyFile((File)inputFile, (File)tempInputFile);
                    CmdLine.CL.setParam1StrVal("input", tempInputFile.getCanonicalPath());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            FileUtil.rm_r((File)tempInstallerLocation, (boolean)true);
        }
    }

    public void checkAndSetInstallerContext(IRepositoryInfo repInfo) {
        String location = repInfo.getLocationStr();
        if (this.installerLocation != null && FileURLUtil.isFileLocation((String)location)) {
            try {
                File file = FileURLUtil.locationToFile((String)location).getCanonicalFile();
                if (file.equals(this.installerLocation)) {
                    RepositoryContext.setRequiredContext((IRepositoryInfo)repInfo, (String)"InstallKit");
                }
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private boolean isAgentBeingInstalled() {
        if (this.isAgentBeingInstalled == null) {
            this.isAgentBeingInstalled = this.computeIsAgentBeingInstalled();
        }
        return this.isAgentBeingInstalled;
    }

    private boolean computeIsAgentBeingInstalled() {
        IInstallCommand[] installCommands;
        IInput input = this.getInput();
        if (input == null) {
            return false;
        }
        List locations = input.getRepositories();
        boolean installerRepoFound = false;
        for (String location : locations) {
            if (FileURLUtil.isURLString((String)location, (boolean)true)) continue;
            File file = new File(location);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (!FileUtil.filesAreSame((File)file, (File)this.getInstallerLocation())) continue;
            installerRepoFound = true;
        }
        if (!installerRepoFound) {
            return false;
        }
        IInstallCommand[] iInstallCommandArray = installCommands = input.getInstallCommands();
        int n = installCommands.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallCommand installCommand = iInstallCommandArray[n2];
            List offeringIds = installCommand.getOfferingIds();
            for (String id : offeringIds) {
                if (!"com.ibm.cic.agent".equals(id)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IStatus checkRegistryFileConflict() {
        CicCommonSettings.AccessRights regAccessRights;
        IInstallInfo info;
        if ("win32".equals(Platform.getOS())) {
            return Status.OK_STATUS;
        }
        File slashDir = new File("/");
        File userhome = new File(System.getProperty("user.home"));
        if (!FileUtil.filesAreSame((File)slashDir, (File)userhome)) {
            return Status.OK_STATUS;
        }
        File installedAppDataLocation = this.installedRegistry.getInstalledAgentAppDataLocation();
        File installInfoFile = new File(installedAppDataLocation, "installed.xml");
        if (!installInfoFile.isFile()) {
            return Status.OK_STATUS;
        }
        try {
            info = InstallInfoUtils.getInstallInfo((File)installInfoFile);
        }
        catch (CoreException e) {
            log.status(e.getStatus());
            return Status.OK_STATUS;
        }
        String value = info.getProperty("accessRights");
        if (value == null) {
            return Status.OK_STATUS;
        }
        CicCommonSettings.AccessRights imAccessRights = CicCommonSettings.getAccessRightsMode();
        if (imAccessRights.equals((Object)(regAccessRights = CicCommonSettings.AccessRights.toMode((String)value)))) {
            return Status.OK_STATUS;
        }
        if (imAccessRights.isGroupMode() || regAccessRights.isGroupMode()) {
            return Status.OK_STATUS;
        }
        String regInfoLoc = this.installedRegistry.getRegistryLocation();
        Version version = this.installedRegistry.getInstalledAgentVersion();
        Version internalVersion = this.installedRegistry.getInstalledAgentInternalVersion();
        File location = this.installedRegistry.getInstalledAgentLocation();
        File installRegistryLocation = new File(installedAppDataLocation, "installRegistry.xml");
        return Statuses.ERROR.get(Messages.AgentInstall_registryFileConflict, new Object[]{regInfoLoc, version, internalVersion, location, installedAppDataLocation, imAccessRights, installRegistryLocation, value});
    }

    public boolean isIMLiteRunning() {
        String imEdition = System.getProperty(IM_EDITION_PROPERTY_KEY);
        return imEdition != null && imEdition.equalsIgnoreCase(IM_LITE_PROPERTY);
    }

    public IStatus checkForIMLite() {
        ILocation imLoc;
        if (this.isIMLiteRunning() && (imLoc = this.getImLocationFromCurDataLoc()) != null) {
            return Statuses.ERROR.get(Messages.AgentInstall_dataLocationContainsAgentError, new Object[]{CicCommonSettings.getApplicationDataLocation()});
        }
        return Status.OK_STATUS;
    }
}

