/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.core;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseCheckerFactory;
import com.ibm.cic.licensing.common.core.Messages;
import com.ibm.cic.licensing.common.core.RegScanner;
import com.ibm.cic.licensing.common.util.ComponentInfo;
import com.ibm.cic.licensing.common.util.ComponentKey;
import com.ibm.cic.licensing.common.util.ComponentKeyVO;
import com.ibm.cic.licensing.common.util.LicPlatformUtils;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.ProductInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

public class LicenseChecker {
    private static String lastErrMsg = "";
    private static Hashtable lastErrCondtion = new Hashtable();

    public static int requestLicense(Plugin aPlugin, String aFeatureName, String aVersion, boolean quiet) {
        String bundleName = LicUserUtils.getPluginName((Plugin)aPlugin, (String)aFeatureName);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("requestLicense(plugin, fname, fversion) called from " + bundleName + " for (" + aFeatureName + ", " + aVersion + ")"));
        }
        LicenseChecker.setLastErrMsg("");
        lastErrCondtion.clear();
        String purchaseURL = "http://www.ibm.com/software/info/ecatalog";
        ComponentInfo cInfo = RegScanner.getComponentInfo(aFeatureName, aVersion);
        if (cInfo == null) {
            if (!quiet) {
                String errmsg = NLS.bind((String)Messages.Plugin_No_Key, (Object)bundleName);
                LicenseChecker.setLastErrMsg(errmsg);
                lastErrCondtion.put(new ProductInformation("NILL"), new Exception(NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName)));
            }
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName));
            }
            return 2;
        }
        LicenseStatus componentStatus = cInfo.getLicStatus();
        if (componentStatus != null && componentStatus.isLicenseGranted()) {
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)("Returning success since license is already granted for " + cInfo.printCInfo()));
            }
            ProductInformation checkedOutProduct = cInfo.getProductCheckedOut();
            if (componentStatus.getStatusCode() == 4) {
                LicenseChecker.setRunInDisconnectStatus(checkedOutProduct);
            } else if (componentStatus.isLicenseWillExpire()) {
                LicenseChecker.setWillExpireStatus(checkedOutProduct, componentStatus);
            }
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)"Either license will expire or in disconnected mode");
                Logger.logNtrace((String)("Returning " + componentStatus.getStatusCode()));
            }
            return componentStatus.getStatusCode();
        }
        int piSize = cInfo.getProducts().size();
        if (piSize < 1) {
            if (!quiet) {
                String errmsg = NLS.bind((String)Messages.Plugin_No_Key, (Object)bundleName);
                LicenseChecker.setLastErrMsg(errmsg);
                lastErrCondtion.put(new ProductInformation("NILL"), new Exception(NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName)));
            }
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName));
            }
            return 2;
        }
        ArrayList checkedOutProductList = (ArrayList)RegScanner.getCheckedOutProductList();
        for (ProductInformation p : checkedOutProductList) {
            if (!p.getComponents().contains(cInfo)) continue;
            p.addToCheckedOutComponents(cInfo);
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)("License already checked out by " + p));
            }
            LicenseStatus licstatus = p.getLicenseStatus();
            cInfo.setLicStatus(licstatus);
            cInfo.setProductCheckedOut(p);
            if (p.isExpirationWarned()) {
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((String)"Expiration warning given returning success");
                }
                return 0;
            }
            if (licstatus.getStatusCode() == 4) {
                LicenseChecker.setRunInDisconnectStatus(p);
            } else if (licstatus.isLicenseWillExpire()) {
                LicenseChecker.setWillExpireStatus(p, licstatus);
            }
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)"Either license will expire or in disconnected mode");
                Logger.logNtrace((String)("Returning " + licstatus.getStatusCode()));
            }
            return licstatus.getStatusCode();
        }
        for (ProductInformation p : cInfo.getProducts()) {
            for (ProductInformation checkedoutProduct : checkedOutProductList) {
                ArrayList componentList = new ArrayList(checkedoutProduct.getCheckedOutComponents());
                if (!p.getComponents().containsAll(componentList)) continue;
                LicenseChecker.checkoutProductLicense(p, cInfo);
                if (!p.getLicenseStatus().isLicenseGranted()) {
                    if (!Logger.isTracing((boolean)Logger.DEBUG_METHODS)) continue;
                    Logger.logNtrace((String)("Continuing to next product since checkout failed for " + p));
                    continue;
                }
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((String)("Checked out product " + p + ". Going to check in " + checkedoutProduct));
                }
                LicenseChecker.checkinProductLicense(checkedoutProduct);
                p.addToCheckedOutComponents(componentList);
                p.addToCheckedOutComponents(cInfo);
                cInfo.setProductCheckedOut(p);
                for (ComponentInfo c : componentList) {
                    c.setProductCheckedOut(p);
                }
                checkedOutProductList.add(p);
                checkedoutProduct.getLicenseStatus().setLicenseGranted(false);
                checkedoutProduct.resetCheckedOutComponentList();
                checkedOutProductList.remove(checkedoutProduct);
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((String)("Combining Product " + checkedoutProduct + " with " + p));
                    Logger.logNtrace((String)("Returning " + p.getLicenseStatus().getStatusCode()));
                }
                return p.getLicenseStatus().getStatusCode();
            }
        }
        if (piSize == 1) {
            purchaseURL = ((ProductInformation)cInfo.getProducts().get(0)).getPurchaseUrl();
        }
        for (ProductInformation pi : cInfo.getProducts()) {
            int checkoutRet = LicenseChecker.checkoutProductLicense(pi, cInfo);
            if (pi.getLicenseStatus().isLicenseGranted()) {
                pi.addToCheckedOutComponents(cInfo);
                checkedOutProductList.add(pi);
                cInfo.setProductCheckedOut(pi);
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((String)("Successfully checked out product license " + pi));
                    Logger.logNtrace((String)("Returning " + pi.getLicenseStatus().getStatusCode()));
                }
                return pi.getLicenseStatus().getStatusCode();
            }
            if (checkoutRet != 5) continue;
            String errmsg = NLS.bind((String)Messages.LicenseServerUpgradeRequired, (Object)bundleName);
            LicenseChecker.setLastErrMsg(errmsg);
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.LicenseServerUpgradeRequired, (Object)bundleName));
            }
            return 5;
        }
        String errmsg = piSize == 1 ? LicenseChecker.getLicenseMessageFormText(NLS.bind((String)Messages.License_Check_Failed_Single_Offering, cInfo.getProducts().get(0)), purchaseURL) : LicenseChecker.getLicenseMessageFormText(NLS.bind((String)Messages.License_Check_Failed, (Object)bundleName), purchaseURL);
        LicenseChecker.setLastErrMsg(errmsg);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)"Failed to checkout license ");
            Logger.logNtrace((String)"Returning 2");
        }
        return 2;
    }

    private static void checkinProductLicense(ProductInformation pi) {
        String licType = pi.getLicType() == null ? "LUM" : pi.getLicType();
        ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker(licType);
        licenseChecker.checkin(pi);
    }

    private static int checkoutProductLicense(ProductInformation pi, ComponentInfo cInfo) {
        String licType = pi.getLicType() == null ? "LUM" : pi.getLicType();
        ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker(licType);
        LicenseStatus licstatus = licenseChecker.checkout(pi);
        cInfo.setLicStatus(licstatus);
        if (licstatus.isLicenseGranted()) {
            if (licstatus.getStatusCode() == 4) {
                LicenseChecker.setRunInDisconnectStatus(pi);
            } else if (licstatus.isLicenseWillExpire()) {
                LicenseChecker.setWillExpireStatus(pi, licstatus);
            }
            return licstatus.getStatusCode();
        }
        LicenseChecker.updateErrCondition(pi);
        return licstatus.getStatusCode();
    }

    public static int requestLicense(Plugin aPlugin, String aFeatureName, String aVersion) {
        return LicenseChecker.requestLicense(aPlugin, aFeatureName, aVersion, false);
    }

    private static void setWillExpireStatus(ProductInformation pi, LicenseStatus licstatus) {
        String purchaseURL = LicenseChecker.getProductPurchaseUrl(pi);
        String prodname = pi.getProductName();
        String daysToExpire = String.valueOf(licstatus.getDaysToExpire());
        String nlsmsg = NLS.bind((String)Messages.Prod_Will_Expire, (Object)prodname, (Object)daysToExpire);
        LicenseChecker.setLastErrMsg(LicenseChecker.getLicenseMessageFormText(nlsmsg, purchaseURL));
        lastErrCondtion.put(pi, new Exception(NLS.bind((String)Messages.Prod_Expires_In_Days, (Object[])new String[]{prodname, daysToExpire, purchaseURL})));
    }

    public static String getProductPurchaseUrl(ProductInformation pi) {
        String purchaseURL = "http://www.ibm.com/software/info/ecatalog";
        if (pi.getPurchaseUrl() != null) {
            purchaseURL = pi.getPurchaseUrl();
        }
        return purchaseURL;
    }

    public static String getLicenseMessageFormText(String nlsmsg, String purchaseURL) {
        purchaseURL = LicPlatformUtils.escapeXML((String)purchaseURL);
        String purchaseUrlWithTags = "<a href=\"" + purchaseURL + "\" nowrap=\"true\">" + purchaseURL + "</a>";
        StringBuffer errmsg = new StringBuffer();
        errmsg.append("<form>");
        if (nlsmsg != null && nlsmsg.trim().length() > 0) {
            errmsg.append("<p>");
            errmsg.append(LicPlatformUtils.escapeXML((String)nlsmsg));
            errmsg.append("</p>");
        }
        errmsg.append("<p>");
        errmsg.append(NLS.bind((String)Messages.Prod_Purchase_Link, (Object)purchaseUrlWithTags));
        errmsg.append("</p>");
        errmsg.append("<p>");
        String atagstart = "<a href=\"prodActivationDoc\" nowrap=\"true\">";
        String atagend = "</a>";
        errmsg.append(NLS.bind((String)Messages.Prod_Activate_Link, (Object)atagstart, (Object)atagend));
        errmsg.append("</p></form>");
        return errmsg.toString();
    }

    private static void setRunInDisconnectStatus(ProductInformation pi) {
        String prodname = pi.getProductName();
        String errmsg = NLS.bind((String)Messages.Run_As_Disconnected, (Object)prodname);
        LicenseChecker.setLastErrMsg(errmsg);
        lastErrCondtion.put(pi, new Exception(errmsg));
    }

    private static List getPIsByCompKey(Hashtable piMap, ComponentKey ck) {
        LinkedList rst = new LinkedList();
        Enumeration keys = piMap.keys();
        while (keys.hasMoreElements()) {
            ComponentKeyVO key = (ComponentKeyVO)keys.nextElement();
            if (!key.getId().equalsIgnoreCase(ck.getId()) && !key.getId().equals("*") || !key.getVersion().isIncluded(ck.getVersion())) continue;
            rst.addAll((List)piMap.get(key));
        }
        Collections.sort(rst);
        return rst;
    }

    private static ProductInformation getPiById(String prodID) {
        List piList = RegScanner.getPiList();
        if (piList != null) {
            for (ProductInformation pi : piList) {
                if (!pi.getProductId().equalsIgnoreCase(prodID.trim())) continue;
                return pi;
            }
        }
        return null;
    }

    private static void updateErrCondition(ProductInformation pi) {
        if (pi.getLicenseStatus() != null && pi.getLicenseStatus().getErrException() != null) {
            lastErrCondtion.put(pi, pi.getLicenseStatus().getErrException());
        }
    }

    public static Hashtable getLastErrCondtion() {
        return lastErrCondtion;
    }

    public static String getLastErrMsg() {
        return lastErrMsg;
    }

    private static void setLastErrMsg(String lastErrMsg) {
        LicenseChecker.lastErrMsg = lastErrMsg;
    }

    public static String checkLicenseDirAclMsg() {
        IPath licenseDataPath;
        if (!(System.getProperty("DISABLE_LIC") != null || (licenseDataPath = LicUserUtils.getRuntimeLicenseLocation()) != null && licenseDataPath.toFile().canRead())) {
            String errmsg = NLS.bind((String)Messages.CAN_NOT_READ_LICENSE_FOLDER, (Object)licenseDataPath);
            return errmsg;
        }
        return null;
    }

    public static boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker("FLEX");
        return licenseChecker.configureRCLLogging(configFileLocation, logFileLocation, product, version, size, logLevel, traceLevel, maxFiles, enableLogging, enableTracing);
    }
}

