/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.ServiceWrapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;

public class P2ProvisioningAgentProvider {
    private final HashMap<File, P2ProvisioningAgent> provisioningAgents = new HashMap();
    private final HashSet<P2ProvisioningAgent> defaultProvisioningAgents = new HashSet();

    protected P2ProvisioningAgentProvider() {
    }

    public synchronized IProvisioningAgent getProvisioningAgent(File p2DataArea) throws CoreException {
        File cfile;
        try {
            cfile = p2DataArea.getCanonicalFile();
        }
        catch (IOException e) {
            cfile = p2DataArea;
        }
        P2ProvisioningAgent p2ProvisioningAgent = this.provisioningAgents.get(cfile);
        if (p2ProvisioningAgent != null) {
            p2ProvisioningAgent.addReference();
        } else {
            ServiceWrapper providerWrapper = CicP2Model.getDefault().getServiceWrapper(IProvisioningAgentProvider.SERVICE_NAME);
            try {
                IProvisioningAgentProvider provider = (IProvisioningAgentProvider)providerWrapper.acquireInstance();
                IStatus status = FileUtil.makeDirectories((File)cfile);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                URI uri = cfile.toURI();
                IProvisioningAgent provisioningAgent = provider.createAgent(uri);
                p2ProvisioningAgent = new P2ProvisioningAgent(cfile, provisioningAgent);
                this.provisioningAgents.put(cfile, p2ProvisioningAgent);
                if (FileUtil.filesAreSame((File)cfile, (File)this.getDefaultP2DataArea()) && this.defaultProvisioningAgents.add(p2ProvisioningAgent)) {
                    p2ProvisioningAgent.addReference();
                }
            }
            finally {
                providerWrapper.release();
            }
        }
        return p2ProvisioningAgent;
    }

    public IProvisioningAgent getDefaultProvisioningAgent() throws CoreException {
        IStatus appDataValidationStatus = CicCommonSettings.validateApplicationDataLocation();
        if (!appDataValidationStatus.isOK()) {
            Logger.getLogger(this.getClass()).status(appDataValidationStatus);
            return null;
        }
        File p2DataArea = this.getDefaultP2DataArea();
        return this.getProvisioningAgent(p2DataArea);
    }

    public void stop() {
        for (P2ProvisioningAgent p2ProvisioningAgent : this.defaultProvisioningAgents) {
            p2ProvisioningAgent.stop();
        }
        this.defaultProvisioningAgents.clear();
    }

    private File getDefaultP2DataArea() {
        return new File(CicCommonSettings.getApplicationDataLocation(), "p2");
    }

    private synchronized void removeProvisioningAgent(File p2DataArea) {
        this.provisioningAgents.remove(p2DataArea);
    }

    private class P2ProvisioningAgent
    implements IProvisioningAgent {
        private final File p2DataArea;
        private IProvisioningAgent provisioningAgent;
        private int refCount = 1;

        public P2ProvisioningAgent(File p2DataArea, IProvisioningAgent provisioningAgent) {
            assert (p2DataArea != null);
            this.p2DataArea = p2DataArea;
            assert (provisioningAgent != null);
            this.provisioningAgent = provisioningAgent;
        }

        public Object getService(String serviceName) {
            Object service = this.provisioningAgent.getService(serviceName);
            return service;
        }

        public void registerService(String serviceName, Object service) {
            this.provisioningAgent.registerService(serviceName, service);
        }

        public synchronized void stop() {
            if (this.refCount == 0) {
                throw new IllegalStateException("P2ProvisioningAgent already stopped");
            }
            --this.refCount;
            if (this.refCount == 0) {
                P2ProvisioningAgentProvider.this.removeProvisioningAgent(this.p2DataArea);
                try {
                    Thread.sleep(700L);
                }
                catch (InterruptedException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                this.provisioningAgent.stop();
                this.provisioningAgent = null;
            }
        }

        public void unregisterService(String serviceName, Object service) {
            this.provisioningAgent.unregisterService(serviceName, service);
        }

        public synchronized void addReference() {
            ++this.refCount;
        }
    }
}

