/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.IProblemCollector;
import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.ITagScanner;
import com.ibm.cic.common.xml.core.IXMLTagToken;
import com.ibm.cic.common.xml.core.TextProblem;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRule;

public abstract class BaseRule
implements ISchemaRule {
    protected void report(int severity, String message, IXMLTextModelItem item, IProblemCollector collector) {
        TextProblem problem = new TextProblem(severity, message, item.getTextSpan().getOffset(), item.getTextSpan().getLength(), item.getStartLineNumber());
        problem.setCategory(this.getCategory());
        collector.addProblem(problem);
    }

    protected void report(int severity, String message, int offset, int length, int line, IProblemCollector collector) {
        TextProblem problem = new TextProblem(severity, message, offset, length, line);
        problem.setCategory(this.getCategory());
        collector.addProblem(problem);
    }

    public void reportError(String msg, IXMLTextModelItem item, IProblemCollector collector) {
        this.report(2, msg, item, collector);
    }

    public void reportWarning(String msg, IXMLTextModelItem item, IProblemCollector collector) {
        this.report(1, msg, item, collector);
    }

    public void reportError(String msg, int offset, int length, int line, IProblemCollector collector) {
        this.report(2, msg, offset, length, line, collector);
    }

    public void reportWarning(String msg, int offset, int length, int line, IProblemCollector collector) {
        this.report(1, msg, offset, length, line, collector);
    }

    private void reportAttributeProblem(int severity, String msg, IXMLTextModelItem item, String attribute, String value, ISourceConverter converter) {
        if (converter == null) {
            this.reportError(msg, item, item);
            return;
        }
        String tagText = converter.getTextRange(item.getTextSpan().getOffset(), item.getTextSpan().getLength());
        int nameIdx = -1;
        int len = 0;
        if (tagText != null) {
            ITagScanner scanner = CicXMLCore.getDefault().getScanner(tagText);
            while (scanner.hasNextToken()) {
                IXMLTagToken token = scanner.nextToken();
                if (token.getType() != 2 || !attribute.equals(token.get())) continue;
                nameIdx = token.getOffset();
                len = token.getLength();
                if (!scanner.hasNextToken() || (token = scanner.nextToken()).getType() != 3) break;
                len = token.getOffset() - nameIdx + token.getLength();
                break;
            }
        }
        if (nameIdx < 0) {
            this.reportError(msg, item, item);
            return;
        }
        if (severity == 2) {
            this.reportError(msg, item.getTextSpan().getOffset() + nameIdx, len, item.getStartLineNumber(), item);
        } else if (severity == 1) {
            this.reportWarning(msg, item.getTextSpan().getOffset() + nameIdx, len, item.getStartLineNumber(), item);
        }
    }

    protected void reportAttributeWarning(String msg, IXMLTextModelItem item, String attribute, String value, ISourceConverter converter) {
        this.reportAttributeProblem(1, msg, item, attribute, value, converter);
    }

    protected void reportAttributeError(String msg, IXMLTextModelItem item, String attribute, String value, ISourceConverter converter) {
        this.reportAttributeProblem(2, msg, item, attribute, value, converter);
    }

    public abstract byte getCategory();
}

