/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema.rules;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.schema.ComplexType;
import com.ibm.cic.common.xml.core.internal.model.schema.Multiplicity;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.schema.BaseRule;
import com.ibm.cic.common.xml.core.model.schema.IAny;
import com.ibm.cic.common.xml.core.model.schema.IChoice;
import com.ibm.cic.common.xml.core.model.schema.IComplexType;
import com.ibm.cic.common.xml.core.model.schema.IContainerContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.IGroup;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISequence;
import com.ibm.cic.common.xml.core.model.schema.IXMLPath;
import java.util.ArrayList;
import java.util.Iterator;

public class ContainerRule
extends BaseRule {
    @Override
    public void check(ISchema schema, ISourceConverter converter, IXMLTextModelItem item) {
        IReferencable ref;
        IXMLPath schemaPath = CicXMLCore.getDefault().xmlItemToPath(item);
        IElementDefinition def = schema.findByPath(schemaPath);
        if (def != null && (ref = def.getElementType()) instanceof ComplexType) {
            ComplexType realDef = (ComplexType)ref;
            IXMLTextModelItem[] children = item.getChildren();
            this.checkComplexType(schema, item, children, realDef);
        }
    }

    protected void checkComplexType(ISchema schema, IXMLTextModelItem parent, IXMLTextModelItem[] children, IComplexType def) {
        IElementContainer[] containers;
        ArrayList<IXMLTextModelItem> toProcess = new ArrayList<IXMLTextModelItem>(children.length);
        IXMLTextModelItem[] iXMLTextModelItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n2];
            if (element.getNSPrefix() == null || element.getNSPrefix().equals(schema.getNamespace())) {
                toProcess.add(element);
            }
            ++n2;
        }
        IElementContainer[] iElementContainerArray = containers = def.containerList();
        int n3 = containers.length;
        n = 0;
        while (n < n3) {
            IElementContainer container = iElementContainerArray[n];
            ArrayList containerElems = this.addContainerItems(container, toProcess);
            this.checkContainerElements(schema, container, new Multiplicity(), containerElems, parent);
            ++n;
        }
        if (!toProcess.isEmpty() && !this.containsAny(containers)) {
            for (IXMLTextModelItem item : toProcess) {
                this.reportError(Messages.bind((String)Messages.ContainerRule_elementNotAllowed, (Object)item.getName(), (Object)parent.getName()), item, item);
            }
        }
    }

    protected void checkInstallContext(ISchema installContextSchema, ISchema adapterSchema, IXMLTextModelItem parent, IXMLTextModelItem[] children, IComplexType installContextDef, IComplexType adapterDef) {
        IElementContainer[] installContextContainers;
        IElementContainer[] adapterContainers;
        ArrayList<IXMLTextModelItem> toProcess = new ArrayList<IXMLTextModelItem>(children.length);
        IXMLTextModelItem[] iXMLTextModelItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n2];
            if (element.getNSPrefix() == null || element.getNSPrefix().equals(adapterSchema.getNamespace())) {
                toProcess.add(element);
            }
            ++n2;
        }
        ArrayList adapterContainerElems = null;
        IElementContainer[] iElementContainerArray = adapterContainers = adapterDef.containerList();
        int n3 = adapterContainers.length;
        int n4 = 0;
        while (n4 < n3) {
            IElementContainer adapterContainer = iElementContainerArray[n4];
            adapterContainerElems = this.addContainerItems(adapterContainer, toProcess, false);
            ++n4;
        }
        ArrayList installContextContainerElems = null;
        IElementContainer[] iElementContainerArray2 = installContextContainers = installContextDef.containerList();
        int n5 = installContextContainers.length;
        int n6 = 0;
        while (n6 < n5) {
            IElementContainer installContextContainer = iElementContainerArray2[n6];
            installContextContainerElems = this.addContainerItems(installContextContainer, toProcess, false);
            ++n6;
        }
        for (IXMLTextModelItem item : toProcess) {
            if (!adapterContainerElems.contains(item) || installContextContainerElems.contains(item)) continue;
            this.reportWarning(Messages.bind((String)Messages.ContainerRule_NoOpInInstallContext, (Object)item.getName()), item, item);
        }
    }

    protected ArrayList addContainerItems(IElementContainer container, ArrayList items) {
        return this.addContainerItems(container, items, true);
    }

    protected ArrayList addContainerItems(IElementContainer container, ArrayList items, boolean remove) {
        ArrayList<IXMLTextModelItem> ret = new ArrayList<IXMLTextModelItem>(2);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            IXMLTextModelItem i = (IXMLTextModelItem)iter.next();
            if (container.getElementByName(i.getName()) == null) continue;
            ret.add(i);
            if (!remove) continue;
            iter.remove();
        }
        return ret;
    }

    protected int checkContainerElements(ISchema schema, IElementContainer container, Multiplicity parentMulti, ArrayList items, IXMLTextModelItem parent) {
        if (container instanceof ISequence) {
            return this.checkSequence(schema, items, (ISequence)container, parentMulti, parent);
        }
        if (container instanceof IChoice) {
            return this.checkChoice(schema, items, (IChoice)container, parentMulti, parent);
        }
        if (container instanceof IGroup) {
            return this.checkGroup(schema, (IGroup)container, parentMulti, items, parent);
        }
        return 0;
    }

    protected int checkSequence(ISchema schema, ArrayList items, ISequence sequence, Multiplicity parentMulti, IXMLTextModelItem parent) {
        IElementDefinition[] defs;
        int n;
        int start = items.size();
        if (sequence instanceof IContainerContainer) {
            IElementContainer[] inner;
            IContainerContainer cc = (IContainerContainer)((Object)sequence);
            IElementContainer[] iElementContainerArray = inner = cc.containerList();
            int n2 = inner.length;
            n = 0;
            while (n < n2) {
                IElementContainer element = iElementContainerArray[n];
                ArrayList innerItems = this.addContainerItems(element, items);
                this.checkContainerElements(schema, element, sequence.getMultiplicity(), innerItems, parent);
                ++n;
            }
        }
        IElementDefinition[] iElementDefinitionArray = defs = sequence.getLocalElements();
        n = defs.length;
        int n3 = 0;
        while (n3 < n) {
            IElementDefinition def = iElementDefinitionArray[n3];
            int count = 0;
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                IXMLTextModelItem item = (IXMLTextModelItem)iter.next();
                if (!def.getName().equals(item.getName())) continue;
                iter.remove();
                ++count;
            }
            int val = def.getMultiplicity().check(count);
            if (val > 0) {
                this.reportError(Messages.bind((String)"The element {0} can only contain {1} {2} element(s).", (Object[])new Object[]{parent.getName(), def.getMultiplicity().getMax(), def.getName()}), parent, parent);
            } else if (val < 0) {
                this.reportError(Messages.bind((String)"The element {0} must contain at least {1} {2} element(s).", (Object[])new Object[]{parent.getName(), def.getMultiplicity().getMax(), def.getName()}), parent, parent);
            }
            ++n3;
        }
        return start - items.size();
    }

    protected int checkGroup(ISchema schema, IGroup group, Multiplicity parentMulti, ArrayList items, IXMLTextModelItem parent) {
        parentMulti.applyParent(group.getMultiplicity());
        if (group.isReference()) {
            String name = group.getTypeName();
            IReferencable ref = schema.getResolver().lookupType(name);
            if (ref instanceof IGroup) {
                group = (IGroup)ref;
            }
        }
        IElementContainer[] containers = group.containerList();
        int ret = 0;
        IElementContainer[] iElementContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IElementContainer container = iElementContainerArray[n2];
            ArrayList inner = this.addContainerItems(container, items);
            ret += this.checkContainerElements(schema, container, parentMulti, inner, parent);
            ++n2;
        }
        return ret;
    }

    protected int checkChoice(ISchema schema, ArrayList items, IChoice choice, Multiplicity parentMulti, IXMLTextModelItem parent) {
        IElementDefinition[] def = choice.getLocalElements();
        String found = null;
        int foundCount = 0;
        Multiplicity multi = new Multiplicity(parentMulti);
        IElementDefinition[] iElementDefinitionArray = def;
        int n = def.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDefinition element = iElementDefinitionArray[n2];
            Multiplicity appliedMulti = new Multiplicity(element.getMultiplicity());
            appliedMulti.applyParent(choice.getMultiplicity());
            appliedMulti.applyParent(parentMulti);
            Iterator iter = items.iterator();
            int curCount = 0;
            while (iter.hasNext()) {
                IXMLTextModelItem item = (IXMLTextModelItem)iter.next();
                if (!element.getName().equals(item.getName())) continue;
                iter.remove();
                ++foundCount;
                ++curCount;
                if (found == null) {
                    found = element.getName();
                }
                if (!found.equals(item.getName()) && !appliedMulti.isUnbounded() && foundCount > appliedMulti.getMax()) {
                    this.reportError(Messages.bind((String)Messages.ContainerRule_noCoExist, (Object[])new Object[]{item.getName(), found, parent.getName()}), item, item);
                }
                if (appliedMulti.isUnbounded() || curCount <= appliedMulti.getMax()) continue;
                this.reportError(Messages.bind((String)Messages.ContainerRule_multiplicityErr, (Object[])new Object[]{item.getName(), appliedMulti.getMax(), parent.getName()}), item, item);
            }
            ++n2;
        }
        IElementContainer[] containers = choice.containerList();
        Multiplicity choiceMulti = new Multiplicity(choice.getMultiplicity());
        choiceMulti.applyParent(multi);
        choiceMulti.setMin(Math.max(choiceMulti.getMin() - foundCount, 0));
        IElementContainer[] iElementContainerArray = containers;
        int n3 = containers.length;
        int n4 = 0;
        while (n4 < n3) {
            IElementContainer container = iElementContainerArray[n4];
            ArrayList inner = this.addContainerItems(container, items);
            foundCount += this.checkContainerElements(schema, container, choiceMulti, inner, parent);
            ++n4;
        }
        if (choiceMulti.getMin() > foundCount) {
            this.reportError(Messages.bind((String)Messages.ContainerRule_multiplicityUnderErr, (Object[])new Object[]{parent.getName(), multi.getMin(), this.makeCSV(choice.getElements())}), parent, parent);
        }
        return foundCount;
    }

    protected String makeCSV(IElementDefinition[] defs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < defs.length) {
            buf.append(defs[i].getName());
            if (i < defs.length - 1) {
                buf.append(',');
            }
            ++i;
        }
        return buf.toString();
    }

    protected boolean containsAny(IElementContainer[] containers) {
        IElementContainer[] iElementContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainerContainer cc;
            IElementContainer container = iElementContainerArray[n2];
            if (container instanceof IAny) {
                return true;
            }
            if (container instanceof IContainerContainer && this.containsAny((cc = (IContainerContainer)((Object)container)).containerList())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

