/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.schema.Any;
import com.ibm.cic.common.xml.core.internal.model.schema.AttributeDefinition;
import com.ibm.cic.common.xml.core.internal.model.schema.Choice;
import com.ibm.cic.common.xml.core.internal.model.schema.ComplexType;
import com.ibm.cic.common.xml.core.internal.model.schema.ElementDefinition;
import com.ibm.cic.common.xml.core.internal.model.schema.Group;
import com.ibm.cic.common.xml.core.internal.model.schema.IValueRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.LengthRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.MaxLengthRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.MinLengthRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.PatternRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.Sequence;
import com.ibm.cic.common.xml.core.internal.model.schema.SimpleContent;
import com.ibm.cic.common.xml.core.internal.model.schema.SimpleType;
import com.ibm.cic.common.xml.core.internal.model.schema.XMLUtility;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SchemaFactory {
    public static IAttributeDefinition createAttribute(Element attributeNode, ISchema schema) {
        NodeList types;
        NamedNodeMap attrs = attributeNode.getAttributes();
        String type = XMLUtility.getAttribute(attrs, "type");
        String use = XMLUtility.getAttribute(attrs, "use");
        String defVal = XMLUtility.getAttribute(attrs, "default");
        AttributeDefinition def = new AttributeDefinition(attributeNode, schema);
        if (type != null) {
            def.setAttributeType(type);
        }
        if (use != null) {
            if ("required".equals(use)) {
                def.setRequired(true);
            } else if ("prohibited".equals(use)) {
                def.setProhibited(true);
            }
        }
        if (defVal != null) {
            def.setDefault(defVal);
        }
        if ((types = attributeNode.getElementsByTagName("simpleType")).getLength() == 1) {
            Element simple = (Element)types.item(0);
            SimpleType t = SchemaFactory.createSimpleType(simple, schema);
            def.setType(t);
        } else if (types.getLength() > 1) {
            CicXMLCore.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.cic.common.xml.core", 0, Messages.bind((String)Messages.intErr_multiple_attribute_types, (Object)def.getName()), null));
        }
        return def;
    }

    public static IReferencable createType(Element domElement, ISchema schema) {
        String name = domElement.getNodeName();
        if ("element".equals(name)) {
            return SchemaFactory.createElement(domElement, schema);
        }
        if ("complexType".equals(name)) {
            return SchemaFactory.createComplexType(domElement, schema);
        }
        if ("simpleType".equals(name)) {
            return SchemaFactory.createSimpleType(domElement, schema);
        }
        if ("group".equals(name)) {
            return SchemaFactory.createGroup(domElement, schema);
        }
        if ("sequence".equals(name)) {
            return SchemaFactory.createSequence(domElement, schema);
        }
        if ("choice".equals(name)) {
            return SchemaFactory.createChoice(domElement, schema);
        }
        if ("attribute".equals(name)) {
            return SchemaFactory.createAttribute(domElement, schema);
        }
        if ("simpleContent".equals(name)) {
            return SchemaFactory.createSimpleContent(domElement, schema);
        }
        if ("any".equals(name)) {
            return SchemaFactory.createAny(domElement, schema);
        }
        return null;
    }

    public static Any createAny(Element domElement, ISchema schema) {
        return new Any(domElement, schema);
    }

    public static Choice createChoice(Element domElement, ISchema schema) {
        return new Choice(domElement, schema);
    }

    public static Sequence createSequence(Element domElement, ISchema schema) {
        return new Sequence(domElement, schema);
    }

    public static Group createGroup(Element domElement, ISchema schema) {
        return new Group(domElement, schema);
    }

    public static SimpleType createSimpleType(Element domElement, ISchema schema) {
        return new SimpleType(domElement, schema);
    }

    public static IElementDefinition createElement(Element domElement, ISchema schema) {
        return new ElementDefinition(domElement, schema);
    }

    public static ComplexType createComplexType(Element domElement, ISchema schema) {
        return new ComplexType(domElement, schema);
    }

    public static SimpleContent createSimpleContent(Element domElement, ISchema schema) {
        return new SimpleContent(domElement, schema);
    }

    public static IValueRefinement createRefinement(Element domElement) {
        if (domElement == null) {
            return null;
        }
        if (domElement.getNodeName().equals("minLength")) {
            return new MinLengthRefinement(domElement);
        }
        if (domElement.getNodeName().equals("maxLength")) {
            return new MaxLengthRefinement(domElement);
        }
        if (domElement.getNodeName().equals("length")) {
            return new LengthRefinement(domElement);
        }
        if (domElement.getNodeName().equals("pattern")) {
            return new PatternRefinement(domElement);
        }
        return null;
    }
}

