/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.ITagScanner;
import com.ibm.cic.common.xml.core.IXMLProcessor;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.ext.ReferenceSchemaExtensions;
import com.ibm.cic.common.xml.core.internal.gen.DocSkeleton;
import com.ibm.cic.common.xml.core.internal.gen.XMLGenerator;
import com.ibm.cic.common.xml.core.internal.model.ProcInstruction;
import com.ibm.cic.common.xml.core.internal.model.XMLElement;
import com.ibm.cic.common.xml.core.internal.model.XMLModel;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaResolver;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaRuleVisitor;
import com.ibm.cic.common.xml.core.internal.model.schema.rules.ContainerRule;
import com.ibm.cic.common.xml.core.internal.model.schema.rules.SchemaAttributeRules;
import com.ibm.cic.common.xml.core.internal.parser.XMLProcessor;
import com.ibm.cic.common.xml.core.internal.parser.XMLTagScanner;
import com.ibm.cic.common.xml.core.internal.template.TemplateEngine;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.gen.IElementGenerator;
import com.ibm.cic.common.xml.core.model.gen.IGeneratorValueProvider;
import com.ibm.cic.common.xml.core.model.gen.ISkeleton;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRuleVisitor;
import com.ibm.cic.common.xml.core.model.schema.IXMLPath;
import com.ibm.cic.common.xml.core.model.schema.XMLPathFactory;
import com.ibm.cic.common.xml.core.serial.IXMLSerializer;
import com.ibm.cic.common.xml.core.serial.internal.XMLModelSerializer;
import com.ibm.cic.common.xml.core.template.ITemplate;
import com.ibm.cic.common.xml.core.template.ITemplateEngine;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CicXMLCore
extends Plugin {
    private static final String PARSER_FACTORY = "javax.xml.parsers.SAXParserFactory";
    private BundleContext fContext;
    private ServiceTracker fXMLTracker;
    private SAXParserFactory fFactory;
    public static final String PLUGIN_ID = "com.ibm.cic.common.xml.core";
    private static CicXMLCore plugin;
    private ReferenceSchemaExtensions fRefSchemas;

    public CicXMLCore() {
        plugin = this;
    }

    private void initXMLServices() {
        if (this.fXMLTracker == null) {
            this.fXMLTracker = new ServiceTracker(this.fContext, PARSER_FACTORY, null);
            this.fXMLTracker.open();
        }
        if (this.fFactory == null) {
            this.fFactory = (SAXParserFactory)this.fXMLTracker.getService();
        }
    }

    private void releaseXMLServices() {
        if (this.fXMLTracker != null) {
            this.fXMLTracker.close();
        }
        this.fFactory = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fContext = context;
        this.initXMLServices();
        this.fRefSchemas = new ReferenceSchemaExtensions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.releaseXMLServices();
        super.stop(context);
    }

    public static CicXMLCore getDefault() {
        return plugin;
    }

    public IXMLProcessor getXMLProcessor() {
        if (this.fFactory == null) {
            this.initXMLServices();
        }
        return new XMLProcessor(this.fContext, this.fFactory);
    }

    public ISchema readSchema(InputStream stream) {
        try {
            DocumentBuilderFactory _factory = XMLUtil.createDocumentBuilderFactory();
            DocumentBuilder _builder = _factory.newDocumentBuilder();
            Document doc = _builder.parse(stream);
            SchemaResolver _resolver = new SchemaResolver();
            _resolver.resolve(doc);
            return _resolver.getSchema();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IElementGenerator getElementGenerator() {
        return new XMLGenerator();
    }

    public IXMLPath xmlItemToPath(IXMLTextModelItem item) {
        IXMLPath ret;
        IXMLPath last = ret = XMLPathFactory.newPath(item.getName());
        while (item.getParent() != null) {
            item = item.getParent();
            IXMLPath seg = XMLPathFactory.newPath(item.getName());
            last.setParent(seg);
            seg.setChild(last);
            last = seg;
        }
        return ret;
    }

    public ISchemaRuleVisitor getSchemaRuleVisitor(ISchema schema, ISourceConverter converter) {
        SchemaRuleVisitor ret = new SchemaRuleVisitor(schema, converter);
        ret.addSchemaRule(new SchemaAttributeRules());
        ret.addSchemaRule(new ContainerRule());
        return ret;
    }

    public ISchemaRuleVisitor getEmptyRuleVisitor(ISchema schema, ISourceConverter converter) {
        return new SchemaRuleVisitor(schema, converter);
    }

    public ISkeleton newDocumentSkeleton(IElementDefinition rootElement, IGeneratorValueProvider valueProvider) {
        DocSkeleton ret = new DocSkeleton();
        ret.setRoot(rootElement, valueProvider);
        return ret;
    }

    public IProcessingInstruction createProcessionInstruction(String target, String data) {
        ProcInstruction ret = new ProcInstruction();
        ret.setTarget(target);
        ret.setData(data);
        return ret;
    }

    public IXMLTextModelItem createItem(String name) {
        return new XMLElement(name);
    }

    public ITagScanner getScanner(String tagText) {
        return new XMLTagScanner(tagText);
    }

    public IXMLSerializer getSerializer(boolean format, boolean useTabs) {
        XMLModelSerializer ser = new XMLModelSerializer();
        ser.setTabs(useTabs);
        ser.doFormatting(format);
        return ser;
    }

    public IXMLModel newDocument() {
        return new XMLModel();
    }

    public String getHash(IXMLTextModelItem item) {
        XMLModelSerializer ser = new XMLModelSerializer();
        ser.setNoWhiteSpace(true);
        ser.setNoComments(true);
        if (item != null) {
            String text = ser.serializeElement(item);
            int code = text.hashCode();
            return String.valueOf(code);
        }
        return null;
    }

    public void logException(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, e.getLocalizedMessage(), e));
    }

    public ISchema getReferenceSchema(String namespaceURL) {
        return this.fRefSchemas.getReferenceSchema(namespaceURL);
    }

    public ITemplateEngine getTemplateEngine() {
        return new TemplateEngine();
    }

    public ITemplate loadTemplate(ITemplateEngine engine, String name, InputStream in) throws CoreException {
        try {
            ITemplate t;
            ITemplate iTemplate = t = engine.getTemplate(in, name);
            return iTemplate;
        }
        catch (Exception e) {
            String msg = this.getErrorLoadingTemplateMessage(name);
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
        }
        finally {
            FileUtil.close((Closeable)in);
        }
    }

    public String getErrorLoadingTemplateMessage(String name) {
        return NLS.bind((String)Messages.CicXMLCore_errTemplateLoad, (Object)name);
    }
}

