/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtRollBack;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtRollBackVersionSelector;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.OutputFormatter;
import org.eclipse.core.runtime.IStatus;

public class ConPageRollBackPkgs
extends AConPage {
    ConDataCtxtRollBackVersionSelector m_context;
    Profile selectedProfile;
    ConViewStatus m_statusView = new ConViewStatus();
    ConViewTreeList m_mainList;

    public ConPageRollBackPkgs(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageRollBack_Pkg_Header);
        ConViewProperties groupName = new ConViewProperties(){

            public void present(OutputFormatter a_output) {
                this.clear();
                this.addProperty(Messages.PageRollBack_Pkg_PgGroup, ConPageRollBackPkgs.this.selectedProfile.getProfileId());
                super.present(a_output);
            }
        };
        groupName.setFormatString("%s:  %s");
        this.addView((IConView)groupName);
        this.m_mainList = new ConViewTreeList(Messages.PageRollBack_Pkg_PgName, 1, true, true);
        RollBackContentProvider contProvider = new RollBackContentProvider();
        this.m_mainList.setContentProvider((IConViewContentProvider)contProvider);
        this.addView((IConView)this.m_mainList);
        this.addView((IConView)this.m_statusView);
        super.init();
    }

    public boolean isPageComplete() {
        return this.m_context.getSelectedRollbackJobs().containsJobs() && this.m_statusView.getStatus().isOK();
    }

    public boolean skipPage() {
        ConDataCtxtRollBack ctxt = (ConDataCtxtRollBack)this.conManager().getDataContext(ConDataCtxtRollBack.class);
        return ctxt.getSingleSelectedProfile() == null;
    }

    public void setVisible(boolean a_visible) {
        ConDataCtxtRollBack ctxt;
        Profile newlySelectedProfile;
        if (a_visible && this.selectedProfile != (newlySelectedProfile = (ctxt = (ConDataCtxtRollBack)this.conManager().getDataContext(ConDataCtxtRollBack.class)).getSingleSelectedProfile())) {
            this.selectedProfile = newlySelectedProfile;
            this.m_context = (ConDataCtxtRollBackVersionSelector)this.conManager().getDataContext(ConDataCtxtRollBackVersionSelector.class);
            this.m_context.unselectAllRollbackJobs();
            IStatus status = this.m_context.prepareInstalledOfferingsInSelectedProfiles();
            if (status.isOK()) {
                status = this.m_context.checkRollbackStatusOfSelectedProfile(this.selectedProfile);
            }
            this.m_statusView.setStatus(status);
            this.m_mainList.refresh();
        }
        super.setVisible(a_visible);
    }

    protected boolean hasNext() {
        return this.isPageComplete();
    }

    class ConActRollBackPkgsSelect
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActRollBackPkgsSelect() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            ConPageRollBackPkgs.this.m_statusView.setStatus(ConPageRollBackPkgs.this.m_context.flipRollbackVersionSelection((RollbackJob)entry.getElement()));
            super.run(a_conManager);
        }
    }

    class RollBackContentProvider
    extends AConViewContentProvider {
        RollBackContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof IOfferingOrFix) {
                return RollBackContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((IOfferingOrFix)element));
            }
            if (element instanceof RollbackJob) {
                return RollBackContentProvider.getLabelOfferingOrFixVersions((IOfferingOrFix)((RollbackJob)element).getOfferingOrFix());
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IOffering) {
                Object[] return_value = ConPageRollBackPkgs.this.m_context.getAvailableOfferingJobs((IOffering)parentElement);
                return return_value;
            }
            return null;
        }

        public Object[] getElements() {
            return ConPageRollBackPkgs.this.m_context.getOfferingsToRollback();
        }

        public void updateEntry(ConViewTreeListEntry entry) {
            Object element = entry.getElement();
            if (element instanceof RollbackJob) {
                RollbackJob uoj = (RollbackJob)element;
                if (ConPageRollBackPkgs.this.m_context.isRollbackVersionSelected(uoj)) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            }
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof RollbackJob) {
                return new ConActRollBackPkgsSelect();
            }
            return super.getAction(element);
        }
    }
}

