/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.console.ConCommandKeys;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.pages.ConPageInstSelectVersions;
import com.ibm.cic.agent.internal.console.pages.ConPageWizInstall;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionAddPage;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;

public class ConPageInstSelect
extends AConPage {
    ConDataCtxtInst context;
    ConViewStatus m_statusView = new ConViewStatus();
    boolean m_hasSelected = false;

    public ConPageInstSelect(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageInstall_Edit_Header);
        this.context = (ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        InstallJob job = this.context.getProcessedJob();
        IOfferingOrFix oof = job.getOfferingOrFix();
        ConViewText selectedPackage = new ConViewText(AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)oof), true);
        selectedPackage.setTrailingNewLineNr(2);
        this.addView((IConView)selectedPackage);
        this.m_statusView.setStatus(this.context.getJobStatus(job));
        ConViewListNumbered mainList = new ConViewListNumbered(Messages.General_Options);
        String Ver = AConViewContentProvider.getLabelOfferingOrFixVersionsA((IOfferingOrFix)oof);
        if (!StatusUtil.isErrorOrCancel((IStatus)this.m_statusView.getStatus()) && !ConPageInstSelect.isAgentWizardMode(job)) {
            if (this.context.isProcessedJobSelected()) {
                mainList.addEntry(NLS.bind((String)Messages.PageInstall_Edit_Unselect, (Object)Ver), (AConActionEntry)new ConActOnOffPackage()).setContext((Object)this.context.getProcessedJob());
            } else {
                mainList.addEntry(NLS.bind((String)Messages.PageInstall_Edit_Select, (Object)Ver), (AConActionEntry)new ConActOnOffPackage()).setContext((Object)this.context.getProcessedJob());
            }
        }
        mainList.addEntry(Messages.PageInstall_Edit_OtherVersions, (AConActionEntry)new ConActionAddPage(){

            protected AConPage createNewPage(IConManager a_manager) {
                return new ConPageInstSelectVersions(a_manager);
            }
        });
        this.addView((IConView)mainList);
        this.addView((IConView)this.m_statusView);
        ConViewList otherOptions = new ConViewList(null, false);
        otherOptions.addEntry(Messages.General_Cancel, ConCommandKeys.keys_Cancel, (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        this.addView((IConView)otherOptions);
        this.setSuggestedInput("1");
        super.present(a_output);
    }

    public boolean isPageComplete() {
        return this.m_hasSelected;
    }

    private static boolean isAgentWizardMode(InstallJob job) {
        return Agent.getInstance().isAgentOffering((IOfferingOrFix)job.getOffering()) && AgentInput.getInstance().getMode() == 1;
    }

    public void setVisible(boolean a_visible) {
        if (a_visible && this.context.isProcessedJobSelected()) {
            ConPageWizInstall wizard = (ConPageWizInstall)this.conManager().getWizardPage();
            wizard.checkJobsToleranceForAgent((AbstractJob)this.context.getProcessedJob());
        }
    }

    class ConActOnOffPackage
    extends ConActionReturnToPreviousPage {
        ConActOnOffPackage() {
        }

        public void run(IConManager a_conManager) {
            ConPageInstSelect.this.context.flipInstallJobSelection();
            super.run(a_conManager);
        }
    }
}

