/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;

public class ConPageCompletion
extends AConPage {
    IStatus m_result;
    String m_okMessage;
    String m_errorMessage;
    String m_rebootRequestLabel;
    ConViewList rebootOption;

    public ConPageCompletion(IConManager controller, IStatus a_installResult, String a_okMessage, String a_errorMessage, String rebootRequestLabel) {
        super(controller);
        this.m_result = a_installResult;
        this.m_okMessage = a_okMessage;
        this.m_errorMessage = a_errorMessage;
        this.m_rebootRequestLabel = rebootRequestLabel;
    }

    public void init() {
        this.setHeaderView(Messages.General_CompletionPage_Header);
        ConViewStatus statusView = this.generateStatusView();
        this.addView((IConView)statusView);
        if (StatusUtil.isCancel((IStatus)this.m_result)) {
            this.conManager().setIOStatus(this.m_result);
        } else {
            this.rebootOption = this.generateRebootOption();
            if (this.rebootOption != null) {
                this.addView((IConView)this.rebootOption);
            }
            ConViewList optionsView = new ConViewList(this.rebootOption == null ? Messages.General_Options : Messages.General_OtherOptions, false);
            this.populateOptionsView(optionsView);
            if (!this.isSuggestedInputSet()) {
                this.setSuggestedInput("F");
            }
            this.addView((IConView)optionsView);
        }
    }

    protected ConViewStatus generateStatusView() {
        String statusHeader = this.m_result.isOK() || this.m_result.matches(1) ? this.m_okMessage : this.m_errorMessage;
        ConViewStatus statusView = new ConViewStatus(statusHeader, true, this.m_result, 15);
        return statusView;
    }

    protected void populateOptionsView(ConViewList optionsView) {
        if (StatusUtil.isError((IStatus)this.m_result)) {
            optionsView.addEntry(com.ibm.cic.common.core.console.Messages.WizardPage_Back, ConCommonCommandKeys.keys_Back, (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
            this.setSuggestedInput(ConCommonCommandKeys.keys_Back[0]);
        }
        if (AgentInput.getInstance().getMode() == 1) {
            optionsView.addEntry(Messages.General_CompletionPage_Finish, "F", (AConActionEntry)new ConActionRebootBeforeExit());
        } else {
            optionsView.addEntry(Messages.General_CompletionPage_Finish, "F", (AConActionEntry)new ConActionRebootBeforeReturnToWelcomePage());
        }
    }

    protected ConViewList generateRebootOption() {
        if (RebootRequest.isSet()) {
            return new ConPlatformCreateRebootView().getPolicy().createRebootView();
        }
        return null;
    }

    static class ConActFlipReboot
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipReboot() {
        }

        public void run(IConManager a_conManager) {
            if (RebootRequest.shouldRebootNow()) {
                RebootRequest.setRebootLater();
            } else {
                RebootRequest.setRebootNow();
            }
            super.run(a_conManager);
        }
    }

    class ConActionRebootBeforeExit
    extends ConActionExit {
        ConActionRebootBeforeExit() {
        }

        public void run(IConManager a_conManager) {
            if (ConPageCompletion.this.rebootOption != null && RebootRequest.shouldRebootNow()) {
                PlatformUtils.reboot();
            } else if (RebootRequest.isSet()) {
                RebootRequest.setRebootLater();
            }
            super.run(a_conManager);
        }
    }

    class ConActionRebootBeforeReturnToWelcomePage
    extends ConActionReturnToPreviousPage {
        public ConActionRebootBeforeReturnToWelcomePage() {
            super(1);
        }

        public void run(IConManager a_conManager) {
            if (ConPageCompletion.this.rebootOption != null && RebootRequest.shouldRebootNow()) {
                PlatformUtils.reboot();
            } else if (RebootRequest.isSet()) {
                RebootRequest.setRebootLater();
            }
            super.run(a_conManager);
        }
    }

    class ConPlatformCreateRebootView
    extends AbstractPlatformPolicyFactory {
        ConPlatformCreateRebootView() {
        }

        protected Object createWindowsPolicy() {
            return new PPWindows();
        }

        protected Object createLinuxPolicy() {
            return new PPCommon(this){};
        }

        PPCommon getPolicy() {
            return (PPCommon)this.getPlatformPolicy();
        }

        abstract class PPCommon {
            PPCommon() {
            }

            protected ConViewList createRebootView() {
                return null;
            }
        }

        class PPWindows
        extends PPCommon {
            PPWindows() {
            }

            @Override
            protected ConViewList createRebootView() {
                ConViewList rebootOptions = new ConViewList(((ConPlatformCreateRebootView)ConPlatformCreateRebootView.this).ConPageCompletion.this.m_rebootRequestLabel, true, true, 0){

                    public void present(OutputFormatter a_output) {
                        this.clearList();
                        this.addEntry(Messages.ConPageCompletion_RebootNow, "N", new ConActFlipReboot()).setSelected(RebootRequest.shouldRebootNow());
                        this.addEntry(Messages.ConPageCompletion_RebootLater, "L", new ConActFlipReboot()).setSelected(!RebootRequest.shouldRebootNow());
                        super.present(a_output);
                    }
                };
                return rebootOptions;
            }
        }
    }
}

