/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import java.util.ArrayList;
import java.util.List;

public class JobListManager<T extends AgentJob> {
    private List<T> m_selectedOfferingJobs = new ArrayList<T>();
    private final List<T> m_selectedFixJobs = new ArrayList<T>();
    private final List<T> m_offeringModificationList = new ArrayList<T>();
    private final List<T> m_fixModificationList = new ArrayList<T>();

    public boolean containsJobs() {
        return !this.m_selectedOfferingJobs.isEmpty() || !this.m_selectedFixJobs.isEmpty();
    }

    public boolean containOfferingJobs() {
        return !this.m_selectedOfferingJobs.isEmpty();
    }

    public boolean containFixJobs() {
        return !this.m_selectedFixJobs.isEmpty();
    }

    public boolean addJob(T a_job) {
        boolean return_value = true;
        if (this.m_selectedOfferingJobs.contains(a_job) || this.m_selectedFixJobs.contains(a_job)) {
            return_value = false;
        } else {
            IOffering offering = a_job.getOffering();
            a_job.setSelected(true);
            return_value = offering != null ? this.m_selectedOfferingJobs.add(a_job) : this.m_selectedFixJobs.add(a_job);
            if (return_value) {
                this.registerJobElement(a_job);
            }
        }
        return return_value;
    }

    public boolean removeJob(T a_job) {
        boolean return_value = true;
        a_job.setSelected(false);
        IOffering offering = a_job.getOffering();
        return_value = offering != null ? this.m_selectedOfferingJobs.remove(a_job) : this.m_selectedFixJobs.remove(a_job);
        if (return_value) {
            this.registerJobElement(a_job);
        }
        return return_value;
    }

    public void removeAllJobs() {
        this.removeAllOfferingJobs();
        this.removeAllFixJobs();
    }

    public void removeAllOfferingJobs() {
        for (AgentJob job : this.m_selectedOfferingJobs) {
            job.setSelected(false);
            this.registerJobElement(job);
        }
        this.m_selectedOfferingJobs.clear();
    }

    public void removeAllFixJobs() {
        for (AgentJob job : this.m_selectedFixJobs) {
            job.setSelected(false);
            this.registerJobElement(job);
        }
        this.m_selectedFixJobs.clear();
    }

    private void registerJobElement(T a_job) {
        IOffering offering = a_job.getOffering();
        if (offering != null) {
            this.registerOfferingJobElement(a_job);
        } else {
            this.registerFixJobElement(a_job);
        }
    }

    private void registerOfferingJobElement(T a_job) {
        if (this.m_offeringModificationList.contains(a_job)) {
            this.m_offeringModificationList.remove(a_job);
        } else {
            this.m_offeringModificationList.add(a_job);
        }
    }

    private void registerFixJobElement(T a_job) {
        if (this.m_fixModificationList.contains(a_job)) {
            this.m_fixModificationList.remove(a_job);
        } else {
            this.m_fixModificationList.add(a_job);
        }
    }

    public void resetChanged() {
        this.resetOfferingChanged();
        this.resetFixChanged();
    }

    public void resetOfferingChanged() {
        this.m_offeringModificationList.clear();
    }

    public void resetFixChanged() {
        this.m_fixModificationList.clear();
    }

    public boolean isChanged() {
        return this.isOfferingChanged() || this.isFixChanged();
    }

    public boolean isOfferingChanged() {
        return !this.m_offeringModificationList.isEmpty();
    }

    public boolean isFixChanged() {
        return !this.m_fixModificationList.isEmpty();
    }

    public void sortByNameAndVersion() {
        this.sortByNameAndVersion(true);
    }

    public void sortByNameAndVersion(boolean ascendVersion) {
        if (this.m_selectedOfferingJobs.size() > 1) {
            this.m_selectedOfferingJobs = new ArrayList<T>(SortUtil.sortByProfileNameAndVersion(this.m_selectedOfferingJobs, (boolean)ascendVersion));
        }
    }

    public AgentJob[] toArray() {
        ArrayList<AgentJob> return_result = new ArrayList<AgentJob>(this.m_selectedOfferingJobs);
        return_result.addAll(this.m_selectedFixJobs);
        return return_result.toArray(new AgentJob[return_result.size()]);
    }

    public List<T> toList() {
        ArrayList<T> return_result = new ArrayList<T>(this.m_selectedOfferingJobs);
        return_result.addAll(this.m_selectedFixJobs);
        return return_result;
    }

    public List<IOffering> getSelectedProductOfferings() {
        ArrayList<IOffering> return_result = new ArrayList<IOffering>();
        for (AgentJob job : this.m_selectedOfferingJobs) {
            IOffering offering = job.getOffering();
            if (Agent.getInstance().isAgentOffering((IOfferingOrFix)offering) || LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            return_result.add(offering);
        }
        return return_result;
    }

    public T getSelectedAgentJob() {
        for (AgentJob job : this.m_selectedOfferingJobs) {
            IOffering offering = job.getOffering();
            if (!Agent.getInstance().isAgentOffering((IOfferingOrFix)offering)) continue;
            return (T)job;
        }
        return null;
    }

    public List<T> getSelectedOfferingJobs() {
        return this.getSelectedOfferingJobs(null);
    }

    public List<T> getSelectedFixJobs() {
        return this.getSelectedFixJobs(null);
    }

    public List<T> getSelectedOfferingJobs(Profile a_profile) {
        if (a_profile == null) {
            return this.m_selectedOfferingJobs;
        }
        ArrayList<AgentJob> return_result = new ArrayList<AgentJob>();
        for (AgentJob job : this.m_selectedOfferingJobs) {
            Profile profile = job.getProfile();
            if (!a_profile.equals(profile)) continue;
            return_result.add(job);
        }
        return return_result;
    }

    public List<T> getSelectedFixJobs(Profile a_profile) {
        if (a_profile == null) {
            return this.m_selectedFixJobs;
        }
        ArrayList<AgentJob> return_result = new ArrayList<AgentJob>();
        for (AgentJob job : this.m_selectedFixJobs) {
            Profile profile = job.getProfile();
            if (!a_profile.equals(profile)) continue;
            return_result.add(job);
        }
        return return_result;
    }

    public boolean contains(T a_job) {
        return this.m_selectedOfferingJobs.contains(a_job) || this.m_selectedFixJobs.contains(a_job);
    }

    public void clear() {
        this.m_selectedOfferingJobs.clear();
        this.m_selectedFixJobs.clear();
        this.resetChanged();
    }

    public AgentJob[] toArray(Profile a_parentProfile) {
        ArrayList<AgentJob> return_value;
        ArrayList<Object> arrayList = return_value = a_parentProfile != null ? new ArrayList<AgentJob>(this.m_selectedOfferingJobs.size() + this.m_selectedFixJobs.size()) : new ArrayList(0);
        if (a_parentProfile != null) {
            for (AgentJob job : this.m_selectedOfferingJobs) {
                if (!a_parentProfile.equals(job.getProfile())) continue;
                return_value.add(job);
            }
            for (AgentJob job : this.m_selectedFixJobs) {
                if (!a_parentProfile.equals(job.getProfile())) continue;
                return_value.add(job);
            }
        }
        return return_value.toArray(new AgentJob[return_value.size()]);
    }
}

