/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtForProfiles;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtRollBack;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.agent.internal.console.manager.InstalledPackagesForProfile;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtRollBackVersionSelector
extends ConDataCtxtForProfiles {
    private final IOffering[] NO_OFFERINGS = new IOffering[0];
    private static final Logger log = Logger.getLogger(ConDataCtxtRollBackVersionSelector.class);
    private final ConDataCtxtRollBack m_mainRollbackContext;
    private InstalledPackagesForProfile m_installed;
    private final Map<String, Map<IOffering, List<RollbackJob>>> m_availableRollbacks = new HashMap<String, Map<IOffering, List<RollbackJob>>>();

    public ConDataCtxtRollBackVersionSelector(ConDataCtxtRollBack a_mainContext) {
        this.m_mainRollbackContext = a_mainContext;
    }

    public IStatus prepareInstalledOfferingsInSelectedProfiles() {
        Set<Profile> selectedProfiles = this.m_mainRollbackContext.getSelectedProfiles().toSet();
        try {
            this.m_installed = new InstalledPackagesForProfile(selectedProfiles, AgentJob.AgentJobType.ROLLBACK_JOB);
        }
        catch (CoreException e) {
            this.m_availableRollbacks.clear();
            return e.getStatus();
        }
        this.loadRollbacks();
        return Status.OK_STATUS;
    }

    private void loadRollbacks() {
        List<Profile> selectedProfiles = this.m_mainRollbackContext.getSelectedProfiles().toList();
        if (!selectedProfiles.isEmpty()) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.ConDataCtxtRollbackVersionSelector_SearchRollback, -1);
                for (Profile profile : selectedProfiles) {
                    List<IOffering> installedOfferings = this.m_installed.getInstalledOfferings((IProfile)profile);
                    Map<IOffering, List<RollbackJob>> availableRollbackMap = this.m_availableRollbacks.get(profile.getProfileId());
                    if (availableRollbackMap != null) continue;
                    availableRollbackMap = new HashMap<IOffering, List<RollbackJob>>();
                    if (!installedOfferings.isEmpty()) {
                        for (IOffering offering : installedOfferings) {
                            List<RollbackJob> rollbackJobList = new ArrayList();
                            IOffering[] previouslyInstalledOfferings = Agent.getInstance().getInstalledOfferings(profile, offering.getIdentity());
                            if (previouslyInstalledOfferings != null && previouslyInstalledOfferings.length > 1) {
                                IOffering[] iOfferingArray = previouslyInstalledOfferings;
                                int n = previouslyInstalledOfferings.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IOffering installedOffering = iOfferingArray[n2];
                                    if (!offering.getVersion().equals((Object)installedOffering.getVersion()) && Agent.getInstance().isRollbackAllowed(profile, installedOffering) && !OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)installedOffering) && !OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)installedOffering)) {
                                        RollbackJob job = new RollbackJob(profile, (IOfferingOrFix)installedOffering);
                                        job.setRollbackFromOffering(offering);
                                        rollbackJobList.add(job);
                                    }
                                    ++n2;
                                }
                            }
                            rollbackJobList = SortUtil.sortByNameAndVersion(rollbackJobList, (boolean)false);
                            availableRollbackMap.put(offering, rollbackJobList);
                        }
                    }
                    this.m_availableRollbacks.put(profile.getProfileId(), availableRollbackMap);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private IStatus validateSelectedRollbacks() {
        IStatus return_result = Status.OK_STATUS;
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.InstalledOfferingPage_validatePkgProgress, -1);
            return_result = ConUtils.checkOfferingSupportConsoleMode(this.getSelectedRollbackJobs().toList());
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                return_result = ConUtils.performPreCheck(this.getSelectedRollbackJobs().toList());
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result) && !StatusUtil.isErrorOrCancel((IStatus)(return_result = AgentUtil.getOfferingsApplicability(this.getSelectedRollbackJobs().toList(), (AgentJob[])this.getSelectedRollbackJobs().toArray())))) {
                return_result = Agent.getInstance().checkInstall(this.getSelectedRollbackJobs().toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            }
        }
        finally {
            monitor.done();
        }
        return return_result;
    }

    public IStatus selectRollbackJob(RollbackJob rollbackJob, boolean validate) {
        IStatus return_value = Status.OK_STATUS;
        this.unselectSimilarRollbackJob(rollbackJob);
        if (this.getSelectedRollbackJobs().addJob(rollbackJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.General_ConDataCtxt_PrepareAndResolve, -1);
                ArrayList<RollbackJob> jobsToPrepare = new ArrayList<RollbackJob>();
                jobsToPrepare.add(rollbackJob);
                IStatus status = SharedUIUtils.prepareAndResolveSelectedJobs(jobsToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
            }
            finally {
                monitor.done();
            }
            this.getSelectedRollbackJobs().sortByNameAndVersion(false);
            if (validate) {
                return_value = this.validateSelectedRollbacks();
            }
        }
        return return_value;
    }

    private void unselectRollbackJob(RollbackJob rollbackJob) {
        if (this.getSelectedRollbackJobs().removeJob(rollbackJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                IOfferingOrFix oof = rollbackJob.getOfferingOrFix();
                ConDataCtxtUtils.unloadBundlesForOfferingOrFix(oof, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    public IStatus flipRollbackVersionSelection(RollbackJob RollbackJob2) {
        if (this.isRollbackVersionSelected(RollbackJob2)) {
            this.unselectRollbackJob(RollbackJob2);
            return this.validateSelectedRollbacks();
        }
        return this.selectRollbackJob(RollbackJob2, true);
    }

    private void unselectSimilarRollbackJob(RollbackJob RollbackJob2) {
        for (RollbackJob job : this.getSelectedRollbackJobs().toList()) {
            if (!job.getOfferingOrFix().getIdentity().equals(RollbackJob2.getOfferingOrFix().getIdentity())) continue;
            this.unselectRollbackJob(job);
            break;
        }
    }

    public void unselectAllRollbackJobs() {
        Iterator<RollbackJob> iterator = this.getSelectedRollbackJobs().toList().iterator();
        if (iterator.hasNext()) {
            RollbackJob job = iterator.next();
            this.unselectRollbackJob(job);
        }
    }

    public boolean isRollbackVersionSelected(RollbackJob RollbackJob2) {
        return this.getSelectedRollbackJobs().contains(RollbackJob2);
    }

    public Map<String, Map<IOffering, List<RollbackJob>>> getRollbackTreeContent() {
        return this.m_availableRollbacks;
    }

    public IOffering[] getOfferingsToRollback() {
        Profile profile = this.m_mainRollbackContext.getSingleSelectedProfile();
        if (profile != null) {
            return this.getOfferingsToRollback(profile);
        }
        return this.NO_OFFERINGS;
    }

    public IOffering[] getOfferingsToRollback(Profile a_profile) {
        Map<IOffering, List<RollbackJob>> map = this.m_availableRollbacks.get(a_profile.getProfileId());
        if (map == null) {
            return this.NO_OFFERINGS;
        }
        return map.keySet().toArray(new IOffering[map.keySet().size()]);
    }

    public IStatus checkRollbackStatusOfAllProfile() {
        IStatus return_value = Status.OK_STATUS;
        List<Profile> profiles = this.m_mainRollbackContext.getSelectedProfiles().toList();
        for (Profile p : profiles) {
            IStatus stat = this.checkRollbackStatusOfSelectedProfile(p);
            if (stat.getSeverity() <= return_value.getSeverity()) continue;
            return_value = stat;
        }
        return return_value;
    }

    public IStatus checkRollbackStatusOfSelectedProfile(Profile a_profile) {
        String profileId = a_profile.getProfileId();
        Map<IOffering, List<RollbackJob>> map = this.m_availableRollbacks.get(profileId);
        if (map == null) {
            return Statuses.ERROR.get(462, Messages.PageRollBack_NoPkgToRollBack, new Object[0]);
        }
        Collection<List<RollbackJob>> jobsLists = map.values();
        for (List<RollbackJob> list : jobsLists) {
            if (list.isEmpty()) continue;
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(463, com.ibm.cic.agent.core.sharedUI.Messages.RollbackWizard_AvailableRollbackPage_NoRollback_Msg, new Object[0]);
    }

    public RollbackJob[] getAvailableOfferingJobs(IOffering offeringToRollback) {
        Profile profile = this.m_mainRollbackContext.getSingleSelectedProfile();
        List<RollbackJob> availableJobList = this.m_availableRollbacks.get(profile.getProfileId()).get(offeringToRollback);
        return availableJobList.toArray(new RollbackJob[availableJobList.size()]);
    }

    public JobListManager<RollbackJob> getSelectedRollbackJobs() {
        return this.m_mainRollbackContext.getSelectedJobs();
    }
}

