/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanels;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtFeatures;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtLocaleLangs;
import com.ibm.cic.agent.internal.console.manager.ConManager;
import com.ibm.cic.agent.internal.console.manager.InstalledPackagesForProfile;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtModify
extends AConDataAgentWizard {
    IConManager m_manager;
    private final Profile[] m_allProfiles;
    private Profile m_selectedProfile;
    private Profile m_previousSelectedProfile = null;
    private boolean m_profileChanged = false;
    private InstalledPackagesForProfile m_installed;
    private final JobListManager<ModifyJob> m_selectedJobs = new JobListManager();
    private final List<ModifyJob> m_toInstallAgentJobs = new LinkedList<ModifyJob>();
    private final List<ModifyJob> m_toUninstallAgentJobs = new LinkedList<ModifyJob>();
    private final Map<Profile, String> previousLocaleLangsMap = new HashMap<Profile, String>();
    ConDataCtxtLocaleLangs m_langsContext = null;
    ConDataCtxtFeatures m_featuresContext = null;
    ConDataCtxtCustomPanels m_customPanelsContext = null;
    ConDataCtxtCustomPanelList m_modifyCustomPanelListCtxt = null;

    public ConDataCtxtModify(IConManager a_manager) {
        this.m_manager = a_manager;
        Agent agent = Agent.getInstance();
        agent.getRepositoryGroupStatus(true, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        this.m_allProfiles = agent.getSortedProductProfiles(false);
        if (this.m_allProfiles.length == 1) {
            this.m_selectedProfile = this.m_allProfiles[0];
        }
    }

    public <T extends IConDataCtxt> T getAdapter(Class<T> cls) {
        if (cls == ConDataCtxtLocaleLangs.class) {
            if (this.m_langsContext == null || this.m_profileChanged) {
                this.clear();
                if (this.m_profileChanged) {
                    this.m_profileChanged = false;
                }
                this.m_langsContext = new ConDataCtxtLocaleLangs(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_langsContext);
        }
        if (cls == ConDataCtxtFeatures.class) {
            if (this.m_featuresContext == null) {
                this.m_featuresContext = new ConDataCtxtFeatures(this.getSelectedJobs());
            }
            return (T)((Object)this.m_featuresContext);
        }
        if (cls == ConDataCtxtCustomPanelList.class) {
            if (this.m_modifyCustomPanelListCtxt == null) {
                this.m_modifyCustomPanelListCtxt = new ConDataCtxtCustomPanelList(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_modifyCustomPanelListCtxt);
        }
        if (cls == ConDataCtxtCustomPanels.class) {
            if (this.m_customPanelsContext == null) {
                this.m_customPanelsContext = new ConDataCtxtCustomPanels(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_customPanelsContext);
        }
        return (T)super.getAdapter(cls);
    }

    public Profile[] getAllProductProfiles() {
        return this.m_allProfiles;
    }

    public Profile getSelectedProfile() {
        return this.m_selectedProfile;
    }

    private void clear() {
        this.m_langsContext = null;
        this.m_featuresContext = null;
        this.m_modifyCustomPanelListCtxt = null;
        this.m_customPanelsContext = null;
        this.m_selectedJobs.resetChanged();
    }

    public boolean isAnyProfileSelected() {
        return this.m_selectedProfile != null;
    }

    public boolean isProfileSelected(Profile p) {
        return this.m_selectedProfile == p;
    }

    public IStatus performNext() {
        HashSet<Profile> profileSet = new HashSet<Profile>();
        profileSet.add(this.m_selectedProfile);
        try {
            this.m_installed = new InstalledPackagesForProfile(profileSet, AgentJob.AgentJobType.MODIFY_JOB, true);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (this.m_selectedProfile != this.m_previousSelectedProfile) {
            this.m_profileChanged = true;
            this.m_previousSelectedProfile = this.m_selectedProfile;
        } else {
            this.m_profileChanged = false;
        }
        if (this.m_profileChanged) {
            this.generateModifyJobs();
        }
        IStatus preCheckStatus = ConUtils.performPreCheck(this.m_selectedJobs.toList());
        return preCheckStatus;
    }

    private void generateModifyJobs() {
        this.m_selectedJobs.clear();
        List<IOfferingOrFix> installedOfferingOrFix = this.m_installed.getInstalledOOF((IProfile)this.m_selectedProfile);
        if (installedOfferingOrFix != null) {
            for (IOfferingOrFix offeringOrFix : installedOfferingOrFix) {
                ModifyJob job = new ModifyJob(this.m_selectedProfile, offeringOrFix);
                this.m_selectedJobs.addJob(job);
            }
        }
        this.m_selectedJobs.sortByNameAndVersion();
    }

    public void translateModifyJobsToInstallUninstallJobs() {
        this.restoreLocaleLangs();
        this.saveLocaleLangs();
        this.m_toInstallAgentJobs.clear();
        this.m_toUninstallAgentJobs.clear();
        for (ModifyJob job : this.m_selectedJobs.toList()) {
            if (job.getOffering() == null) continue;
            LinkedList featuresToAdd = new LinkedList();
            LinkedList featuresToRemove = new LinkedList();
            job.determineFeaturesToAddRemove((IAgent)Agent.getInstance(), featuresToAdd, featuresToRemove);
            Set originalLocales = ProfileLanguageUtils.convertCodeStringToSet((String)job.getProfile().getData("cic.selector.nl"));
            HashSet<String> newLocaleSet_1 = new HashSet<String>(this.m_langsContext.getSelectedLangs());
            HashSet<String> newLocaleSet_2 = new HashSet<String>(newLocaleSet_1);
            newLocaleSet_1.removeAll(originalLocales);
            boolean localeLangAdded = !newLocaleSet_1.isEmpty();
            originalLocales.removeAll(newLocaleSet_2);
            boolean localeLangRemoved = !originalLocales.isEmpty();
            this.addJobsToList(job, featuresToAdd, this.m_toInstallAgentJobs, localeLangAdded);
            this.addJobsToList(job, featuresToRemove, this.m_toUninstallAgentJobs, localeLangRemoved);
            if (!OfferingProperty.isModifyForceEnabled((IOffering)job.getOffering()) || !this.m_toInstallAgentJobs.isEmpty() || !this.m_toUninstallAgentJobs.isEmpty()) continue;
            this.addEmptyJobToList(job, this.m_toInstallAgentJobs);
        }
    }

    public IFeature[] getVisibleFeaturesToInstall(AgentJob a_job) {
        for (ModifyJob job : this.m_toInstallAgentJobs) {
            if (job.getOffering() != a_job.getOffering()) continue;
            return this.getVisibleFeatures(this.m_featuresContext.getAllVisibleFeatures(a_job), job.getFeatures());
        }
        return new IFeature[0];
    }

    public IFeature[] getVisibleFeaturesToUninstall(AgentJob a_job) {
        for (ModifyJob job : this.m_toUninstallAgentJobs) {
            if (job.getOffering() != a_job.getOffering()) continue;
            return this.getVisibleFeatures(this.m_featuresContext.getAllVisibleFeatures(a_job), job.getFeatures());
        }
        return new IFeature[0];
    }

    protected IFeature[] getVisibleFeatures(List<IFeature> a_visibleFeatures, Collection<IFeature> a_testedFeatures) {
        ArrayList<IFeature> return_value = new ArrayList<IFeature>();
        if (a_visibleFeatures != null) {
            for (IFeature feature : a_testedFeatures) {
                if (!a_visibleFeatures.contains(feature)) continue;
                return_value.add(feature);
            }
        }
        return return_value.toArray(new IFeature[return_value.size()]);
    }

    private void addJobsToList(ModifyJob job, List features, List newJobs, boolean localeLangChanged) {
        if (features.size() > 0 || localeLangChanged) {
            Profile profile = job.getProfile();
            if (localeLangChanged) {
                profile.setData("cic.selector.nl", ProfileLanguageUtils.convertCodeSetToString(this.m_langsContext.getSelectedLangs()));
            }
            ModifyJob newJob = new ModifyJob(profile, (IOfferingOrFix)job.getOffering());
            newJob.setFeatures((Collection)features);
            newJob.setSelected(job.isSelected());
            newJobs.add(newJob);
        }
    }

    private void addEmptyJobToList(ModifyJob job, List newJobs) {
        ModifyJob newJob = new ModifyJob(job.getProfile(), (IOfferingOrFix)job.getOffering(), AgentJob.AgentJobType.INSTALL_JOB);
        newJob.setFeatureIds("-");
        newJob.setSelected(job.isSelected());
        newJobs.add(newJob);
    }

    public CommandRecorder getCommandRecorder() {
        List<ModifyJob> jobs = this.getSelectedJobs().toList();
        for (ModifyJob j : jobs) {
            j.setSelected(true);
        }
        CommandRecorder commandRecorder = new CommandRecorder();
        commandRecorder.recordJobs((AgentJob[])this.m_toInstallAgentJobs.toArray(new ModifyJob[this.m_toInstallAgentJobs.size()]), true);
        commandRecorder.recordJobs((AgentJob[])this.m_toUninstallAgentJobs.toArray(new ModifyJob[this.m_toUninstallAgentJobs.size()]), false);
        return commandRecorder;
    }

    public IStatus modifySelectedPackages() {
        IStatus status;
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        if (this.m_toInstallAgentJobs.size() == 0 && this.m_toUninstallAgentJobs.size() == 0 && !(status = Agent.getInstance().checkForModifyWithMissingInstallLocation(this.m_selectedJobs.toArray())).isOK()) {
            return status;
        }
        IStatus return_value = ((ConManager)this.m_manager).getConsoleApp().run(this.getCommandRecorder().getRecordedCommand(), CmdLine.CL.getParam1StrVal("-record"));
        if (!StatusUtil.isErrorOrCancel((IStatus)return_value)) {
            this.clearLocaleLangs();
        }
        return return_value;
    }

    @Override
    public void dispose() {
        this.restoreLocaleLangs();
        super.dispose();
    }

    public JobListManager<ModifyJob> getSelectedJobs() {
        return this.m_selectedJobs;
    }

    public void flipProfileSelection(Profile a_profile) {
        this.m_selectedProfile = this.m_selectedProfile != a_profile ? a_profile : null;
    }

    private void saveLocaleLangs() {
        for (ModifyJob job : this.m_selectedJobs.toList()) {
            Profile profile = job.getProfile();
            if (this.previousLocaleLangsMap.containsKey(profile)) continue;
            String value = profile.getData("cic.selector.nl");
            this.previousLocaleLangsMap.put(profile, value);
        }
    }

    private void restoreLocaleLangs() {
        for (Map.Entry<Profile, String> entry : this.previousLocaleLangsMap.entrySet()) {
            Profile profile = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                profile.setData("cic.selector.nl", value);
                continue;
            }
            profile.removeData("cic.selector.nl");
        }
        this.clearLocaleLangs();
    }

    private void clearLocaleLangs() {
        this.previousLocaleLangsMap.clear();
    }
}

