/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console;

import com.ibm.cic.agent.core.sharedUI.AgentReopenRepositoryUtil;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtOpenRepository;
import com.ibm.cic.agent.internal.console.pages.ConPageOpenRepository;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.console.manager.AConManager;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConAgentReopenRepositoryPrompter
implements IReopenRepositoryPrompter {
    private static final Logger log = Logger.getLogger(ConAgentReopenRepositoryPrompter.class);
    private static IConIO m_overrideConIO;
    private final String application;

    public ConAgentReopenRepositoryPrompter(String application) {
        this.application = application;
    }

    @Deprecated
    public static void setOverrideConIO(IConIO a_overrideConIO) {
        m_overrideConIO = a_overrideConIO;
    }

    public IReopenRepositoryPrompter.ReopenRepositoryResult promptOpenRepository(IRepositoryGroup group, IOfferingOrFix offeringOrFix, IRepositoryInfo repoInfo, IArtifactSession session, IArtifact artifact, boolean wantAbort) {
        PrivateConManager conManager = new PrivateConManager(this.application);
        AgentReopenRepositoryUtil.RepositoryOpener opener = new AgentReopenRepositoryUtil.RepositoryOpener(group, offeringOrFix, session, artifact, repoInfo){

            public IStatus openAndValidateRepository(String location, IProgressMonitor monitor) {
                IStatus status = super.openAndValidateRepository(location, monitor);
                if (CommonSharedUIUtils.isRepositoryStatusMessage((IStatus)status)) {
                    return Status.OK_STATUS;
                }
                return status;
            }
        };
        ConDataCtxtOpenRepository c = new ConDataCtxtOpenRepository(this.application, opener);
        conManager.setDataContext(c);
        IStatus consoleStatus = conManager.run();
        log.statusNotOK(consoleStatus);
        return new IReopenRepositoryPrompter.ReopenRepositoryResult(c.getResultStatus(), group, opener.getOpenedRepository());
    }

    private static class PrivateConManager
    extends AConManager {
        public PrivateConManager(String application) {
            super(m_overrideConIO, application);
        }

        protected AConPage getWelcomePage() {
            return new ConPageOpenRepository((IConManager)this);
        }
    }
}

