/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.wizardry;

import com.ibm.cic.common.ui.internal.parts.IContextMenuFiller;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.SkippableContainerWizardPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractCicWizardPage
extends SkippableContainerWizardPage {
    protected FormToolkit toolkit;
    protected Map variedFonts = null;
    private static final String TITLEBAR = "titlebar";
    private static final String TOOLBAR = "toolbar";
    protected static final String TOOLBAR_KEY = "TOOLBAR";
    protected static final String SECTION_KEY = "SECTION";
    protected static final int SECTION_STYLE = 512;

    public AbstractCicWizardPage(String id, FormToolkit toolkit, String description) {
        this(id, toolkit, null, description);
    }

    public AbstractCicWizardPage(String id, FormToolkit toolkit, String title, String description) {
        super(id, title, null);
        this.setDescription(description);
        this.toolkit = toolkit;
    }

    public void dispose() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && control.getBackgroundImage() != null && !control.getBackgroundImage().isDisposed()) {
            control.getBackgroundImage().dispose();
            control.setBackgroundImage(null);
        }
        if (this.variedFonts != null) {
            for (Font font : this.variedFonts.values()) {
                if (font.isDisposed()) continue;
                font.dispose();
            }
            this.variedFonts = null;
        }
        super.dispose();
    }

    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public void validatePage() throws ValidationFailed {
    }

    public void nextPage() {
    }

    public void previousPage() {
    }

    public abstract void createControl(Composite var1);

    protected abstract void setFocus();

    protected Composite createTop(Composite parent, GridLayout layout) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)this.createFillData());
        top.setBackgroundMode(1);
        return top;
    }

    protected final Label createLabelAndLabel(Composite parent, String text) {
        Label l = new Label(parent, 0);
        l.setText(text);
        l = new Label(parent, 64);
        l.setLayoutData((Object)this.createHorizontalFillData(0));
        return l;
    }

    protected final Text createLabelAndReadonlyText(Composite parent, String text) {
        return this.createLabelAndReadonlyText(parent, text, 1);
    }

    protected final Text createLabelAndReadonlyText(Composite parent, String text, int numTextLines) {
        Text t = this.createLabelAndText(parent, text, numTextLines, 8);
        this.toolkit.adapt((Control)t, false, false);
        return t;
    }

    protected Text createLabelAndText(Composite parent, String label, int numTextLines) {
        return this.createLabelAndText(parent, label, numTextLines, 2048);
    }

    private Text createLabelAndText(Composite parent, String label, int numTextLines, int style) {
        boolean multiline = numTextLines > 1;
        int valign = multiline ? 128 : 0x1000000;
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        lbl.setLayoutData((Object)new GridData(0, valign, false, false));
        Text text = new Text(parent, style |= multiline ? 514 : 0);
        text.setLayoutData((Object)new GridData(4, valign, true, false));
        if (multiline) {
            GC gc = new GC((Drawable)text);
            Point textSize = gc.stringExtent(" ");
            gc.dispose();
            GridData gd = (GridData)text.getLayoutData();
            gd.heightHint = textSize.y * numTextLines + 2;
        }
        return text;
    }

    public GridData createHorizontalFillData(int valign) {
        return new GridData(4, valign, true, false);
    }

    public GridData createFillData() {
        return new GridData(4, 4, true, true);
    }

    protected Composite createScrolledSectionAndClient(Composite parent, String title, Layout clientLayout, GridData clientData, ISectionFiller sectionFiller) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.toolkit.adapt((Composite)sc);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayout((Layout)this.createGridLayout(1, 0, 0, 0, 0, 0, 0));
        sc.setLayoutData((Object)this.createFillData());
        Composite sectionClient = this.createSectionAndClient((Composite)sc, title, clientLayout, clientData);
        Composite section = sectionClient.getParent();
        sectionFiller.fill(sectionClient);
        sc.setContent((Control)section);
        Point computedSize = section.computeSize(-1, -1, true);
        sc.setMinSize(computedSize);
        return sectionClient;
    }

    private Composite createSectionAndClient(Composite parent, String title, Layout clientLayout, GridData clientData) {
        Composite section = new Composite(parent, 0);
        section.setLayout((Layout)this.createGridLayout(1, 0, 0, 10, 0, 10, 0));
        section.setLayoutData((Object)this.createFillData());
        Composite sectionTitleBar = new Composite(section, 0);
        sectionTitleBar.setLayout((Layout)this.createGridLayout(2, 0, 0, 0, 10, 0, 0));
        sectionTitleBar.setLayoutData((Object)this.createHorizontalFillData(0x1000000));
        Label sectionTitle = new Label(sectionTitleBar, 0);
        sectionTitle.setFont(this.getBoldFont((Control)parent));
        sectionTitle.setText(title);
        sectionTitle.setLayoutData((Object)this.createHorizontalFillData(0x1000000));
        Composite sectionClient = new Composite(section, 0);
        sectionClient.setLayout(clientLayout);
        sectionClient.setLayoutData((Object)clientData);
        sectionClient.setData(TITLEBAR, (Object)sectionTitleBar);
        return sectionClient;
    }

    protected ToolItem createToolItemInSectionTitleBar(Composite sectionClient, int style) {
        ToolBar sectionTitleToolBar = this.getSectionTitleToolBar(sectionClient);
        ToolItem button = new ToolItem(sectionTitleToolBar, style);
        return button;
    }

    protected ToolBar getSectionTitleToolBar(Composite sectionClient) {
        ToolBar sectionTitleToolBar = (ToolBar)sectionClient.getData(TOOLBAR);
        if (sectionTitleToolBar == null) {
            Composite sectionTitleBar = (Composite)sectionClient.getData(TITLEBAR);
            sectionTitleToolBar = new ToolBar(sectionTitleBar, 0x800000);
            sectionClient.setData(TOOLBAR, (Object)sectionTitleToolBar);
        }
        return sectionTitleToolBar;
    }

    protected Font getBoldFont(Control c) {
        return this.getVariedFont(c, 1);
    }

    protected Font getItalicFont(Control c) {
        return this.getVariedFont(c, 2);
    }

    private Font getVariedFont(Control c, int variation) {
        Font b;
        if (this.variedFonts == null) {
            this.variedFonts = new HashMap();
        }
        if ((b = (Font)this.variedFonts.get(c)) == null) {
            FontData[] fontDatas;
            Font n = c.getFont();
            FontData[] fontDataArray = fontDatas = n.getFontData();
            int n2 = fontDatas.length;
            int n3 = 0;
            while (n3 < n2) {
                FontData fontData = fontDataArray[n3];
                fontData.setStyle(fontData.getStyle() | variation);
                ++n3;
            }
            b = new Font((Device)DisplayKeeper.INSTANCE.getDisplay(), fontDatas);
            this.variedFonts.put(c, b);
        }
        return b;
    }

    protected GridLayout createGridLayout(int cols, int mw, int mh, int ml, int mr, int mt, int mb) {
        GridLayout layout = new GridLayout(cols, false);
        layout.marginWidth = mw;
        layout.marginHeight = mh;
        layout.marginLeft = ml;
        layout.marginRight = mr;
        layout.marginTop = mt;
        layout.marginBottom = mb;
        return layout;
    }

    protected static void setupContextMenu(Control control, final IContextMenuFiller menuFiller) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                menuFiller.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected ScrolledComposite createCushionedSection(Composite parent, String title) {
        Composite c = this.toolkit.createComposite(parent);
        c.setLayout((Layout)this.createGridLayout(1, 5, 0, 0, 0, 5, 0));
        c.setLayoutData((Object)new GridData(1808));
        Section s = this.toolkit.createSection(c, 512);
        s.setText(title);
        s.setLayoutData((Object)new GridData(1808));
        s.clientVerticalSpacing = 4;
        s.marginWidth = 5;
        s.marginHeight = 5;
        ToolBar toolBar = new ToolBar((Composite)s, 0x800000);
        this.toolkit.adapt((Control)toolBar, true, true);
        s.setTextClient((Control)toolBar);
        ScrolledComposite client = new ScrolledComposite((Composite)s, 768);
        this.toolkit.adapt((Composite)client);
        client.setAlwaysShowScrollBars(false);
        client.setExpandHorizontal(true);
        client.setExpandVertical(true);
        client.setLayout((Layout)this.createGridLayout(1, 0, 0, 10, 0, 0, 0));
        client.setLayoutData((Object)new GridData(1808));
        s.setClient((Control)client);
        client.setData(TOOLBAR_KEY, (Object)toolBar);
        client.setData(SECTION_KEY, (Object)s);
        return client;
    }

    protected ScrolledComposite createResizableScrolledComposite(SashForm top) {
        ScrolledComposite sc = new ScrolledComposite((Composite)top, 768);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayoutData((Object)this.createFillData());
        sc.setLayout((Layout)this.createGridLayout(1, 0, 0, 0, 0, 0, 0));
        this.toolkit.adapt((Composite)sc);
        return sc;
    }

    protected SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 66048);
        sashForm.setLayoutData((Object)this.createFillData());
        sashForm.setLayout((Layout)new GridLayout());
        this.toolkit.adapt((Composite)sashForm);
        return sashForm;
    }

    protected Point calcMinSize(Control[] controls) {
        Point size = new Point(0, 0);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Point s = c.computeSize(-1, -1, true);
            if (s.x > size.x) {
                size.x = s.x;
            }
            size.y += s.y;
            ++n2;
        }
        return size;
    }

    protected Section createLaidOutSection(Composite parent, String title) {
        Composite cushion = this.toolkit.createComposite(parent);
        cushion.setLayout((Layout)this.createGridLayout(1, 5, 0, 0, 0, 5, 0));
        cushion.setLayoutData((Object)new GridData(1808));
        Section section = this.toolkit.createSection(cushion, 512);
        section.setText(title);
        section.setLayoutData((Object)new GridData(1808));
        section.clientVerticalSpacing = 4;
        section.marginWidth = 5;
        section.marginHeight = 5;
        ToolBar toolBar = new ToolBar((Composite)section, 0x800000);
        this.toolkit.adapt((Control)toolBar, true, true);
        section.setTextClient((Control)toolBar);
        return section;
    }

    protected void addRightClickMenu(Composite tree) {
        MenuManager popupMenuManager = new MenuManager();
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractCicWizardPage.this.fillRightClickMenu(manager);
            }
        });
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    protected void fillRightClickMenu(IMenuManager manager) {
    }

    protected void addActionGroup(IMenuManager manager, IAction[] actions) {
        int num = manager.getItems().length;
        if (num > 0 && !(manager.getItems()[num - 1] instanceof Separator)) {
            manager.add((IContributionItem)new Separator());
        }
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            this.addIfEnabled(manager, action);
            ++n2;
        }
    }

    private void addIfEnabled(IMenuManager manager, IAction action) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    public boolean canFlipToPreviousPage() {
        return this.getPreviousPage() != null;
    }

    public boolean hasInternalNavigation() {
        return false;
    }

    protected static interface ISectionFiller {
        public void fill(Composite var1);
    }

    public static class ValidationFailed
    extends Exception {
        public ValidationFailed() {
        }

        public ValidationFailed(String msg) {
            super(msg);
        }
    }
}

