/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.views;

import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractCicView
extends ViewPart
implements ISelectionProvider {
    private FormToolkit toolkit;
    private final Map imageCaches = new HashMap();

    public void dispose() {
        if (this.getToolkit() != null) {
            this.getToolkit().dispose();
        }
        for (Object element : this.imageCaches.values()) {
            Image[] cache = (Image[])element;
            if (cache[0] == null) continue;
            cache[0].dispose();
            cache[0] = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(CicCommonUiPlugin.getDefault().getFormColors());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
    }

    public Shell getShell() {
        IViewSite viewSite = this.getViewSite();
        return viewSite != null ? viewSite.getShell() : null;
    }

    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    public void fireDirtyChanged() {
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractCicView.this.firePropertyChange(257);
            }
        });
    }

    protected void adapt(Composite c) {
        Control[] children;
        c.setBackground(this.getToolkit().getColors().getBackground());
        c.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.adapt((Composite)control);
            }
            ++n2;
        }
    }

    protected Image getBackgroundImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image[] cache = (Image[])this.imageCaches.get(descriptor);
        if (cache == null) {
            cache = new Image[1];
            this.imageCaches.put(descriptor, cache);
        }
        if (cache[0] == null) {
            cache[0] = CommonImages.createBackgroundImage(descriptor);
        }
        return cache[0];
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

