/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.parts;

import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ViewTitlePart {
    private Composite titleArea;
    private Label titleTextLabel;
    private Link messageTextLabel;
    private Label messageImageLabel;
    private Label titleImageLabel;
    private IStatus errorOrCancelStatus;
    private IStatus warningStatus;

    public ViewTitlePart(Composite parent, FormToolkit toolkit, int style) {
        this.titleArea = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.titleArea.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        this.titleArea.setLayoutData((Object)gd);
        Composite messageGunk = new Composite(this.titleArea, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 32;
        layout.marginTop = 16;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        messageGunk.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, true);
        messageGunk.setLayoutData((Object)gd);
        final Composite titleTextArea = new Composite(messageGunk, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        titleTextArea.setLayout((Layout)layout);
        titleTextArea.setLayoutData((Object)new GridData(4, 1, true, false));
        this.titleTextLabel = new Label(titleTextArea, 0);
        gd = new GridData(4, 0, true, false, 2, 1);
        this.titleTextLabel.setLayoutData((Object)gd);
        this.titleTextLabel.setFont(JFaceResources.getHeaderFont());
        this.messageImageLabel = new Label(titleTextArea, 0);
        gd = new GridData(1, 1, false, false);
        this.messageImageLabel.setLayoutData((Object)gd);
        this.messageTextLabel = new Link(titleTextArea, 64);
        this.messageTextLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.messageTextLabel.setFont(JFaceResources.getDialogFont());
        this.messageTextLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewTitlePart.this.errorOrCancelStatus == null && ViewTitlePart.this.warningStatus == null) {
                    return;
                }
                IStatus messageStatus = ViewTitlePart.this.errorOrCancelStatus;
                if (messageStatus == null) {
                    messageStatus = ViewTitlePart.this.warningStatus;
                }
                WrapDetailUIDErrorDialog w = new WrapDetailUIDErrorDialog(titleTextArea.getShell(), CommonUIUtils.getDialogTitleBasedOnStatus(messageStatus), null, messageStatus, 15, true);
                w.open();
            }
        });
        this.titleImageLabel = new Label(this.titleArea, 0);
        this.titleImageLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.titleArea.setBackgroundMode(1);
    }

    public void setErrorMessageStatus(IStatus msgStatus) {
        this.errorOrCancelStatus = msgStatus;
    }

    public void setWarningMessageStatus(IStatus status) {
        this.warningStatus = status;
    }

    public void setBackgroundImage(Image image) {
        this.titleArea.setBackgroundImage(image);
    }

    public void setTitle(String title) {
        this.changeLabelText(this.titleTextLabel, title);
    }

    public void setTitleImage(Image image) {
        this.changeLabelImage(this.titleImageLabel, image);
    }

    public void setMessageText(String message) {
        Composite parent;
        if (this.changeLabelText(this.messageTextLabel, message) && (parent = this.titleArea.getParent()) != null) {
            parent.layout(new Control[]{this.messageTextLabel});
        }
        if (Platform.getOS().equals("macosx")) {
            this.messageTextLabel.update();
        }
    }

    public void setMessageImage(int messageKind) {
        Image image = null;
        if (messageKind == 1) {
            image = JFaceResources.getImage((String)"dialog_messasge_info_image");
        } else if (messageKind == 2) {
            image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        } else if (messageKind == 3) {
            image = JFaceResources.getImage((String)"dialog_message_error_image");
        }
        this.changeLabelImage(this.messageImageLabel, image);
        this.messageImageLabel.getParent().getParent().layout();
    }

    private boolean changeLabelText(Label label, String text) {
        if (!text.equals(label.getText())) {
            label.setText(text);
            return true;
        }
        return false;
    }

    private boolean changeLabelText(Link label, String text) {
        if (!text.equals(label.getText())) {
            label.setText(text);
            return true;
        }
        return false;
    }

    private void changeLabelImage(Label label, Image image) {
        label.setImage(image);
    }

    public void setLinkSelectionListener(SelectionListener selectionListener) {
        if (this.messageTextLabel != null) {
            this.messageTextLabel.addSelectionListener(selectionListener);
        }
    }
}

