/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.model;

import com.ibm.cic.common.ui.internal.model.IPropertyChangeListener;
import com.ibm.cic.common.ui.internal.model.ITreeNode;
import com.ibm.cic.common.ui.internal.model.Property;
import com.ibm.cic.common.ui.internal.model.Workarounds;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.commands.common.EventManager;

public class TreeNode
extends EventManager
implements ITreeNode {
    private Object model;
    private final ITreeNode parent;
    private Vector children;
    private Map properties;

    public TreeNode(Object content, ITreeNode parent) {
        this.model = content;
        this.parent = parent;
    }

    @Override
    public Object getObject() {
        return this.model;
    }

    protected void updateObject(Object newObject) {
        this.model = newObject;
    }

    @Override
    public boolean isSameObject(ITreeNode other) {
        return this.getObject().equals(other.getObject());
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public ITreeNode getGreatGrampa() {
        ITreeNode p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    @Override
    public boolean isAncestor(ITreeNode ancestorCandidate) {
        Object qParent = ancestorCandidate.getObject();
        ITreeNode ancestor = this.getParent();
        while (ancestor != null && !Workarounds.objectsEqual(qParent, ancestor.getObject())) {
            ancestor = ancestor.getParent();
        }
        return ancestor != null;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children != null ? this.children.toArray(new ITreeNode[this.children.size()]) : new ITreeNode[]{};
    }

    @Override
    public List getChildList() {
        return this.children != null ? this.children : Collections.EMPTY_LIST;
    }

    @Override
    public ITreeNode addChild(ITreeNode child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(child);
        return child;
    }

    @Override
    public List removeChildren() {
        if (this.children == null) {
            this.children = new Vector();
        }
        Vector old = this.children;
        this.children = new Vector();
        return old;
    }

    @Override
    public void setProperty(Property p, Object newValue) {
        boolean newIsNull;
        Object oldValue;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        boolean oldIsNull = (oldValue = this.properties.get(p)) == null;
        boolean bl = newIsNull = newValue == null;
        if (oldIsNull && newIsNull) {
            return;
        }
        if (newIsNull) {
            this.removeProperty(p);
        } else if (oldIsNull || !newValue.equals(oldValue)) {
            this.properties.put(p, newValue);
        }
        this.firePropertyChangedEvent(p);
    }

    @Override
    public void setProperty(Property p, boolean value) {
        this.setProperty(p, (Object)value);
    }

    @Override
    public Object getProperty(Property p) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(p);
    }

    @Override
    public Object getProperty(Property p, Object defaultValue) {
        Object value = this.getProperty(p);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getStringProperty(Property p) {
        Object value = this.getProperty(p);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public boolean getBoolProperty(Property p) {
        Boolean value = (Boolean)this.getProperty(p, Boolean.FALSE);
        return value;
    }

    @Override
    public void removeProperty(Property p) {
        if (this.properties == null) {
            return;
        }
        if (this.properties.get(p) != null) {
            this.properties.remove(p);
            this.firePropertyChangedEvent(p);
        }
    }

    @Override
    public void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    public void firePropertyChangedEvent(Property p) {
        Object[] list;
        Object[] objectArray = list = this.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((IPropertyChangeListener)element).propertyChanged(this, p);
            ++n2;
        }
    }

    public String toString() {
        String modelTypeName = this.model.getClass().toString();
        int lastDot = modelTypeName.lastIndexOf(46);
        modelTypeName = modelTypeName.substring(lastDot + 1);
        String contentImage = this.model.toString();
        return "TreeNode wrapping " + modelTypeName + " object " + contentImage;
    }
}

