/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.infrastructure;

import com.ibm.infrastructure.ErrorMsgManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class WebFeedDOMParser {
    static Document document;
    static Bundle bundle;

    static {
        bundle = Platform.getBundle((String)"com.ibm.ccl.feedreader");
    }

    private static Document getDocument(String url) {
        try {
            URL feedURL = new URL(url);
            InputStream in = feedURL.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InputStream getFeed(String url, Locale locale) throws Exception {
        ByteArrayOutputStream actualOutputStream = new ByteArrayOutputStream();
        url = url.replaceAll("%2520", "%20");
        try {
            Document document = WebFeedDOMParser.getDocument(url);
            if (document == null) {
                return ErrorMsgManager.getXMLErrorMessage(locale);
            }
            URL stylesheet = WebFeedDOMParser.getStyleSheetForFeed(document.getDocumentElement().getNodeName());
            if (stylesheet == null) {
                return ErrorMsgManager.getXMLErrorMessage(locale);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet.openStream());
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(actualOutputStream);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ErrorMsgManager.getXMLErrorMessage(locale);
        }
        String actualString = actualOutputStream.toString("UTF8");
        System.out.print(actualString);
        return new ByteArrayInputStream(actualOutputStream.toString("UTF8").getBytes("UTF8"));
    }

    public static URL getStyleSheetForFeed(String feedType) {
        URL stylesheet;
        if (feedType == "rss") {
            Path path = new Path("scripts/rss.xsl");
            stylesheet = Platform.find((Bundle)bundle, (IPath)path);
        } else if (feedType == "feed") {
            Path path = new Path("scripts/atom.xsl");
            stylesheet = Platform.find((Bundle)bundle, (IPath)path);
        } else {
            return null;
        }
        return stylesheet;
    }

    public static InputStream printInputStream(InputStream in) {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                out.write((String.valueOf(line) + "\n").getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(out.toByteArray());
    }
}

