/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.ComponentInfo;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;

public class ProductInformation
implements Comparable {
    private String productId;
    private Version productVersion;
    private String productName;
    private String displayVersion;
    private String flexFeatureId;
    private String flexVersionId;
    private String lumProductId;
    private String lumVersionId;
    private String purchaseUrl = "http://www.ibm.com/software/info/ecatalog";
    private String licOrder;
    private String licType;
    private Object license = null;
    private LicenseStatus licenseStatus;
    private boolean expirationWarned;
    private String flexLastUsageTime;
    private String extensionContributor;
    private ProductInformation parentProductInformation = null;
    private List subProductInformation = new ArrayList();
    public static final String GENERIC_PURCHASE_URL = "http://www.ibm.com/software/info/ecatalog";
    private String startupCheckEnabled = "";
    private Set<ComponentInfo> components = new HashSet<ComponentInfo>();
    private Set<ComponentInfo> checkedOutComponents = new HashSet<ComponentInfo>();

    public ProductInformation() {
    }

    public ProductInformation(String productname) {
        this.productName = productname;
    }

    public Object getLicense() {
        return this.license;
    }

    public void setLicense(Object license) {
        this.license = license;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        if (productId == null) {
            throw new IllegalArgumentException("Cannot have null product id.");
        }
        this.productId = productId;
    }

    public Version getProductVersion() {
        return this.productVersion;
    }

    public String getProductVersionStr() {
        if (this.productVersion != null) {
            return this.productVersion.toString();
        }
        return "";
    }

    public void setProductVersion(Version productVersion) {
        Version licver;
        this.productVersion = licver = LicUserUtils.getMajorMinorMicroVersion(productVersion);
    }

    public void setProductVersion(String productVersion) {
        this.setProductVersion(new Version(productVersion));
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getDisplayVersion() {
        if (this.displayVersion != null) {
            return this.displayVersion;
        }
        return this.getProductVersionStr();
    }

    public void setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
    }

    public String getFlexFeatureId() {
        return this.flexFeatureId;
    }

    public void setFlexFeatureId(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException("Cannot have null feature id.");
        }
        this.flexFeatureId = featureName;
    }

    public String getFlexVersionId() {
        return this.flexVersionId;
    }

    public void setFlexVersionId(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Cannot have null version id.");
        }
        this.flexVersionId = version;
    }

    public String getLumProductId() {
        return this.lumProductId;
    }

    public void setLumProductId(String lumProductId) {
        this.lumProductId = lumProductId;
    }

    public String getLumVersionId() {
        return this.lumVersionId;
    }

    public void setLumVersionId(String lumVersionId) {
        this.lumVersionId = lumVersionId;
    }

    public String getLicOrder() {
        return this.licOrder;
    }

    public void setLicOrder(String licOrder) {
        this.licOrder = licOrder;
    }

    public String getLicType() {
        return this.licType;
    }

    public void setLicType(String licType) {
        this.licType = licType;
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseStatus;
    }

    public void setLicenseStatus(LicenseStatus licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    public String getFlexLastUsageTime() {
        return this.flexLastUsageTime;
    }

    public void setFlexLastUsageTime(String flexLastUsageTime) {
        this.flexLastUsageTime = flexLastUsageTime;
    }

    public boolean isExpirationWarned() {
        return this.expirationWarned;
    }

    public void setExpirationWarned(boolean expirationDisplayed) {
        this.expirationWarned = expirationDisplayed;
    }

    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    public void setPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
    }

    public void addSubProductInformation(ProductInformation subProductInfo) {
        ProductInformation info = this;
        while (info != null) {
            if (info == subProductInfo) {
                throw new IllegalArgumentException("cycle in product information");
            }
            info = info.parentProductInformation;
        }
        if (subProductInfo.parentProductInformation != null) {
            subProductInfo.parentProductInformation.subProductInformation.remove(subProductInfo);
            subProductInfo.parentProductInformation = null;
        }
        this.subProductInformation.add(subProductInfo);
        subProductInfo.parentProductInformation = this;
    }

    public ProductInformation getParentProductInformation() {
        return this.parentProductInformation;
    }

    public ProductInformation[] getSubProductInformation() {
        return this.subProductInformation.toArray(new ProductInformation[this.subProductInformation.size()]);
    }

    public String getExtensionContributor() {
        return this.extensionContributor;
    }

    public void setExtensionContributor(String extensionContributor) {
        this.extensionContributor = extensionContributor;
    }

    public String getStartupCheckFlag() {
        return this.startupCheckEnabled;
    }

    public void setStartupCheckFlag(String flag) {
        this.startupCheckEnabled = flag;
    }

    public List<ComponentInfo> getComponents() {
        return new ArrayList<ComponentInfo>(this.components);
    }

    public List<ComponentInfo> getCheckedOutComponents() {
        return new ArrayList<ComponentInfo>(this.checkedOutComponents);
    }

    public boolean addToCheckedOutComponents(ComponentInfo c) {
        return this.checkedOutComponents.add(c);
    }

    public boolean addToComponents(ComponentInfo c) {
        return this.components.add(c);
    }

    public void resetCheckedOutComponentList() {
        this.checkedOutComponents.clear();
    }

    public boolean addToCheckedOutComponents(List<ComponentInfo> componentList) {
        return this.checkedOutComponents.addAll(componentList);
    }

    public int compareTo(Object o) {
        ProductInformation pi = (ProductInformation)o;
        int w1 = this.getComponents().size();
        int w2 = pi.getComponents().size();
        return w1 - w2;
    }

    public String toString() {
        return "ProductInformation [productId=" + this.productId + "]";
    }
}

