/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.AbstractLicPlatformPolicyFactory;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

class PPLicPlatformUtils
extends AbstractLicPlatformPolicyFactory {
    static PPLicPlatformUtils m_factory = new PPLicPlatformUtils();

    PPLicPlatformUtils() {
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    @Override
    protected Object createUnknownOSPolicy() {
        return new PPUnknownOS();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        protected Properties environmentVariables = null;

        PPCommon() {
        }

        abstract Properties getEnvVars();

        abstract String getEnvVar(String var1);
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        Properties getEnvVars() {
            if (this.environmentVariables == null) {
                this.environmentVariables = new Properties();
                Map<String, String> env_variables = System.getenv();
                for (Map.Entry<String, String> entry : env_variables.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    this.environmentVariables.setProperty(name, value);
                }
            }
            return this.environmentVariables;
        }

        @Override
        String getEnvVar(String key) {
            return this.getEnvVars().getProperty(key);
        }
    }

    class PPUnknownOS
    extends PPCommon {
        PPUnknownOS() {
        }

        @Override
        Properties getEnvVars() {
            return new Properties();
        }

        @Override
        String getEnvVar(String key) {
            return this.getEnvVars().getProperty(key);
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        Properties getEnvVars() {
            if (this.environmentVariables == null) {
                this.environmentVariables = new Properties();
                Map<String, String> env_variables = System.getenv();
                for (Map.Entry<String, String> entry : env_variables.entrySet()) {
                    String name = entry.getKey().toUpperCase(Locale.ENGLISH);
                    String value = entry.getValue();
                    this.environmentVariables.setProperty(name, value);
                }
            }
            return this.environmentVariables;
        }

        @Override
        String getEnvVar(String key) {
            return this.getEnvVars().getProperty(key.toUpperCase(Locale.ENGLISH));
        }
    }
}

