/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class MacroResolver
extends NIFPlugin {
    private static MacroResolver[] m_amacrrslvResolvers = null;
    private static final String[] AS_EMPTY = new String[0];
    private static final int N_INFINTE = 10000;
    private static final String className = "MacroResolver";

    public static void cleanCachedMacros() {
        m_amacrrslvResolvers = null;
    }

    public static String resolveMacro(String sMacro, InstallToolkitBridge itb, Document documentPluginDefinitions) {
        try {
            MacroResolver.registerMacroResolvers(itb);
            return MacroResolver.resolveAllMacros(sMacro, documentPluginDefinitions);
        }
        catch (Exception e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            return sMacro;
        }
    }

    public static String[] resolveMacros(String[] asMacro, InstallToolkitBridge itb, Document documentPluginDefinitions) {
        String[] asReturn = new String[asMacro.length];
        int i = 0;
        while (i < asReturn.length) {
            asReturn[i] = MacroResolver.resolveMacro(asMacro[i], itb, documentPluginDefinitions);
            ++i;
        }
        return asReturn;
    }

    protected abstract boolean isMacroIDAcceptable(String var1);

    protected abstract String resolveMacro(String var1, String var2, Document var3);

    @Override
    protected String[] getRequiredParams() {
        return AS_EMPTY;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    protected static String getUnresolvedMacro(String sMacroID, String sMacroText) {
        return String.valueOf('$') + sMacroID + '{' + sMacroText + '}';
    }

    private static String resolveAllMacros(String sMacro, Document documentPluginDefinitions) {
        if (!MacroResolver.isValidMacro(sMacro)) {
            Logr.methodReturn(className, "resolveAllMacros", sMacro);
            return sMacro;
        }
        int nCounter = 0;
        String sReturn = sMacro;
        int nSearchIndex = 0;
        int nMacroStart = sReturn.indexOf(36, nSearchIndex);
        while (nMacroStart != -1) {
            if (sReturn.charAt(nMacroStart + 1) == '$') {
                nSearchIndex = nMacroStart + 1;
                sReturn = String.valueOf(sReturn.substring(0, nMacroStart)) + sReturn.substring(nMacroStart + 1);
            } else {
                int nStartBrace = sReturn.indexOf(123, nMacroStart);
                int nStopBrace = MacroResolver.getStopBracePosition(sReturn, nStartBrace + 1);
                if (nStartBrace < 0 || nStopBrace < 0) break;
                String sMacroID = sReturn.substring(nMacroStart + 1, nStartBrace);
                String sMacroText = sReturn.substring(nStartBrace + 1, nStopBrace);
                String sResolvedMacro = MacroResolver.resolveMacroUsingItsMacroResolver(sMacroID, MacroResolver.resolveAllMacros(sMacroText, documentPluginDefinitions), documentPluginDefinitions);
                String sReturnNew = String.valueOf(sReturn.substring(0, nMacroStart)) + sResolvedMacro + sReturn.substring(nStopBrace + 1);
                if (sReturn.equals(sReturnNew) || nCounter >= 10000) {
                    nSearchIndex += sResolvedMacro.length();
                }
                sReturn = sReturnNew;
                ++nCounter;
            }
            nMacroStart = sReturn.indexOf(36, nSearchIndex);
        }
        Logr.methodReturn(className, "resolveAllMacros", sReturn);
        return sReturn;
    }

    private static boolean isValidMacro(String sMacro) {
        int nSearchIndex = 0;
        int nMacroStart = sMacro.indexOf(36, nSearchIndex);
        if (nMacroStart == -1) {
            return false;
        }
        if (nMacroStart == sMacro.length() - 1) {
            return false;
        }
        int nStartBrace = sMacro.indexOf(123, nMacroStart);
        int nStopBrace = MacroResolver.getStopBracePosition(sMacro, nStartBrace + 1);
        return nStartBrace != -1 && nStopBrace != -1;
    }

    private static int getStopBracePosition(String sMacro, int nPositionToSearchFrom) {
        int nOpenCount = 0;
        int i = nPositionToSearchFrom;
        while (i < sMacro.length()) {
            if (sMacro.charAt(i) == '{') {
                ++nOpenCount;
            }
            if (sMacro.charAt(i) == '}' && nOpenCount == 0) {
                return i;
            }
            if (sMacro.charAt(i) == '}') {
                --nOpenCount;
            }
            ++i;
        }
        return -1;
    }

    private static String resolveMacroUsingItsMacroResolver(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        MacroResolver macrrslvThis = MacroResolver.getMacroResolverForID(sMacroID);
        if (macrrslvThis != null) {
            return macrrslvThis.resolveMacro(sMacroID, sMacroText, documentPluginDefinitions);
        }
        return String.valueOf('$') + sMacroID + '{' + sMacroText + '}';
    }

    private static MacroResolver getMacroResolverForID(String sMacroResolverID) {
        MacroResolver[] macroResolverArray = m_amacrrslvResolvers;
        int n = m_amacrrslvResolvers.length;
        int n2 = 0;
        while (n2 < n) {
            MacroResolver m_amacrrslvResolver = macroResolverArray[n2];
            if (m_amacrrslvResolver.isMacroIDAcceptable(sMacroResolverID)) {
                return m_amacrrslvResolver;
            }
            ++n2;
        }
        return null;
    }

    private static void registerMacroResolvers(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (m_amacrrslvResolvers != null) {
            return;
        }
        FileSystemEntry fseFSDB = new FileSystemEntry(new File(NIFConstants.getMetadataDirectory()).toURI(), "framework/macroresolvers.xml", itb);
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseFSDB);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "macroresolvers/macroresolver", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(MacroResolver.class, anifp);
        m_amacrrslvResolvers = new MacroResolver[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            MacroResolver.m_amacrrslvResolvers[i] = (MacroResolver)anifp[i];
            ++i;
        }
    }
}

