/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.logging;

import com.ibm.ws.pak.internal.PakCoreMessages;
import org.eclipse.core.runtime.Platform;

public abstract class ILogr {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    private static final String prefix = " **PAKENGINE** ";
    private static final String NGI_PLUGIN_ID = "com.ibm.ws.pak.internal";
    private static final String NGI_ID = "com.ibm.ws.pak.internal";
    private static boolean isLogging = true;
    private static boolean isDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ws.pak.internal/debug"));
    private static boolean debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ws.pak.internal/debug/debug"));
    private static boolean info = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ws.pak.internal/debug/info"));
    private static boolean warn = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ws.pak.internal/debug/warning"));
    private static boolean error = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ws.pak.internal/debug/error"));
    private static long logMaxSize = 2L;
    private static String m_sLogFileFullPath = null;
    private static ILogr m_debugLogger = null;
    private static ILogr m_logger = null;

    public static boolean isLoggerInitialized() {
        return m_logger != null;
    }

    public static boolean isDebugLoggerInitialized() {
        return m_debugLogger != null;
    }

    public static void initLogger(ILogr logger) {
        m_logger = logger;
    }

    public static void initDebugLogger(ILogr debugLogger) {
        m_debugLogger = debugLogger;
    }

    public static void error(String msg) {
        ILogr.error(msg, null);
    }

    public static void error(String className, String method, String msg, Exception e) {
        ILogr.error(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_WARN_ERROR_MSG, (Object[])new String[]{className, method, msg}), e);
    }

    public static void error(String msg, Exception e) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isError()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_ERROR_TITLE, msg, e, 0);
        }
        m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_ERROR_TITLE, msg, e, 0);
    }

    public static void warn(String msg) {
        ILogr.warn(msg, null);
    }

    public static void warn(String className, String method, String msg, Exception e) {
        ILogr.warn(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_WARN_ERROR_MSG, (Object[])new String[]{className, method, msg}), e);
    }

    public static void warn(String msg, Exception e) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isWarn()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_WARN_TITLE, msg, e, 1);
        }
        m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_WARN_TITLE, msg, e, 1);
    }

    public static void info(String msg) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isInfo()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, msg, 3);
        } else {
            m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, msg, 3);
        }
    }

    public static void debug(String msg) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isDebug()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_DEBUG_TITLE, msg, 2);
        } else {
            m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_DEBUG_TITLE, msg, 2);
        }
    }

    public static void methodExit(String className, String methodname) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isInfo()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGEXIT_EXIT, (Object)className, (Object)methodname), 3);
        } else {
            m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGEXIT_EXIT, (Object)className, (Object)methodname), 3);
        }
    }

    public static void methodEntry(String className, String methodname) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isInfo()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGENTRY_ENTRY, (Object)className, (Object)methodname), 3);
        } else {
            m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGENTRY_ENTRY, (Object)className, (Object)methodname), 3);
        }
    }

    public static void methodReturn(String className, String methodname, Object object) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (!ILogr.isDebug()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_DEBUG_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGENTRY_RETURN, (Object[])new Object[]{className, methodname, object}), 2);
        } else {
            m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_DEBUG_TITLE, PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_DEBUGENTRY_RETURN, (Object[])new Object[]{className, methodname, object}), 2);
        }
    }

    public static void logMessage(String msg) {
        if (!ILogr.isDebugLoggerInitialized() && !ILogr.isLoggerInitialized()) {
            return;
        }
        if (m_debugLogger != null) {
            m_debugLogger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, msg, 3);
        }
        m_logger.log(prefix + PakCoreMessages.PAK_CORE_LOG_INFO_TITLE, msg, 3);
    }

    protected abstract void log(String var1, int var2);

    protected abstract void log(String var1, String var2, int var3);

    protected abstract void log(String var1, String var2, Exception var3, int var4);

    protected static String getLogFileFullPath() {
        return m_sLogFileFullPath;
    }

    public static long getLogMaxSize() {
        return logMaxSize;
    }

    public static void setLogMaxSize(long logMaxSize) {
        ILogr.logMaxSize = logMaxSize;
    }

    public static boolean isLogging() {
        return isLogging;
    }

    public static void setLogging(boolean isLogging) {
        ILogr.isLogging = isLogging;
    }

    public static boolean getDebugging() {
        return isDebugging;
    }

    public static void setDebugging(boolean isDebugging) {
        ILogr.isDebugging = isDebugging;
    }

    public static boolean isDebug() {
        return debug || ILogr.getDebugging();
    }

    public static void setDebug(boolean debug) {
        ILogr.debug = debug;
    }

    public static boolean isInfo() {
        return info || ILogr.getDebugging();
    }

    public static void setInfo(boolean info) {
        ILogr.info = info;
    }

    public static boolean isWarn() {
        return warn || ILogr.getDebugging() || ILogr.isLogging();
    }

    public static void setWarn(boolean warn) {
        ILogr.warn = warn;
    }

    public static boolean isError() {
        return error || ILogr.getDebugging() || ILogr.isLogging();
    }

    public static void setError(boolean error) {
        ILogr.error = error;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setLogFileFullPath(String logFileFullPath) {
        m_sLogFileFullPath = logFileFullPath;
    }

    public static ILogr getDebugLogger() {
        return m_debugLogger;
    }

    public static void setDebugLogger(ILogr logger) {
        m_debugLogger = logger;
    }

    public static ILogr getLogger() {
        return m_logger;
    }

    public static void setLogger(ILogr m_logger) {
        ILogr.m_logger = m_logger;
    }

    public static boolean isLogEnabled() {
        return ILogr.isLogging() || ILogr.getDebugging() || ILogr.isDebug() || ILogr.isInfo() || ILogr.isWarn() || ILogr.isError();
    }
}

