/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

public class ProcessTimeoutThread
extends Thread {
    private Process m_processToTimeout = null;
    private int m_nTimeoutPeriod = 0;
    private boolean m_fStopTimingProcess = true;
    private static final int N_DEFAULT_SLEEP = 5;

    public ProcessTimeoutThread(Process processToTimeout, int nTimeoutPeriod) {
        this.m_processToTimeout = processToTimeout;
        this.m_nTimeoutPeriod = nTimeoutPeriod;
    }

    @Override
    public void run() {
        int nCurrentSleepTime = 0;
        while (!this.m_fStopTimingProcess && this.m_nTimeoutPeriod > nCurrentSleepTime) {
            try {
                Thread.sleep(5L);
                nCurrentSleepTime += 5;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.m_fStopTimingProcess) {
            this.m_processToTimeout.destroy();
        }
    }

    public void startTiming() {
        this.m_fStopTimingProcess = false;
        this.start();
    }

    public void stopTiming() {
        this.m_fStopTimingProcess = true;
        this.m_processToTimeout = null;
    }
}

