/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPReplaceFileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZIPAddFileActionPlugin
extends ZIPReplaceFileActionPlugin {
    private static final String S_FILE_ACTION_ID = "zip-add";
    private static final String S_INVERSE_FILE_ACTION_ID = "zip-remove";
    private static final String S_EXTENSIONS_PARAM = "extensions";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"extensions"};
    private static final String S_SEMI_COLON = ";";
    private static final String S_INVALID_ENTRY_PATH = "Invalid entry path: ";
    private static final String className = "ZIPAddFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails) && !this.doesTheFileToBeAddedAlreadyExistInInstallRoot(hashtableFileDetails)) {
            FileSystemEntry fseFrom = this.getTargetFileSystemEntry(hashtableFileDetails);
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            return;
        }
        super.execute(hashtableFileDetails);
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    @Override
    protected boolean isChecksumUpdateRequired(Hashtable hashtableFileDetails) {
        return true;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) {
        if (this.doesTheFileToBeAddedAlreadyExistInInstallRoot(hashtableFileDetails)) {
            return super.getInverseFileActionID(hashtableFileDetails);
        }
        return S_INVERSE_FILE_ACTION_ID;
    }

    private boolean doesTheFileToBeAddedAlreadyExistInInstallRoot(Hashtable hashtableFileDetails) {
        try {
            FileSystemEntry fseCheck = this.getTargetFileSystemEntry(hashtableFileDetails);
            return fseCheck.exists();
        }
        catch (IOException e) {
            Logr.warn(className, "doesTheFileToBeAddedAlreadyExistInInstallRoot(Hashtable)", e.getMessage(), e);
            return false;
        }
    }

    private FileSystemEntry getTargetFileSystemEntry(Hashtable hashtableFileDetails) throws IOException {
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sInstallLocationPath = fseInstallLocation.getURI().getPath();
        int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
        String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
        String sZIPFSRelativePath = sRelativeFilePath.substring(nFSRelativePathStopPosition + 1);
        try {
            URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
            FileSystemEntry fse = new FileSystemEntry(uriTarget, sZIPFSRelativePath, this.getInstallToolkitBridge());
            return fse;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "getTargetFileSystemEntry(Hashtable)", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private int getFSRelativePathStopPosition(String sRelativePath) throws IOException {
        String sExtensions = this.getParamValue(S_EXTENSIONS_PARAM);
        StringTokenizer st = new StringTokenizer(sExtensions, S_SEMI_COLON);
        while (st.hasMoreTokens()) {
            String sExtensionThis = "." + st.nextToken();
            if (sRelativePath.indexOf(sExtensionThis) == -1) continue;
            return sRelativePath.indexOf(sExtensionThis) + sExtensionThis.length();
        }
        throw new IOException(S_INVALID_ENTRY_PATH + sRelativePath);
    }
}

