/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.ReplaceFileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Hashtable;

public class AddFileActionPlugin
extends ReplaceFileActionPlugin {
    private static final String S_FILE_ACTION_ID = "add";
    private static final String S_INVERSE_FILE_ACTION_ID = "remove";
    private static final String className = "AddFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails)) {
            super.execute(hashtableFileDetails);
        }
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseSourceRepositoryPath = ReplaceFileActionPlugin.resolveSourceRepository(hashtableFileDetails);
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            Logr.debug("Cannot find backup.  It is add operation  :" + sRelativeFilePath);
            FileSystemEntry fseFrom = new FileSystemEntry(fseSourceRepositoryPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            return;
        }
        super.execute(hashtableFileDetails);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) throws IOException {
        if (this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails)) {
            return super.getInverseFileActionID(hashtableFileDetails);
        }
        return S_INVERSE_FILE_ACTION_ID;
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    private boolean doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(Hashtable hashtableFileDetails) {
        FileSystemEntry fseInstallRoot = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        try {
            FileSystemEntry fseCheck = new FileSystemEntry(fseInstallRoot.getURI(), sRelativePath, this.getInstallToolkitBridge());
            return fseCheck.exists();
        }
        catch (IOException e) {
            Logr.warn(className, "doesTheFileToBeOperatedUponAlreadyExistInInstallRoot", e.getMessage(), e);
            return false;
        }
    }
}

