/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.install.metadata.NIFHistory;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentAction;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentActionParams;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentDeployAction;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentMapRepositoryParser;
import com.ibm.ws.pak.internal.utils.componentactions.FilesListParser;
import com.ibm.ws.pak.internal.utils.events.ComponentActionWarningEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ZIPFileOperationController;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateComponent
extends ComponentAction {
    private final String className = "UpdateComponent";
    protected static final String S_FEATUREIDS_PARAM = "featureids";
    private static final String S_INSTALL_PACKAGE_URI = "installpackageuri";
    private static final String S_REPOSITORY_RELATIVE_PATH = "repositoryrelativepath";
    private static final String S_BACKUP_PACKAGE_URI = "backuppackageuri";
    private static final String S_COMPONENT_MAP_REPOSITORY = "componentmaprepository";
    private static final String S_PRODUCT_BACKUP_REPOSITORY = "productbackuprepository";
    private static final String S_CHECK_PERMISSIONS = "checkpermissions";
    private static final String S_DISABLED_PARAM = "disabled";
    private static final String S_INFAILURERECOVERYMODE_PARAM = "infailurerecoverymode";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"component", "installroot", "installpackageuri", "repositoryrelativepath", "featureids", "backuppackageuri", "componentmaprepository", "productbackuprepository"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"disabled", "infailurerecoverymode"};
    private ComponentMapRepositoryParser m_cmrpComponentMapsAlreadyInstalled = null;

    @Override
    public void execute(boolean fBackupMode) throws IOException {
        if (this.isDisabled()) {
            Logr.debug("UpdateComponent is disabled.");
            return;
        }
        if (!this.isRequiredFeaturePresent()) {
            if (fBackupMode) {
                String sWarningMessage = PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_SKIPPINGCOMPONENTACTION_MESSAGE_KEY, (Object[])new String[]{this.getID(), this.getParamValue("component"), this.getParamValue(S_FEATUREIDS_PARAM)});
                Logr.debug(sWarningMessage);
                NIFEventMulticaster.instance().publishEvent(new ComponentActionWarningEvent(sWarningMessage));
                this.removeCurrentPluginEntryFromCurrentDocument();
            }
            return;
        }
        ComponentActionParams capsThis = this.createComponentActionParamsForThisComponent(fBackupMode);
        if (!fBackupMode) {
            this.addComponentToRequestedComponentMaps();
        }
        if (!fBackupMode) {
            ZIPFileOperationController.initialize(this.getInstallToolkitBridge());
        }
        new ComponentDeployAction(capsThis).execute();
        if (!fBackupMode) {
            try {
                try {
                    ZIPFileOperationController.performAllZIPOperations();
                }
                catch (NIFFileActionIOException e) {
                    Logr.warn("UpdateComponent", "execute", e.getMessage(), e);
                    throw e;
                }
                catch (Exception e) {
                    Logr.warn("UpdateComponent", "execute", e.getMessage(), e);
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                ZIPFileOperationController.reset();
            }
        }
        if (!fBackupMode) {
            this.updateV6FullUninstallFilesListFile(capsThis);
        }
        this.updateMaintenanceHistoryXML();
        this.updateMaintenanceStackXML();
    }

    @Override
    public boolean isThisComponentActionApplicable() {
        try {
            return this.isRequiredFeaturePresent();
        }
        catch (IOException e) {
            Logr.warn("UpdateComponent", "isThisComponentActionApplicable", e.getMessage(), e);
            return false;
        }
    }

    public boolean isRequiredFeaturePresent() throws IOException {
        Vector vsRequiredFeatureIDs = this.getRequiredFeatureIDsToUpdateThisComponent();
        if (vsRequiredFeatureIDs.isEmpty()) {
            return true;
        }
        this.initComponentMapRepositoryParserIfNeeded();
        int i = 0;
        while (i < vsRequiredFeatureIDs.size()) {
            String sFeatureIDThis = vsRequiredFeatureIDs.elementAt(i).toString();
            if (this.m_cmrpComponentMapsAlreadyInstalled.isThisFeaturePresent(sFeatureIDThis)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    protected boolean isDisabled() {
        String sDisabled = this.getParamValue(S_DISABLED_PARAM);
        return new Boolean(sDisabled);
    }

    protected boolean isInFailureRecoveryMode() {
        String sInFailureRecoveryMode = this.getParamValue(S_INFAILURERECOVERYMODE_PARAM);
        if (sInFailureRecoveryMode == null) {
            sInFailureRecoveryMode = System.getProperty("inFailureRecoveryMode");
        }
        return new Boolean(sInFailureRecoveryMode);
    }

    @Override
    protected void clearLocalCache() throws IOException {
        this.initComponentMapRepositoryParser();
        super.clearLocalCache();
    }

    private void updateMaintenanceHistoryXML() {
        NIFHistory.addParamEntryToHighestOrderElement("component", this.getParamValue("component"));
        Vector vsFeatures = this.getExpandedParams(this.getParamValue(S_FEATUREIDS_PARAM));
        int i = 0;
        while (i < vsFeatures.size()) {
            NIFHistory.addParamEntryToHighestOrderElement("feature", (String)vsFeatures.elementAt(i));
            ++i;
        }
    }

    private void updateMaintenanceStackXML() throws IOException {
        if (NIFStack.isOpen() && !NIFStack.isFeaturesSet()) {
            ComponentMapRepositoryParser cmrpParser = this.getComponentMapRepositoryParser();
            String sFeatures = this.getStringRepresentation(cmrpParser.getTheListOfFeaturesAlreadyInstalled());
            NIFStack.setFeatures(sFeatures);
        }
    }

    private ComponentMapRepositoryParser getComponentMapRepositoryParser() throws IOException {
        try {
            FileSystemEntry fseComponentMapRepository = new FileSystemEntry(new URI(this.getParamValue(S_COMPONENT_MAP_REPOSITORY)), this.getInstallToolkitBridge());
            return new ComponentMapRepositoryParser(fseComponentMapRepository, this.getInstallToolkitBridge());
        }
        catch (URISyntaxException e) {
            Logr.warn("UpdateComponent", "getComponentMapRepositoryParser", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private void updateV6FullUninstallFilesListFile(ComponentActionParams caps) throws IOException {
        FilesListParser flpThisComponent = new FilesListParser(caps);
        String sUpdatedV6FullUninstallFilesListFile = flpThisComponent.getV6FullUninstallInverseFilesListForThisComponent(this.isInFailureRecoveryMode());
        FileSystemEntry fseV6FullUninstall = flpThisComponent.getV6FullUninstallFilesListFileForThisComponent();
        fseV6FullUninstall.writeUTF8(sUpdatedV6FullUninstallFilesListFile, false);
    }

    private void addComponentToRequestedComponentMaps() throws IOException {
        this.initComponentMapRepositoryParserIfNeeded();
        String sComponentName = this.getParamValue("component");
        Vector vsRequiredFeatureIDs = this.getRequiredFeatureIDsToUpdateThisComponent();
        int i = 0;
        while (i < vsRequiredFeatureIDs.size()) {
            String sFeatureIDThis = vsRequiredFeatureIDs.elementAt(i).toString();
            this.m_cmrpComponentMapsAlreadyInstalled.addComponentToThisComponentMap(sFeatureIDThis, sComponentName);
            ++i;
        }
    }

    private Vector getRequiredFeatureIDsToUpdateThisComponent() {
        String sRequiredFeatures = this.getParamValue(S_FEATUREIDS_PARAM);
        StringTokenizer st = new StringTokenizer(sRequiredFeatures, ";");
        Vector<String> vsReturn = new Vector<String>();
        while (st.hasMoreTokens()) {
            String sFeatureIDThis = st.nextToken();
            vsReturn.add(sFeatureIDThis);
        }
        return vsReturn;
    }

    private void initComponentMapRepositoryParserIfNeeded() throws IOException {
        if (this.m_cmrpComponentMapsAlreadyInstalled == null) {
            this.initComponentMapRepositoryParser();
        }
    }

    private void initComponentMapRepositoryParser() throws IOException {
        try {
            FileSystemEntry fseComponentMapRepository = new FileSystemEntry(new URI(this.getParamValue(S_COMPONENT_MAP_REPOSITORY)), this.getInstallToolkitBridge());
            this.m_cmrpComponentMapsAlreadyInstalled = new ComponentMapRepositoryParser(fseComponentMapRepository, this.getInstallToolkitBridge());
        }
        catch (URISyntaxException e) {
            Logr.warn("UpdateComponent", "initComponentMapRepositoryParser", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private ComponentActionParams createComponentActionParamsForThisComponent(boolean fBackupMode) throws IOException {
        try {
            String sComponentName = this.getParamValue("component");
            FileSystemEntry fseSourceRepository = new FileSystemEntry(new URI(this.getParamValue(S_INSTALL_PACKAGE_URI)), this.getParamValue(S_REPOSITORY_RELATIVE_PATH), this.getInstallToolkitBridge());
            FileSystemEntry fseProductInstallRoot = new FileSystemEntry(new URI(this.getParamValue("installroot")), this.getInstallToolkitBridge());
            FileSystemEntry fseBackupRepository = new FileSystemEntry(new URI(this.getParamValue(S_BACKUP_PACKAGE_URI)), this.getParamValue(S_REPOSITORY_RELATIVE_PATH), this.getInstallToolkitBridge());
            FileSystemEntry fseProductBackupRepository = new FileSystemEntry(new URI(this.getParamValue(S_PRODUCT_BACKUP_REPOSITORY)), this.getInstallToolkitBridge());
            boolean fIsCheckPermissionsNeeded = new Boolean(this.getParamValue(S_CHECK_PERMISSIONS));
            ComponentActionParams capsThis = new ComponentActionParams(sComponentName, new FileSystemEntry[]{fseSourceRepository}, fseProductInstallRoot, fseBackupRepository, fseProductBackupRepository, fBackupMode, m_fSendUpdateEventsPerFile, fIsCheckPermissionsNeeded, this.getInstallToolkitBridge());
            return capsThis;
        }
        catch (URISyntaxException e) {
            Logr.warn("UpdateComponent", "createComponentActionParamsForThisComponent", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }
}

