/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.events.ComponentActionEvent;
import com.ibm.ws.pak.internal.utils.events.ComponentActionFileEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.events.NIFEventObserver;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class ComponentAction
extends NIFPlugin {
    protected static final String S_COMPONENT_PARAM = "component";
    protected static final String S_INSTALLROOT_PARAM = "installroot";
    protected static boolean m_fSendUpdateEventsPerFile = true;
    private static NIFEventObserver m_nifeoOurObserver = new NIFEventObserver(){
        {
            NIFEventMulticaster.instance().subscribe(this, 1);
        }

        @Override
        public void eventOccured(NIFEvent nife) {
            ComponentAction.componentActionEventOccured((ComponentActionFileEvent)nife);
        }
    };
    private static int m_nCurrentComponentActionNumber = -1;
    private static int m_nTotalComponentActions = -1;
    private static String m_sCurrentComponentName = null;
    private static boolean m_fCurrentBackupFlag = false;
    private static final String[] AS_GENERIC_COMPONENT_ACTION_PARAMS = new String[]{"component", "installroot"};
    private static final String[] AS_EMPTY = new String[0];

    public static void executeBackupComponentActions(Document documentPluginDefinition, InstallToolkitBridge itb) throws IOException, SAXException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ComponentAction.executeComponentActions(documentPluginDefinition, itb, true);
    }

    public static void executeComponentActions(Document documentPluginDefinition, InstallToolkitBridge itb) throws IOException, SAXException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ComponentAction.executeComponentActions(documentPluginDefinition, itb, false);
    }

    public static int getTotalComponentActions(Document documentPluginDefinition, InstallToolkitBridge itb) throws IOException, SAXException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        NIFPlugin[] anifp = NIFPlugin.createPlugins(documentPluginDefinition, "install-package/component-action", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(ComponentAction.class, anifp);
        return anifp.length;
    }

    public abstract void execute(boolean var1) throws IOException;

    public boolean isThisComponentActionApplicable() {
        return true;
    }

    public String getComponent() {
        return this.getParamValue(S_COMPONENT_PARAM);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_GENERIC_COMPONENT_ACTION_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    private static void executeComponentActions(Document documentPluginDefinition, InstallToolkitBridge itb, boolean fBackupMode) throws IOException, SAXException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        NIFPlugin[] anifp = NIFPlugin.createPlugins(documentPluginDefinition, "install-package/component-action", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(ComponentAction.class, anifp);
        ComponentAction.setComponentUpdateEventMode(anifp.length);
        int i = 0;
        while (i < anifp.length) {
            ComponentAction compactThis = (ComponentAction)anifp[i];
            ComponentAction.updateProgressData(i, anifp.length, compactThis, fBackupMode);
            if (i == 0) {
                compactThis.clearLocalCache();
            }
            compactThis.execute(fBackupMode);
            ++i;
        }
    }

    protected void clearLocalCache() throws IOException {
    }

    private static void setComponentUpdateEventMode(int nTotalComponents) {
        m_fSendUpdateEventsPerFile = nTotalComponents < 17;
    }

    private static void updateProgressData(int nCurrentComponentActionNumber, int nTotalComponentActions, ComponentAction compactCurrent, boolean fBackupFlag) {
        m_nCurrentComponentActionNumber = nCurrentComponentActionNumber;
        m_nTotalComponentActions = nTotalComponentActions;
        m_sCurrentComponentName = compactCurrent.getParamValue(S_COMPONENT_PARAM);
        m_fCurrentBackupFlag = fBackupFlag;
        if (!m_fSendUpdateEventsPerFile) {
            ComponentAction.componentActionEventOccured(null);
        }
    }

    private static void componentActionEventOccured(ComponentActionFileEvent cafe) {
        ComponentActionEvent cae = new ComponentActionEvent(m_sCurrentComponentName, m_nCurrentComponentActionNumber, m_nTotalComponentActions, m_fCurrentBackupFlag, cafe);
        NIFEventMulticaster.instance().publishEvent(cae);
    }

    public static NIFEventObserver getObserver() {
        return m_nifeoOurObserver;
    }
}

