/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.util.TreeMap;
import java.util.Vector;

public class CommonComponent {
    private static final String className = "CommonComponent";
    private String CCID = null;
    private String minRequiredVersion = "0.0.0.0";
    private String highestVersion = "0.0.0.0";
    private final TreeMap ccVersionNIFPackageEntryListMap = new TreeMap();
    private TreeMap uninstallableBackupPackagesURIsMap = null;
    private TreeMap uninstallableNIFPackageEntryMap = null;

    public CommonComponent(String ccID) {
        this.setCCID(ccID);
    }

    public String getCCID() {
        return this.CCID;
    }

    private void setCCID(String ccid) {
        this.CCID = ccid;
    }

    public String getHighestVersion() {
        return this.highestVersion;
    }

    private void setHighestVersion(String highestVersion) {
        this.highestVersion = highestVersion;
    }

    public String getMinRequiredVersion() {
        return this.minRequiredVersion;
    }

    public void setMinRequiredVersion(String minimumRequiredVersion) {
        if (VersionUtils.compareVersions(minimumRequiredVersion, this.minRequiredVersion) == 1) {
            this.minRequiredVersion = minimumRequiredVersion;
        }
    }

    public TreeMap getUninstallableNIFPackageEntryMap() {
        if (this.uninstallableNIFPackageEntryMap == null) {
            this.doProcess();
        }
        return this.uninstallableNIFPackageEntryMap;
    }

    public TreeMap getUninstallableBackupPackagesURIsMap() {
        if (this.uninstallableBackupPackagesURIsMap == null) {
            this.doProcess();
        }
        return this.uninstallableBackupPackagesURIsMap;
    }

    private void doProcess() {
        Logr.methodEntry(className, "doProcess");
        this.uninstallableBackupPackagesURIsMap = new TreeMap();
        this.uninstallableNIFPackageEntryMap = new TreeMap();
        int result = VersionUtils.compareVersions(this.highestVersion, this.minRequiredVersion);
        if (result == 1) {
            String sMsg = "Common component packages with CCID: " + this.CCID + " may need to be uninstalled.....";
            Logr.debug(sMsg);
            Vector ccVersionList = new Vector(this.ccVersionNIFPackageEntryListMap.keySet());
            int i = ccVersionList.size() - 1;
            while (i >= 0 && VersionUtils.compareVersions((String)ccVersionList.elementAt(i), this.minRequiredVersion) == 1) {
                this.generateUninstallableBackupPakURIStringAndNIFPackageEntryMap((Vector)this.ccVersionNIFPackageEntryListMap.get(ccVersionList.elementAt(i)));
                --i;
            }
        } else if (result == -1) {
            String sMsg = "The highest version of common component with CCID: " + this.CCID + " in the stack can not satisfy the minimum required version by existing products: " + this.minRequiredVersion + ". Please check the stack for integrity.";
            Logr.debug(sMsg);
        }
        Logr.methodExit(className, "doProcess");
    }

    public void addCommonComponentPackEntry(NIFPackageEntry ccPackEntry) {
        this.uninstallableNIFPackageEntryMap = null;
        this.uninstallableBackupPackagesURIsMap = null;
        String ccVersion = ccPackEntry.getParamValue("pakversion");
        Vector ccPackageList = null;
        ccPackageList = !this.ccVersionNIFPackageEntryListMap.keySet().contains(ccVersion) ? new Vector() : (Vector)this.ccVersionNIFPackageEntryListMap.get(ccVersion);
        ccPackageList.add(ccPackEntry);
        this.ccVersionNIFPackageEntryListMap.put(ccVersion, ccPackageList);
        if (VersionUtils.compareVersions(ccVersion, this.highestVersion) == 1) {
            this.setHighestVersion(ccVersion);
        }
    }

    private void generateUninstallableBackupPakURIStringAndNIFPackageEntryMap(Vector listOfCCPaksUninstall) {
        Logr.methodEntry(className, "generateUninstallableBackupPakURIStringAndNIFPackageEntryMap");
        String sBackupDir = "$NIFP{selectedproduct.backuppath}";
        int i = 0;
        while (i < listOfCCPaksUninstall.size()) {
            NIFPackageEntry currentPackEntry = (NIFPackageEntry)listOfCCPaksUninstall.elementAt(i);
            Integer order = new Integer(currentPackEntry.getOrder());
            this.uninstallableNIFPackageEntryMap.put(order, currentPackEntry);
            this.uninstallableBackupPackagesURIsMap.put(order, new StringBuffer().append("$NIFDEFFSSOURCEURI{").append(sBackupDir).append("/").append(((NIFPackageEntry)listOfCCPaksUninstall.elementAt(i)).getParamValue("filename")).append("}").toString());
            String sMsg = "This common component pak with name: " + currentPackEntry.getNIFPackageName() + " with this order: " + order + " and this version: " + currentPackEntry.getParamValue("pakversion") + " will be uninstalled.";
            Logr.debug(sMsg);
            ++i;
        }
        Logr.methodExit(className, "generateUninstallableBackupPakURIStringAndNIFPackageEntryMap");
    }
}

