/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleXMLParser {
    private Document m_document = null;
    private static final String S_PATH_SEPARATOR = "/";
    private static final String S_EMPTY = "";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_YES = "yes";
    private static final String S_NO = "no";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";

    public SimpleXMLParser(Document document) {
        this.m_document = document;
    }

    public SimpleXMLParser(File fileXMLDocument) throws ParserConfigurationException, SAXException, IOException {
        this(fileXMLDocument, true);
    }

    public SimpleXMLParser(File fileXMLDocument, boolean bIgnoreComments) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentbuilder = this.getDocumentBuilder(bIgnoreComments);
        FileInputStream fileinputstream = new FileInputStream(fileXMLDocument);
        this.m_document = documentbuilder.parse(fileinputstream);
        fileinputstream.close();
    }

    public SimpleXMLParser(InputStream inputstream) throws ParserConfigurationException, SAXException, IOException {
        this(inputstream, true);
    }

    public SimpleXMLParser(InputStream inputstream, boolean bIgnoreComments) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentbuilder = this.getDocumentBuilder(bIgnoreComments);
        this.m_document = documentbuilder.parse(inputstream);
    }

    public SimpleXMLParser(String sXMLDocument) throws ParserConfigurationException, SAXException, IOException {
        this(sXMLDocument, true);
    }

    public SimpleXMLParser(String sXMLDocument, boolean bIgnoreComments) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentbuilder = this.getDocumentBuilder(bIgnoreComments);
        this.m_document = documentbuilder.parse(new InputSource(new StringReader(sXMLDocument)));
    }

    public static Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilder documentbuilderNew = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentbuilderNew.newDocument();
    }

    public static Element addNestedElement(String sElementName, String sElementValue, Hashtable hashtableAttributes, Node nodeParent) {
        Document documentThis = null;
        documentThis = nodeParent.getNodeType() == 9 ? (Document)nodeParent : nodeParent.getOwnerDocument();
        Element elementThis = documentThis.createElement(sElementName);
        if (sElementValue != null) {
            SimpleXMLParser.setNodeText(elementThis, sElementValue);
        }
        if (hashtableAttributes != null) {
            Enumeration enumerationAttributeNames = hashtableAttributes.keys();
            while (enumerationAttributeNames.hasMoreElements()) {
                String sAttributeName = enumerationAttributeNames.nextElement().toString();
                String sAttributeValue = hashtableAttributes.get(sAttributeName).toString();
                elementThis.setAttribute(sAttributeName, sAttributeValue);
            }
        }
        if (nodeParent.hasChildNodes() && nodeParent.getLastChild().getNodeType() == 3) {
            nodeParent.insertBefore(elementThis, nodeParent.getLastChild());
        } else {
            nodeParent.appendChild(elementThis);
        }
        return elementThis;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public static String getNodeText(Node nodeThis) {
        String sReturn = S_EMPTY;
        NodeList nodelistChildren = nodeThis.getChildNodes();
        if (nodelistChildren.getLength() == 0 && nodeThis.getNodeType() == 2) {
            return nodeThis.getNodeValue();
        }
        int i = 0;
        while (i < nodelistChildren.getLength()) {
            Node nodeChildThis = nodelistChildren.item(i);
            if (nodeChildThis.getNodeType() == 3 || nodeChildThis.getNodeType() == 4) {
                sReturn = String.valueOf(sReturn) + nodeChildThis.getNodeValue();
            }
            if (nodeChildThis.getNodeType() == 5) {
                sReturn = String.valueOf(sReturn) + SimpleXMLParser.getNodeText(nodeChildThis);
            }
            ++i;
        }
        return sReturn;
    }

    public static void setNodeText(Node nodeThis, String sText) {
        NodeList nodelistChildren = nodeThis.getChildNodes();
        int i = 0;
        while (i < nodelistChildren.getLength()) {
            Node nodeChildThis = nodelistChildren.item(i);
            nodeThis.removeChild(nodeChildThis);
            ++i;
        }
        Text nodeText = nodeThis.getOwnerDocument().createTextNode(sText);
        nodeThis.appendChild(nodeText);
    }

    public static String getNodeAttributeValue(Node nodeThis, String sAttributeName) {
        NamedNodeMap namednodemapAttributes = nodeThis.getAttributes();
        Node nodeAttribute = namednodemapAttributes.getNamedItem(sAttributeName);
        if (nodeAttribute != null) {
            return SimpleXMLParser.getNodeText(nodeAttribute);
        }
        return null;
    }

    public static Hashtable getAttriNameAndValueMap(Node nodeThis) {
        NamedNodeMap map = nodeThis.getAttributes();
        if (map == null) {
            return null;
        }
        Hashtable<String, String> htReturn = new Hashtable<String, String>();
        int nLength = map.getLength();
        int i = 0;
        while (i < nLength) {
            htReturn.put(map.item(i).getNodeName(), map.item(i).getNodeValue());
            ++i;
        }
        return htReturn;
    }

    public static void setNodeAttributeValue(Node nodeThis, String sAttributeName, String sAttributeValue) {
        if (nodeThis.getNodeType() != 1) {
            return;
        }
        Element elementThis = (Element)nodeThis;
        elementThis.setAttribute(sAttributeName, sAttributeValue);
    }

    public static Vector getRelativeNodes(Node nodeParent, String sNodeRelativePath) {
        Vector<String> vsParentNodeNames = new Vector<String>();
        StringTokenizer st = new StringTokenizer(sNodeRelativePath, S_PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            vsParentNodeNames.add(st.nextToken());
        }
        Vector vnodesCurrentChildren = new Vector(Arrays.asList(nodeParent));
        int i = 0;
        while (i < vsParentNodeNames.size()) {
            String sChildNodeThis = vsParentNodeNames.elementAt(i).toString();
            vnodesCurrentChildren = SimpleXMLParser.getAllNamedChildNodes(vnodesCurrentChildren, sChildNodeThis);
            ++i;
        }
        return vnodesCurrentChildren;
    }

    public Vector getNodes(String sNodePath) {
        return SimpleXMLParser.getRelativeNodes(this.m_document, sNodePath);
    }

    public static Vector getChildElements(Node nodeParent) {
        NodeList nodelistChildren = nodeParent.getChildNodes();
        Vector<Node> velementsChildren = new Vector<Node>();
        int i = 0;
        while (i < nodelistChildren.getLength()) {
            Node nodeThis = nodelistChildren.item(i);
            if (nodeThis.getNodeType() == 1) {
                velementsChildren.add(nodeThis);
            }
            ++i;
        }
        return velementsChildren;
    }

    public static Vector getAllNamedChildNodes(Node nodeParent, String sChildNodeName) {
        if (nodeParent.getNodeType() != 1 && nodeParent.getNodeType() != 9) {
            return new Vector();
        }
        NodeList nodelistChildren = null;
        if (nodeParent.getNodeType() == 1) {
            Element elementParent = (Element)nodeParent;
            nodelistChildren = elementParent.getElementsByTagName(sChildNodeName);
        } else {
            Document documentParent = (Document)nodeParent;
            nodelistChildren = documentParent.getElementsByTagName(sChildNodeName);
        }
        Vector<Node> vnodesReturn = new Vector<Node>();
        int i = 0;
        while (i < nodelistChildren.getLength()) {
            Node nodeChildThis = nodelistChildren.item(i);
            if (nodeChildThis.getParentNode() == nodeParent) {
                vnodesReturn.add(nodeChildThis);
            }
            ++i;
        }
        return vnodesReturn;
    }

    public static Vector getAllNamedChildNodes(Node nodeParent, String[] asChildNodeNames) {
        Vector vnodesReturn = new Vector();
        int i = 0;
        while (asChildNodeNames != null && i < asChildNodeNames.length) {
            vnodesReturn.addAll(SimpleXMLParser.getAllNamedChildNodes(nodeParent, asChildNodeNames[i]));
            ++i;
        }
        return vnodesReturn;
    }

    public static void deleteChildNodes(Node nodeParent, Vector vnodes) {
        int i = 0;
        while (i < vnodes.size()) {
            nodeParent.removeChild((Node)vnodes.elementAt(i));
            ++i;
        }
    }

    public static String getNodeAsXML(Node node, boolean fAddXMLHeader) throws TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        ByteArrayOutputStream bytearrayoutputstreamResult = new ByteArrayOutputStream();
        DOMSource domsource = new DOMSource(node);
        StreamResult streamresult = new StreamResult(new PrintWriter(bytearrayoutputstreamResult));
        transformer.setOutputProperty("indent", S_YES);
        transformer.setOutputProperty("encoding", S_UTF_8);
        transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
        if (!fAddXMLHeader) {
            transformer.setOutputProperty("omit-xml-declaration", S_YES);
        } else {
            transformer.setOutputProperty("omit-xml-declaration", S_NO);
        }
        transformer.transform(domsource, streamresult);
        return bytearrayoutputstreamResult.toString(S_UTF_8);
    }

    private static Vector getAllNamedChildNodes(Vector vnodesParent, String sChildNodeName) {
        Vector vnodesReturn = new Vector();
        int i = 0;
        while (i < vnodesParent.size()) {
            Node nodeParentThis = (Node)vnodesParent.elementAt(i);
            vnodesReturn.addAll(SimpleXMLParser.getAllNamedChildNodes(nodeParentThis, sChildNodeName));
            ++i;
        }
        return vnodesReturn;
    }

    private DocumentBuilder getDocumentBuilder(boolean bIgnoreComments) throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        documentbuilderfactory.setCoalescing(true);
        documentbuilderfactory.setExpandEntityReferences(true);
        documentbuilderfactory.setIgnoringComments(bIgnoreComments);
        documentbuilderfactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
        return documentbuilder;
    }
}

