/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.install.registry.NIFRegistry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryDirectory;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryHelper;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryMergerDelta;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryMergerRemoveDuplicates;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryPAKEntry;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NIFRegistryPlugin
extends NIFPlugin {
    @Deprecated
    public static final String S_OFFERING_ID_ND = "ND";
    @Deprecated
    public static final String S_OFFERING_ID_BASE = "BASE";
    @Deprecated
    public static final String S_OFERING_ID_BASETRIAL = "BASETRIAL";
    @Deprecated
    public static final String S_OFFERING_ID_EXPRESS = "EXPRESS";
    @Deprecated
    public static final String S_OFFERING_ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    @Deprecated
    public static final String S_OFFERING_ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    @Deprecated
    public static final String S_OFFERING_ID_CLIENT = "CLIENT";
    @Deprecated
    public static final String S_OFFERING_ID_PLUGIN = "PLG";
    @Deprecated
    public static final String S_OFFERING_ID_IHS = "IHS";
    @Deprecated
    public static final String S_OFFERING_ID_XD = "XD";
    @Deprecated
    public static final String S_OFFERING_ID_PME = "PME";
    @Deprecated
    public static final String S_OFFERING_ID_WBI = "WBI";
    @Deprecated
    public static final String S_OFFERING_ID_JDK = "JDK";
    protected static NIFRegistryPlugin m_nifrpSingleton = null;
    protected static boolean m_fIsNIFRegistryEnabled = true;
    protected static NIFRegistry m_nifregistrySingleton = null;
    protected String m_sNIFRegistryPath = null;
    protected URI m_uriNIFRegistryURICache = null;
    protected static boolean m_fMergeRegistryCalledBefore = false;
    protected static boolean m_fCleanupInvalidLocationCalledBefore = false;
    protected static final String S_REGISTRYNAME_PARAM = "registryname";
    protected static final String S_ENABLENIFREGISTRY_PARAM = "enablenifregistry";
    protected static final String S_PRODUCTIDOVERRIDE_PARAM = "productidoverride";
    protected static final String[] AS_REQUIRED_PARAMS = new String[]{"registryname"};
    protected static final String[] AS_OPTIONAL_PARAMS = new String[]{"enablenifregistry", "productidoverride"};
    protected static final String S_EQUALS = "=";
    protected static final String S_ATTRIBUTE_SEPARATOR = "; ";
    protected static final String S_DISABLE_NIFREGISTRY = "false";
    protected static final String S_UPGRADE = "upgrade";
    protected static final String S_ADDFEATURE = "addfeature";
    protected static final String S_CORRUPT_NIFREGISTRY_EXTENSION = ".corrupted";
    protected static final String S_NULL_STRING = "null";
    protected static final String S_NIFREGISTRY_PROPERTY_FILE_NAME = "NIFRegistry.properties";
    protected static final String S_NIFREGISTRY_LOCATION_PROPERTY_NAME = "nifregistry_location";
    protected static final String S_NIFREGISTRY_PROPERTY_FILE_DESC = "NIFREGISTRY Location";
    protected static final int N_FILE_AUTHORITIES = 700;
    private static final String S_LOG_MESSAGE_INSTALLING_THIS_PAK = "Installing this PAK:";
    private static final String S_LOG_MESSAGE_UNINSTALLING_THIS_PAK = "Uninstalling this PAK:";
    private static final String S_LOG_MESSAGE_INSTALLING_THIS_PRODUCT = "Installing this PRODUCT:";
    private static final String S_LOG_MESSAGE_UNINSTALLING_THIS_PRODUCT = "Uninstalling this PRODUCT:";
    private static final String S_LOG_MESSAGE_UNINSTALLING_THIS_PRODUCT_OFFERING_ENTRY_NOT_EXIST = "Uninstalling this PRODUCT although the offering entry does not exist in the registry file:";
    private static final String S_LOG_MESSAGE_UPGRADING_THIS_PRODUCT = "Upgrading this product:";
    private static final String S_LOG_MESSAGE_UPGRADING_THIS_WAS_PRODUCT = "Upgrading this WAS product:";
    private static final String S_LOG_MESSAGE_SKIP_UPDATE_REGISTRY_V6_OS400_MAINTENANCE = "Skipped registry update because WAS v6.0 maintenance is being applied on os/400.";
    private static final String S_LOG_MESSAGE_NON_ADMIN_INSTALL_APPLY_MAINTENANCE_UPGRADE_VISTA = "A non-admin user is doing install, apply maintenance or upgrade on Windows Vista.";
    private static final String S_LOG_MESSAGE_REFRESH_REGISTRY_VFS = "Switch the registry location to Vista VFS with path: ";
    private static final String S_LOG_MESSAGE_REFRESH_REGISTRY_NONROOT = "Switch the registry location to non-root one with path: ";
    private static final String S_LOG_MESSAGE_REFRESH_REGISTRY_ROOT = "Switch the registry location to root one with path: ";
    private static final String S_LOG_MESSAGE_INSTALLING_APPLY_MAINTENANCE_ADD_FEATURE_THIS_PRODUCT = "Installing, adding feature, or doing maintenance to this PRODUCT:";
    private static final String S_LOG_MESSAGE_APPLY_MAINTENACE_ADD_FEATURE_ON_THIS_PRODUCT = "Applying maintenance or adding feature or doing slip install to this PRODUCT: ";
    private static final String S_LOG_MESSAGE_NORMALIZE_PRODUCT_ID = "Normalize product ID ";
    private static final String S_LOG_MESSAGE_SWITCH_PRODUCT_ID_APPLY_MAINTENANCE_ADD_FEATURE_ON_THIS_PRODUCT = "Switched the product ID of the pak and the offering entry of this PRODUCT when applying maintenance or adding feature: ";
    private static final String S_LOG_MESSAGE_REGISTRY_FILE_EXISTS_UNDER_LOCATION_URI = "NIFRegistry file exists under location: ";
    private static final String S_LOG_MESSAGE_REGISTRY_FILE_DOES_NOT_EXISTS_UNDER_LOCATION_URI = "NIFRegistry file does not exist under location: ";
    private static final String S_LOG_MESSAGE_CHECK_REGISTRY_FILE_EXISTENCE_ERROR_UNDER_LOCATION_URI = "Can not check existence of nifregistry file under location: ";
    private static final String S_LOG_MESSAGE_NULL_REGISTRY_URI = "NIFRegistry location URI is null.";
    private static final String S_LOG_WARNING_MESSAGE_PROCESSING_THIS_PRODUCT_EXISTS_IN_REGISTRY = "Warning: this offering being processed exists in the install registry file already: ";
    private static final String S_OS400_V6_PRODUCTLOCATION_ROOT = "/qibm/proddata/websphere/appserver/v6/";
    private final String className = "NIFRegistryPlugin";

    public static NIFRegistryPlugin getNIFRegistryPlugin(InstallToolkitBridge itb) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException, ParserConfigurationException, SAXException, URISyntaxException {
        return NIFRegistryPlugin.getNIFRegistryPluginRefByCurrentInstallRoot(itb, false);
    }

    public static NIFRegistryPlugin getNIFRegistryPluginRefByCurrentInstallRoot(InstallToolkitBridge itb, boolean bRefByCurrentProduct) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_nifrpSingleton == null) {
            FileSystemEntry fseNIFRP = URIUtils.convertPathToDefaultSourceMachineFSE(String.valueOf(NIFConstants.getMetadataDirectory()) + "/" + "framework/nifregistry.xml", itb);
            SimpleXMLParser sxp = new SimpleXMLParser(fseNIFRP.getInputStream());
            NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "nifregistry-plugins/nifregistry", itb);
            NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(NIFRegistryPlugin.class, anifp);
            m_nifrpSingleton = (NIFRegistryPlugin)anifp[0];
        }
        if (S_DISABLE_NIFREGISTRY.equalsIgnoreCase(m_nifrpSingleton.getParamValue(S_ENABLENIFREGISTRY_PARAM))) {
            m_fIsNIFRegistryEnabled = false;
        } else {
            m_nifrpSingleton.readNIFRegistry(bRefByCurrentProduct);
            m_nifrpSingleton.mergeNIFRegistryForVista();
            m_nifrpSingleton.cleanupInvalidInstallLocation();
        }
        return m_nifrpSingleton;
    }

    @Deprecated
    public String[] getPAKNameArrayByOffering(String sOffering) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getPAKNameArrayByOffering(sOffering);
        }
        String[] asPAKNameReturned = new String[]{};
        return asPAKNameReturned;
    }

    @Deprecated
    public String[] getPAKNameArrayByOfferingLocation(String sOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getPAKNameArrayByOfferingLocation(sOfferingLocation);
        }
        String[] asPAKNameReturned = new String[]{};
        return asPAKNameReturned;
    }

    @Deprecated
    public String[] getPAKNameArrayByOfferingLocationAndOffering(String sOffering, String sOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getPAKNameArrayByOfferingLocationAndOffering(sOffering, sOfferingLocation);
        }
        String[] asPAKNameReturned = new String[]{};
        return asPAKNameReturned;
    }

    @Deprecated
    public String[] getOfferingArrayByOfferingLocationURI(URI uriInstallLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled && this.doesNIFRegistryFileExist()) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getOfferingArrayByOfferingLocationURI(uriInstallLocation);
        }
        return null;
    }

    @Deprecated
    public String[] getOfferingLocatonStringArrayByOffering(String sCurrentOffering) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getOfferingLocationStringArrayByOffering(sCurrentOffering);
        }
        String[] asOfferingLocationReturned = new String[]{};
        return asOfferingLocationReturned;
    }

    public String[] getInstallLocatonStringArrayByOffering(String sCurrentOffering) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (this.isNIFRegistryEnabled() && this.doesNIFRegistryFileExist()) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getOfferingLocationStringArrayByOffering(sCurrentOffering);
        }
        return null;
    }

    public String[] getAllInstallLocationStringArrayAccessible() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (this.isNIFRegistryEnabled() && this.doesNIFRegistryFileExist()) {
            URI[] uniqueInstallLocationURIList = this.getAllInstallLocationURIArrayAccessible();
            if (uniqueInstallLocationURIList != null) {
                String[] uniqueOfferingLocationList = new String[uniqueInstallLocationURIList.length];
                int i = 0;
                while (i < uniqueInstallLocationURIList.length) {
                    uniqueOfferingLocationList[i] = NIFRegistryHelper.normalizePathFromURI(uniqueInstallLocationURIList[i]);
                    ++i;
                }
                return uniqueOfferingLocationList;
            }
            return null;
        }
        return null;
    }

    private URI[] getAllInstallLocationURIArrayAccessible() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (this.isNIFRegistryEnabled() && this.doesNIFRegistryFileExist()) {
            Vector<URI> uniqueInstallLocationList = new Vector<URI>();
            NIFRegistryOfferingEntry[] allInstalledProduct = this.getInstalledProducts();
            int i = 0;
            while (allInstalledProduct != null && i < allInstalledProduct.length) {
                URI currentOfferingLocationURI = allInstalledProduct[i].getOfferingLocationURI();
                int j = 0;
                boolean fFound = false;
                while (j < uniqueInstallLocationList.size() && !fFound) {
                    if (NIFRegistryHelper.AreTheseURIsPointToSameLocation(currentOfferingLocationURI, (URI)uniqueInstallLocationList.elementAt(j))) {
                        fFound = true;
                    }
                    ++j;
                }
                if (!fFound) {
                    uniqueInstallLocationList.add(currentOfferingLocationURI);
                }
                ++i;
            }
            return uniqueInstallLocationList.toArray(new URI[uniqueInstallLocationList.size()]);
        }
        return null;
    }

    @Deprecated
    public String getWASSpecificOfferingByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getWASSpecificOfferingByOfferingLocationURI(uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public String[] getLastVisitedArrayByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getLastVisitedArrayByOfferingLocationURI(uriOfferingLocation);
        }
        String[] asLastVisitedReturned = new String[]{};
        return asLastVisitedReturned;
    }

    @Deprecated
    public String getLastVisitedByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getLastVisitedByOfferingLocationURIAndOffering(sOffering, uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public String[] getVersionArrayByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getVersionArrayByOfferingLocationURI(uriOfferingLocation);
        }
        String[] asVersionReturned = new String[]{};
        return asVersionReturned;
    }

    @Deprecated
    public String getVersionByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getVersionByOfferingLocationURIAndOffering(sOffering, uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public String getWASSpecificVersionByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getWASSpecificVersionByOfferingLocationURI(uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getInstalledPAKs() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getAllInstalledPAKs();
        }
        NIFRegistryPAKEntry[] anifrpe = new NIFRegistryPAKEntry[]{};
        return anifrpe;
    }

    @Deprecated
    public NIFRegistryOfferingEntry[] getInstalledProducts() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getAllInstalledProducts();
        }
        NIFRegistryOfferingEntry[] anifroe = new NIFRegistryOfferingEntry[]{};
        return anifroe;
    }

    @Deprecated
    public NIFRegistryPAKEntry getInstalledPAKByPAKLocationURI(URI uriPAKLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledPAKByPAKLocationURI(uriPAKLocation);
        }
        return null;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getInstalledPAKArrayByPAKNameAndOfferingLocationURI(String sPAKName, URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledPAKArrayByPAKNameAndOfferingLocationURI(sPAKName, uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getInstalledPAKArrayByPAKName(String sPAKName) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledPAKArrayByPAKName(sPAKName);
        }
        NIFRegistryPAKEntry[] anifrpe = new NIFRegistryPAKEntry[]{};
        return anifrpe;
    }

    @Deprecated
    public NIFRegistryOfferingEntry[] getInstalledProductArrayByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledProductArrayByOfferingLocationURI(uriOfferingLocation);
        }
        NIFRegistryOfferingEntry[] anifroe = new NIFRegistryOfferingEntry[]{};
        return anifroe;
    }

    @Deprecated
    public NIFRegistryOfferingEntry getInstalledProductByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledProductByOfferingLocationURIAndOffering(sOffering, uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public NIFRegistryOfferingEntry getInstalledWASSpecificProductByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getInstalledWASSpecificProductByOfferingLocationURI(uriOfferingLocation);
        }
        return null;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getPAKsForThisProduct(NIFRegistryOfferingEntry nifroeProduct) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getPAKArrayForThisProduct(nifroeProduct);
        }
        NIFRegistryPAKEntry[] anifrpeToBeReturned = new NIFRegistryPAKEntry[]{};
        return anifrpeToBeReturned;
    }

    @Deprecated
    public NIFRegistryOfferingEntry[] getProductsThatHaveThisPAK(NIFRegistryPAKEntry nifrpePAK) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getProductArrayThatHaveThisPAK(nifrpePAK);
        }
        NIFRegistryOfferingEntry[] anifroeToBeReturned = new NIFRegistryOfferingEntry[]{};
        return anifroeToBeReturned;
    }

    public URI getNIFRegistryURI() throws IOException, URISyntaxException {
        return this.getNIFRegistryURI(false);
    }

    public URI getNIFRegistryURI(boolean bLoadRegistryPathFromPropertyFile) throws IOException, URISyntaxException {
        String sMsg = null;
        if (this.m_uriNIFRegistryURICache == null) {
            if (!bLoadRegistryPathFromPropertyFile) {
                String sInstallType = NIFConstants.getProperty("com.ibm.was.process.type");
                if (sInstallType.equals("uninstall")) {
                    this.m_sNIFRegistryPath = this.loadNIFRegistryLocationPath();
                    sMsg = "Load nifregistry location path when uninstall.";
                    Logr.debug(sMsg);
                } else {
                    this.m_sNIFRegistryPath = NIFRegistry.getNIFRegistryPath(null, this.getParamValue(S_REGISTRYNAME_PARAM));
                    sMsg = "Use normal algorithm to get nifregistry path.";
                    Logr.debug(sMsg);
                }
            } else {
                this.m_sNIFRegistryPath = this.loadNIFRegistryLocationPath();
                sMsg = "Load nifregistry location path from property file.";
                Logr.debug(sMsg);
            }
            sMsg = "NIFRegistryPath: " + this.m_sNIFRegistryPath;
            Logr.debug(sMsg);
            this.m_uriNIFRegistryURICache = this.m_sNIFRegistryPath == null ? null : URIUtils.convertPathToDefaultTargetMachineFSURI(this.m_sNIFRegistryPath, this.getInstallToolkitBridge());
            sMsg = "NIFRegistryURI: " + this.m_uriNIFRegistryURICache;
            Logr.debug(sMsg);
        }
        return this.m_uriNIFRegistryURICache;
    }

    @Deprecated
    public boolean doesCurrentUserOwnCurrentProduct() throws URISyntaxException, IOException {
        String sNIFRegistryPathFromPropertiesFile = this.loadNIFRegistryLocationPath();
        if (sNIFRegistryPathFromPropertiesFile == null) {
            String sMsg = "Registry path in the property file is null";
            Logr.debug(sMsg);
            return true;
        }
        String sMsg = "Registry path from property file is: " + sNIFRegistryPathFromPropertiesFile;
        Logr.debug(sMsg);
        String sNIFRegistryPathCurrentUser = NIFRegistry.getNIFRegistryPath(null, this.getParamValue(S_REGISTRYNAME_PARAM));
        sMsg = "Registry path accessible by the current user is: " + sNIFRegistryPathCurrentUser;
        Logr.debug(sMsg);
        return NIFRegistryHelper.areThesePathsPointToTheSameLocation(sNIFRegistryPathFromPropertiesFile, sNIFRegistryPathCurrentUser, this.getInstallToolkitBridge());
    }

    public boolean isNIFRegistryEnabled() {
        return m_fIsNIFRegistryEnabled;
    }

    @Deprecated
    public void processCurrentOfferingRegistryEntry(String sInstallType) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        this.processCurrentOfferingRegistryEntry(sInstallType, null);
    }

    public void processCurrentOfferingRegistryEntry(String sInstallType, NIFRegistryOfferingEntry nifroeInstalledProductToBeUpgraded) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (this.shouldNIFRegistryBeUpdated()) {
            String sStdOutMsg = null;
            NIFRegistryOfferingEntry nifroeCurrentProduct = this.getNIFRegistryOfferingEntryOfCurrentProduct();
            if (sInstallType.equals("uninstall")) {
                NIFRegistryOfferingEntry nifroeFromNIFRegistry = this.getInstalledProductByOfferingLocationURIAndOffering(nifroeCurrentProduct.getOffering(), nifroeCurrentProduct.getOfferingLocationURI());
                if (nifroeFromNIFRegistry != null) {
                    m_nifregistrySingleton.purgeNotExistingRegistryEntriesOfThisProduct(nifroeFromNIFRegistry);
                    sStdOutMsg = "Uninstalling this PRODUCT:\nOfferingID: " + nifroeFromNIFRegistry.getOffering() + "\nInstallLocationURI: " + nifroeFromNIFRegistry.getOfferingLocationURI();
                } else {
                    m_nifregistrySingleton.purgeNotExistingRegistryEntriesOfThisProduct(nifroeCurrentProduct);
                    sStdOutMsg = "Uninstalling this PRODUCT although the offering entry does not exist in the registry file:\nOfferingID: " + nifroeCurrentProduct.getOffering() + "\nInstallLocationURI: " + nifroeCurrentProduct.getOfferingLocationURI();
                }
            } else if (sInstallType.equals(S_UPGRADE)) {
                m_nifregistrySingleton.performUpgrade(nifroeCurrentProduct, nifroeInstalledProductToBeUpgraded);
                sStdOutMsg = nifroeInstalledProductToBeUpgraded != null ? "Upgrading this product:\nFrom OfferingID: " + nifroeCurrentProduct.getOffering() + "\nTo OfferingID: " + nifroeInstalledProductToBeUpgraded.getOffering() : "Upgrading this WAS product:\nFrom OfferingID: " + nifroeCurrentProduct.getOffering();
            } else if (sInstallType.equals("install") || sInstallType.equals("maintenance") || sInstallType.equals(S_ADDFEATURE)) {
                if (!sInstallType.equals("install")) {
                    String sNewOffering = this.normalizeTrialNonTrialOfferingID(nifroeCurrentProduct.getOfferingLocationURI());
                    if (sNewOffering != null && !sNewOffering.equals(nifroeCurrentProduct.getOffering())) {
                        m_nifregistrySingleton.modifyOfferingFromPaksJustInstalled(nifroeCurrentProduct, sNewOffering);
                        sStdOutMsg = "Switched the product ID of the pak and the offering entry of this PRODUCT when applying maintenance or adding feature: \nFrom OfferingID: " + nifroeCurrentProduct.getOffering() + "\nTo OfferingID: " + sNewOffering + "\nInstall location: " + nifroeCurrentProduct.getOfferingLocationURI();
                        Logr.debug(sStdOutMsg);
                        nifroeCurrentProduct.setOffering(sNewOffering);
                    } else {
                        String sWASOfferingID = this.getMutuallyExclusiveOfferingByOfferingLocationURI(nifroeCurrentProduct.getOfferingLocationURI());
                        if (sWASOfferingID != null && m_nifregistrySingleton.isMutuallyExclusiveOfferingID(nifroeCurrentProduct.getOffering()) && !nifroeCurrentProduct.getOffering().equals(sWASOfferingID)) {
                            this.purgeRegistryEntriesOfCurrentProduct();
                            this.commitNIFRegistry(sInstallType);
                            sStdOutMsg = "Applying maintenance or adding feature or doing slip install to this PRODUCT: \nFrom OfferingID: " + nifroeCurrentProduct.getOffering() + "\nTo OfferingID: " + sWASOfferingID + "\nInstall location: " + nifroeCurrentProduct.getOfferingLocationURI();
                            Logr.debug(sStdOutMsg);
                            Object[] asParams = new String[]{nifroeCurrentProduct.getOffering(), NIFRegistryHelper.normalizePathFromURI(nifroeCurrentProduct.getOfferingLocationURI()), sWASOfferingID};
                            String sExceptionMessage = PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_ATTEMPT_INSTALL_WAS_INSTANCE_ON_LOCATION_WITH_WAS_INSTALLED_ERROR_MSG_KEY, (Object[])asParams);
                            throw new NIFException(sExceptionMessage);
                        }
                    }
                } else {
                    if (m_nifregistrySingleton.isMutuallyExclusiveOfferingID(nifroeCurrentProduct.getOffering()) && this.getMutuallyExclusiveOfferingByOfferingLocationURI(nifroeCurrentProduct.getOfferingLocationURI()) != null && !nifroeCurrentProduct.getOffering().equals(this.getMutuallyExclusiveOfferingByOfferingLocationURI(nifroeCurrentProduct.getOfferingLocationURI()))) {
                        this.purgeRegistryEntriesOfCurrentProduct();
                        this.commitNIFRegistry(sInstallType);
                        sStdOutMsg = "Installing this PRODUCT:\nFrom OfferingID: " + nifroeCurrentProduct.getOffering() + "\nTo OfferingID: " + this.getMutuallyExclusiveOfferingByOfferingLocationURI(nifroeCurrentProduct.getOfferingLocationURI()) + "\nInstall location: " + nifroeCurrentProduct.getOfferingLocationURI();
                        Logr.debug(sStdOutMsg);
                        Object[] asParams = new String[]{nifroeCurrentProduct.getOffering(), NIFRegistryHelper.normalizePathFromURI(nifroeCurrentProduct.getOfferingLocationURI()), this.getMutuallyExclusiveOfferingByOfferingLocationURI(nifroeCurrentProduct.getOfferingLocationURI())};
                        String sExceptionMessage = PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_ATTEMPT_INSTALL_WAS_INSTANCE_ON_LOCATION_WITH_WAS_INSTALLED_ERROR_MSG_KEY, (Object[])asParams);
                        throw new NIFException(sExceptionMessage);
                    }
                    if (this.getInstalledProductByOfferingLocationURIAndOffering(nifroeCurrentProduct.getOffering(), nifroeCurrentProduct.getOfferingLocationURI()) != null) {
                        sStdOutMsg = "Warning: this offering being processed exists in the install registry file already: \nOfferingID: " + nifroeCurrentProduct.getOffering() + "\nInstall location: " + nifroeCurrentProduct.getOfferingLocationURI() + "\nIf this method call is by SettleNIFRegistryAction bean then this warning message can be ignored.";
                        Logr.debug(sStdOutMsg);
                    }
                }
                m_nifregistrySingleton.performInstallMaintenanceAddFeature(nifroeCurrentProduct);
                sStdOutMsg = "Installing, adding feature, or doing maintenance to this PRODUCT:\nOfferingID: " + nifroeCurrentProduct.getOffering() + "\nInstallLocationURI: " + nifroeCurrentProduct.getOfferingLocationURI();
            }
            if (sStdOutMsg != null) {
                Logr.debug(sStdOutMsg);
            }
            this.commitNIFRegistry(sInstallType);
        }
    }

    public void processThisPAKRegistryEntry(String sPAKName, String sBackupPakLocationURI, boolean bIsUnInstall) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (this.shouldNIFRegistryBeUpdated()) {
            Logr.debug("Received current pak uri: " + sBackupPakLocationURI);
            URI uriCurrentBackupPakLocation = new URI(sBackupPakLocationURI);
            NIFRegistryPAKEntry nifrpeCurrentPAK = null;
            String sStdOutMsg = null;
            NIFRegistryPAKEntry nifrpeFromNIFRegistry = this.getInstalledPAKByPAKLocationURI(uriCurrentBackupPakLocation);
            if (nifrpeFromNIFRegistry != null) {
                m_nifregistrySingleton.removeRegistryEntryFromNIFRegistry(nifrpeFromNIFRegistry);
                sStdOutMsg = "Uninstalling this PAK:\nPAK Name: " + nifrpeFromNIFRegistry.getNIFPackageName() + "\nBackupPakLocationURI: " + nifrpeFromNIFRegistry.getBackupPakLocationURI() + "\nOfferingID: " + nifrpeFromNIFRegistry.getOffering();
            } else {
                Logr.debug("The Pak is null.");
                sStdOutMsg = "Uninstalling this PAK:The PAK does not exist in the registry.";
            }
            Logr.debug(sStdOutMsg);
            if (!bIsUnInstall) {
                String sOffering = this.getProductOfferingOverride();
                String sCurrentOfferingLocation = ProductPlugin.getCurrentProductInstallRoot();
                Logr.debug("Received current install root: " + sCurrentOfferingLocation);
                URI uriCurrentOfferingLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(sCurrentOfferingLocation, this.getInstallToolkitBridge());
                Logr.debug("Converted URI: " + uriCurrentOfferingLocation);
                nifrpeCurrentPAK = new NIFRegistryPAKEntry(sPAKName, uriCurrentBackupPakLocation, sOffering, uriCurrentOfferingLocation);
                Logr.debug("processThisPAKRegistryEntry: Add pak with Offering: " + nifrpeCurrentPAK.getOffering());
                Logr.debug("processThisPAKRegistryEntry: Add pak with install location: " + nifrpeCurrentPAK.getOfferingLocationPath());
                m_nifregistrySingleton.addRegistryEntryToNIFRegistry(nifrpeCurrentPAK);
                sStdOutMsg = "Installing this PAK:\nPAK Name: " + nifrpeCurrentPAK.getNIFPackageName() + "\nBackupPakLocationURI: " + nifrpeCurrentPAK.getBackupPakLocationURI() + "\nOfferingID: " + nifrpeCurrentPAK.getOffering();
                Logr.debug(sStdOutMsg);
            }
            this.commitNIFRegistryChanges();
        }
    }

    public void purgeRegistryEntriesOfCurrentProduct() throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            NIFRegistryOfferingEntry nifroeCurrentProduct = this.getNIFRegistryOfferingEntryOfCurrentProduct();
            this.purgeRegistryEntriesOfThisProduct(nifroeCurrentProduct);
        }
    }

    public void purgeRegistryEntriesOfThisProduct(NIFRegistryOfferingEntry nifroeThis) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled) {
            m_nifregistrySingleton.purgeRegistryEntriesOfThisProduct(nifroeThis);
        }
    }

    public void commitNIFRegistry(String sInstallType) {
        if (m_fIsNIFRegistryEnabled && m_nifregistrySingleton.hasRegistryChangedSinceLastCommit()) {
            try {
                this.commitNIFRegistryChanges();
            }
            catch (Exception e) {
                Logr.warn("NIFRegistryPlugin", "commitNIFRegistry", e.getMessage(), e);
                return;
            }
            if (sInstallType.equals("install")) {
                try {
                    this.saveNIFRegistryLocationPath(this.m_sNIFRegistryPath);
                    String sStdOutMsg = "Save registry location because of full install.";
                    Logr.debug(sStdOutMsg);
                }
                catch (Exception e) {
                    Logr.warn("NIFRegistryPlugin", "commitNIFRegistry", e.getMessage(), e);
                }
            }
        }
    }

    private void commitNIFRegistryChanges() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fIsNIFRegistryEnabled && m_nifregistrySingleton.hasRegistryChangedSinceLastCommit()) {
            String sStdOutMsg = "Commit registry changes.";
            this.readNIFRegistry();
            m_nifregistrySingleton.commitNIFRegistry();
            this.writeNIFRegistryDocument(m_nifregistrySingleton.getNIFRegistryDocument());
            Logr.debug(sStdOutMsg);
        }
    }

    private String getProductOfferingOverride() {
        String sProductOfferingOverride = this.getParamValue(S_PRODUCTIDOVERRIDE_PARAM);
        if (sProductOfferingOverride != null && !sProductOfferingOverride.equalsIgnoreCase(S_NULL_STRING) && !sProductOfferingOverride.equals("")) {
            return sProductOfferingOverride;
        }
        return ProductPlugin.getCurrentProductOffering();
    }

    private String normalizeTrialNonTrialOfferingID(URI uriInstallRoot) throws NIFException {
        String sCurrentOfferingID = ProductPlugin.getCurrentProductOffering();
        Logr.debug("Current offering ID: " + sCurrentOfferingID);
        String sExistingWASOfferingID = null;
        String sStdOutMsg = null;
        try {
            sExistingWASOfferingID = this.getWASSpecificOfferingByOfferingLocationURI(uriInstallRoot);
            Logr.debug("Existing WAS offering ID: " + sExistingWASOfferingID);
        }
        catch (NIFException nife) {
            Logr.warn("NIFRegistryPlugin", "normalizeTrialNonTrialOfferingID", nife.getMessage(), nife);
            throw nife;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sExistingWASOfferingID != null && NIFRegistryHelper.isWASOfferingID(sCurrentOfferingID)) {
            if ((sExistingWASOfferingID.equals(S_OFFERING_ID_BASE) || sExistingWASOfferingID.equals(S_OFERING_ID_BASETRIAL)) && (sCurrentOfferingID.equals(S_OFFERING_ID_BASE) || sCurrentOfferingID.equals(S_OFERING_ID_BASETRIAL))) {
                sStdOutMsg = "Normalize product ID from: " + sCurrentOfferingID + " to: " + sExistingWASOfferingID;
                Logr.debug(sStdOutMsg);
                return sExistingWASOfferingID;
            }
            if ((sExistingWASOfferingID.equals(S_OFFERING_ID_EXPRESS) || sExistingWASOfferingID.equals(S_OFFERING_ID_EXPRESSTRIAL)) && (sCurrentOfferingID.equals(S_OFFERING_ID_EXPRESS) || sCurrentOfferingID.equals(S_OFFERING_ID_EXPRESSTRIAL))) {
                sStdOutMsg = "Normalize product ID from: " + sCurrentOfferingID + " to: " + sExistingWASOfferingID;
                Logr.debug(sStdOutMsg);
                return sExistingWASOfferingID;
            }
        }
        return sCurrentOfferingID;
    }

    private boolean doesNIFRegistryFileExist() {
        String sStdOutMsg = null;
        if (this.m_uriNIFRegistryURICache != null) {
            block4: {
                try {
                    FileSystemEntry fseNIFRegistry = new FileSystemEntry(this.m_uriNIFRegistryURICache, this.getInstallToolkitBridge());
                    if (!fseNIFRegistry.exists() || fseNIFRegistry.isDirectory()) break block4;
                    sStdOutMsg = S_LOG_MESSAGE_REGISTRY_FILE_EXISTS_UNDER_LOCATION_URI + this.m_uriNIFRegistryURICache;
                    Logr.debug(sStdOutMsg);
                    return true;
                }
                catch (Exception e) {
                    sStdOutMsg = S_LOG_MESSAGE_CHECK_REGISTRY_FILE_EXISTENCE_ERROR_UNDER_LOCATION_URI + this.m_uriNIFRegistryURICache + "\nDue to: " + e.getMessage();
                    Logr.debug(sStdOutMsg);
                    return false;
                }
            }
            sStdOutMsg = S_LOG_MESSAGE_REGISTRY_FILE_DOES_NOT_EXISTS_UNDER_LOCATION_URI + this.m_uriNIFRegistryURICache;
            Logr.debug(sStdOutMsg);
            return false;
        }
        sStdOutMsg = S_LOG_MESSAGE_NULL_REGISTRY_URI;
        Logr.debug(sStdOutMsg);
        return false;
    }

    private boolean isThisOfferingEntryValid(NIFRegistryOfferingEntry thisOfferingEntry) {
        URI thisInstallLocationURI = null;
        try {
            thisInstallLocationURI = URIUtils.convertPathToDefaultTargetMachineFSURI(thisOfferingEntry.getOfferingLocationPath(), this.getInstallToolkitBridge());
        }
        catch (URISyntaxException e) {
            String sStdOutMsg = "Invalid offering location: " + thisOfferingEntry.getOfferingLocationPath() + " with offering ID: " + thisOfferingEntry.getOffering() + " that causes URISyntaxException.";
            Logr.debug(sStdOutMsg);
            return false;
        }
        NIFRegistryDirectory thisNIFRegistryDirInstance = NIFRegistryDirectory.getNIFRegistryDirectoryInstance(thisInstallLocationURI, this.getInstallToolkitBridge());
        if (thisNIFRegistryDirInstance.getProductInfo(NIFRegistryHelper.normalizedTrialToNonTrialProductID(thisOfferingEntry.getOffering())) == null) {
            String sStdOutMsg = "Invalid offering entry to be cleanup: offering ID: " + thisOfferingEntry.getOffering() + " install location: " + thisOfferingEntry.getOfferingLocationPath();
            Logr.debug(sStdOutMsg);
            return false;
        }
        return true;
    }

    private void cleanupInvalidInstallLocation() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (m_fCleanupInvalidLocationCalledBefore) {
            return;
        }
        Vector<NIFRegistryOfferingEntry> listOfInvalidOffering = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry[] allOfferingEntries = this.getInstalledProducts();
        int i = 0;
        while (allOfferingEntries != null && i < allOfferingEntries.length) {
            if (!this.isThisOfferingEntryValid(allOfferingEntries[i])) {
                listOfInvalidOffering.add(allOfferingEntries[i]);
            }
            ++i;
        }
        i = 0;
        while (i < listOfInvalidOffering.size()) {
            m_nifrpSingleton.purgeRegistryEntriesOfThisProduct((NIFRegistryOfferingEntry)listOfInvalidOffering.elementAt(i));
            ++i;
        }
        this.commitNIFRegistryChanges();
        m_fCleanupInvalidLocationCalledBefore = true;
    }

    public static void resetNIFRegistryPlugin() {
        if (m_nifrpSingleton != null) {
            NIFRegistryPlugin.m_nifrpSingleton.m_uriNIFRegistryURICache = null;
            m_nifregistrySingleton.resetNIFRegistry();
        }
    }

    protected String createExceptionMessage(Object nifre) {
        String sReturned = "";
        if (nifre.getClass().toString().equals(NIFRegistryOfferingEntry.class.toString())) {
            NIFRegistryOfferingEntry nifroe = (NIFRegistryOfferingEntry)nifre;
            sReturned = "productid=" + nifroe.getOffering() + S_ATTRIBUTE_SEPARATOR + "installrooturi" + S_EQUALS + nifroe.getOfferingLocationURI().toString() + S_ATTRIBUTE_SEPARATOR + "version" + S_EQUALS + nifroe.getOfferingVersion();
        } else {
            NIFRegistryPAKEntry nifrpe = (NIFRegistryPAKEntry)nifre;
            sReturned = "name=" + nifrpe.getNIFPackageName() + S_ATTRIBUTE_SEPARATOR + "paklocationuri" + S_EQUALS + nifrpe.getBackupPakLocationURI().toString() + S_ATTRIBUTE_SEPARATOR + "installrooturi" + S_EQUALS + nifrpe.getOfferingLocationURI().toString();
        }
        return sReturned;
    }

    protected NIFRegistryOfferingEntry getNIFRegistryOfferingEntryOfCurrentProduct() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (!this.isCurrentProductPluginValid()) {
            String sStdOutMsg = "Product plugin is not valid.";
            Logr.debug(sStdOutMsg);
            return null;
        }
        String sCurrentOfferingLocation = ProductPlugin.getCurrentProductInstallRoot();
        URI uriCurrentOfferingLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(sCurrentOfferingLocation, this.getInstallToolkitBridge());
        String sCurrentOffering = this.getProductOfferingOverride();
        String sCurrentOfferingLastVisited = NIFConstants.getCurrentTimestamp();
        String sCurrentOfferingVersion = ProductPlugin.getCurrentProductVersion();
        NIFRegistryOfferingEntry nifroeCurrentProduct = new NIFRegistryOfferingEntry(sCurrentOffering, uriCurrentOfferingLocation, sCurrentOfferingLastVisited, sCurrentOfferingVersion);
        return nifroeCurrentProduct;
    }

    private String getMutuallyExclusiveOfferingByOfferingLocationURI(URI uriOfferingLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (m_fIsNIFRegistryEnabled) {
            this.readNIFRegistry();
            return m_nifregistrySingleton.getMutuallyExclusiveOfferingByOfferingLocationURI(uriOfferingLocation);
        }
        return null;
    }

    protected void readNIFRegistry() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.readNIFRegistry(false);
    }

    protected void readNIFRegistry(boolean bLoadRegistryPathFromPropertyFile) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        Logr.debug("readNIFRegistry: entry");
        URI uriCurrentNIFRegistryURI = this.getNIFRegistryURI(bLoadRegistryPathFromPropertyFile);
        Logr.debug("Current NIFRegistry URI: " + uriCurrentNIFRegistryURI);
        if (uriCurrentNIFRegistryURI != null) {
            FileSystemEntry fseNIFRegistry = new FileSystemEntry(uriCurrentNIFRegistryURI, this.getInstallToolkitBridge());
            if (fseNIFRegistry.exists() && !fseNIFRegistry.isDirectory()) {
                Logr.debug("ReadNIFRegistryURI: NIFRegistry URI is: " + uriCurrentNIFRegistryURI);
                InputStream fileinputstreamNIFRegistryFile = fseNIFRegistry.getInputStream();
                try {
                    m_nifregistrySingleton = NIFRegistry.getNIFRegistryInstance(fileinputstreamNIFRegistryFile);
                    fileinputstreamNIFRegistryFile.close();
                }
                catch (SAXException sae) {
                    fileinputstreamNIFRegistryFile.close();
                    URI uriCorruptNIFRegistry = new URI(uriCurrentNIFRegistryURI + S_CORRUPT_NIFREGISTRY_EXTENSION);
                    Logr.debug("ReadNIFRegistryURI: Corrupted NIFRegistry URI is: " + uriCorruptNIFRegistry);
                    FileSystemEntry fileCorruptedNIFRegistry = new FileSystemEntry(uriCorruptNIFRegistry, this.getInstallToolkitBridge());
                    try {
                        if (fileCorruptedNIFRegistry.exists()) {
                            fileCorruptedNIFRegistry.delete();
                        }
                        fseNIFRegistry.moveTo(fileCorruptedNIFRegistry);
                        Logr.debug("Rename by FSE is successful");
                    }
                    catch (Exception e) {
                        Logr.warn("NIFRegistryPlugin", "readNIFRegistry", e.getMessage(), e);
                    }
                    m_nifregistrySingleton = NIFRegistry.getNIFRegistryInstance(null);
                }
            } else {
                Logr.debug("ReadNIFRegistryURI: NIFRegistry does not exists but URI is not null.");
                m_nifregistrySingleton = NIFRegistry.getNIFRegistryInstance(null);
            }
        } else {
            Logr.debug("ReadNIFRegistryURI: NIFRegistryURI is null.");
            m_nifregistrySingleton = NIFRegistry.getNIFRegistryInstance(null);
        }
    }

    protected void writeNIFRegistryDocument(Document documentRegistry) {
        String sStdOutMsg;
        URI uriNIFRegistryLocationURI = null;
        try {
            uriNIFRegistryLocationURI = this.getNIFRegistryURI();
        }
        catch (Exception e) {
            sStdOutMsg = "Can not get NIFRegistry URI location when trying to update/write install registry file due to the following reason:\n";
            Logr.debug(sStdOutMsg);
        }
        if (uriNIFRegistryLocationURI != null) {
            try {
                FileSystemEntry fseNIFRegistry = new FileSystemEntry(uriNIFRegistryLocationURI, this.getInstallToolkitBridge());
                XMLUtils.saveDocument(documentRegistry, fseNIFRegistry);
            }
            catch (IOException ioe) {
                sStdOutMsg = "Can not update install registry file under: " + uriNIFRegistryLocationURI.getPath() + "due to the following reason:\n";
                Logr.debug(sStdOutMsg);
            }
        }
    }

    protected String loadNIFRegistryLocationPath() throws IOException, URISyntaxException {
        String sInstallRoot = ProductPlugin.getCurrentProductInstallRoot();
        String sNIFRegistryLocationPath = String.valueOf(sInstallRoot) + "/properties/" + S_NIFREGISTRY_PROPERTY_FILE_NAME;
        FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sNIFRegistryLocationPath, this.getInstallToolkitBridge());
        if (!fseFilePath.exists() || !fseFilePath.readable()) {
            return null;
        }
        InputStream propFileInputStream = fseFilePath.getInputStream();
        Properties nifregistryProps = new Properties();
        nifregistryProps.load(propFileInputStream);
        propFileInputStream.close();
        Logr.debug("Loaded nifregistry path from: " + sNIFRegistryLocationPath);
        return nifregistryProps.getProperty(S_NIFREGISTRY_LOCATION_PROPERTY_NAME);
    }

    protected void saveNIFRegistryLocationPath(String sInstallRoot, String sNIFRegistryPath) throws IOException, URISyntaxException, NIFException {
        String sNIFRegistryPropertyFilePath = String.valueOf(sInstallRoot) + "/properties/" + S_NIFREGISTRY_PROPERTY_FILE_NAME;
        FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sNIFRegistryPropertyFilePath, this.getInstallToolkitBridge());
        FileSystemEntry fseFileParent = fseFilePath.getParent();
        if (!fseFileParent.exists()) {
            fseFileParent.mkdirs();
        }
        OutputStream propFileOutputStream = fseFilePath.getOutputStream();
        Properties nifregistryProps = new Properties();
        nifregistryProps.setProperty(S_NIFREGISTRY_LOCATION_PROPERTY_NAME, sNIFRegistryPath);
        nifregistryProps.store(propFileOutputStream, S_NIFREGISTRY_PROPERTY_FILE_DESC);
        propFileOutputStream.close();
        if (PlatformConstants.isOS400Install()) {
            throw new NIFException(new Exception(PakCoreMessages.PAK_CORE_S_OS400_IS_NOT_SUPPORTED));
        }
        fseFilePath.setPermissions(700);
        String sMsg = "Saved nifregistry path at location: " + sInstallRoot + " to: " + sNIFRegistryPropertyFilePath;
        Logr.debug(sMsg);
    }

    protected void saveNIFRegistryLocationPath(String sNIFRegistryPath) throws IOException, URISyntaxException, NIFException {
        String sInstallRoot = ProductPlugin.getCurrentProductInstallRoot();
        this.saveNIFRegistryLocationPath(sInstallRoot, sNIFRegistryPath);
    }

    protected boolean isCurrentProductPluginValid() {
        try {
            ProductPlugin.getCurrentProductInstallRoot();
        }
        catch (NullPointerException npe) {
            Logr.warn("NIFRegistryPlugin", "isCurrentProductPluginValid", npe.getMessage(), npe);
            return false;
        }
        return true;
    }

    protected boolean shouldNIFRegistryBeUpdated() {
        if (!m_fIsNIFRegistryEnabled) {
            return false;
        }
        String sInstallType = NIFConstants.getProperty("com.ibm.was.process.type");
        if (PlatformConstants.isOS400Install() && sInstallType != null && sInstallType.equals("maintenance")) {
            if (this.isCurrentProductPluginValid()) {
                String sCurrentOfferingLocation = ProductPlugin.getCurrentProductInstallRoot();
                if (sCurrentOfferingLocation != null && sCurrentOfferingLocation.toLowerCase().startsWith(S_OS400_V6_PRODUCTLOCATION_ROOT)) {
                    Logr.debug("Current offering location: " + sCurrentOfferingLocation);
                    Logr.debug(S_LOG_MESSAGE_SKIP_UPDATE_REGISTRY_V6_OS400_MAINTENANCE);
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    protected void mergeNIFRegistryForVista() {
        String sInstallType = NIFConstants.getProperty("com.ibm.was.process.type");
        String sNIFRegistryFileName = this.getParamValue(S_REGISTRYNAME_PARAM);
        String sStdOutMsg = null;
        if (!(sInstallType.equals("uninstall") || PlatformConstants.isOS400RemoteInstall() || !PlatformConstants.isCurrentPlatformWindowsVista() || NIFRegistry.canCurrentUserAccessRootNIFRegistry(sNIFRegistryFileName) || m_fMergeRegistryCalledBefore)) {
            m_fMergeRegistryCalledBefore = true;
            sStdOutMsg = S_LOG_MESSAGE_NON_ADMIN_INSTALL_APPLY_MAINTENANCE_UPGRADE_VISTA;
            Logr.debug(sStdOutMsg);
            String sVistaVFSNIFRegistryPath = String.valueOf(NIFRegistry.getVistaVFSWindowsPath()) + "/" + sNIFRegistryFileName;
            String sRootNIFRegistryPath = NIFRegistry.getNIFRegistryPathForRootUser(sNIFRegistryFileName);
            try {
                FileSystemEntry fseVistaNIFRegistry = URIUtils.convertPathToDefaultTargetMachineFSE(sVistaVFSNIFRegistryPath, this.getInstallToolkitBridge());
                FileSystemEntry fseRootNIFRegistry = URIUtils.convertPathToDefaultTargetMachineFSE(sRootNIFRegistryPath, this.getInstallToolkitBridge());
                if (fseVistaNIFRegistry.exists()) {
                    URI uriNIFRegistryNonRoot = this.m_uriNIFRegistryURICache;
                    NIFRegistryOfferingEntry[] anifroeFromUserHomeRegistry = m_nifregistrySingleton.getAllInstalledProducts();
                    LinkedHashMap lhmEntriesFromUserHomeReg = this.createNIFRegistryEntriesHashMap(anifroeFromUserHomeRegistry);
                    this.reloadNIFRegistry(fseVistaNIFRegistry.getURI());
                    sStdOutMsg = S_LOG_MESSAGE_REFRESH_REGISTRY_VFS + sVistaVFSNIFRegistryPath;
                    Logr.debug(sStdOutMsg);
                    NIFRegistryOfferingEntry[] anifroeFromVFS = m_nifregistrySingleton.getAllInstalledProducts();
                    LinkedHashMap lhmEntriesFromVFSReg = this.createNIFRegistryEntriesHashMap(anifroeFromVFS);
                    String sVistaVFSNIFRegistryTempPath = String.valueOf(sVistaVFSNIFRegistryPath) + ".temp";
                    FileSystemEntry fseVistaNIFRegistryTemp = URIUtils.convertPathToDefaultTargetMachineFSE(sVistaVFSNIFRegistryTempPath, this.getInstallToolkitBridge());
                    if (fseVistaNIFRegistryTemp.exists()) {
                        fseVistaNIFRegistryTemp.delete();
                    }
                    fseVistaNIFRegistry.renameTo(fseVistaNIFRegistryTemp);
                    if (fseRootNIFRegistry.exists()) {
                        this.reloadNIFRegistry(fseRootNIFRegistry.getURI());
                        sStdOutMsg = S_LOG_MESSAGE_REFRESH_REGISTRY_ROOT + sRootNIFRegistryPath;
                        Logr.debug(sStdOutMsg);
                        NIFRegistryOfferingEntry[] anifroeFromRoot = m_nifregistrySingleton.getAllInstalledProducts();
                        LinkedHashMap lhmEntriesFromRootReg = this.createNIFRegistryEntriesHashMap(anifroeFromRoot);
                        NIFRegistryMergerRemoveDuplicates nifrmrdThis = new NIFRegistryMergerRemoveDuplicates(lhmEntriesFromVFSReg, lhmEntriesFromRootReg, this.getInstallToolkitBridge());
                        lhmEntriesFromVFSReg = nifrmrdThis.getMergedRegistry();
                    }
                    NIFRegistryMergerDelta nifrmThis = new NIFRegistryMergerDelta(lhmEntriesFromUserHomeReg, lhmEntriesFromVFSReg, this.getInstallToolkitBridge());
                    this.reloadNIFRegistry(uriNIFRegistryNonRoot);
                    sStdOutMsg = S_LOG_MESSAGE_REFRESH_REGISTRY_NONROOT + uriNIFRegistryNonRoot.getPath();
                    Logr.debug(sStdOutMsg);
                    this.updateUserHomeRegistry(nifrmThis);
                    this.updateNIFRegistryPropertiesAfterMerge(nifrmThis, this.m_sNIFRegistryPath);
                    fseVistaNIFRegistryTemp.delete();
                }
            }
            catch (Exception e) {
                Logr.warn("NIFRegistryPlugin", "mergeNIFRegistryForVista", e.getMessage(), e);
            }
        }
    }

    protected void reloadNIFRegistry(URI uriRegistryLocation) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.m_uriNIFRegistryURICache = uriRegistryLocation;
        m_nifregistrySingleton.resetNIFRegistry();
        this.readNIFRegistry();
    }

    @Deprecated
    protected LinkedHashMap createNIFRegistryEntriesHashMap(NIFRegistryOfferingEntry[] anifroe) {
        LinkedHashMap lhmReturn = new LinkedHashMap();
        try {
            NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe;
            int n = anifroe.length;
            int n2 = 0;
            while (n2 < n) {
                NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
                NIFRegistryPAKEntry[] anirpeFromUserHomeReg = m_nifregistrySingleton.getPAKArrayForThisProduct(element);
                Vector<NIFRegistryPAKEntry> vnifrpeFromUserReg = new Vector<NIFRegistryPAKEntry>();
                NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = anirpeFromUserHomeReg;
                int n3 = anirpeFromUserHomeReg.length;
                int n4 = 0;
                while (n4 < n3) {
                    NIFRegistryPAKEntry element2 = nIFRegistryPAKEntryArray[n4];
                    vnifrpeFromUserReg.add(element2);
                    ++n4;
                }
                lhmReturn.put(element, vnifrpeFromUserReg);
                ++n2;
            }
        }
        catch (Exception e) {
            Logr.warn("NIFRegistryPlugin", "createNIFRegistryEntriesHashMap", e.getMessage(), e);
        }
        return lhmReturn;
    }

    protected void updateUserHomeRegistry(NIFRegistryMergerDelta nifrmThis) throws ParserConfigurationException, SAXException, URISyntaxException {
        Vector vnifroeAddToUserHomeReg = nifrmThis.getRegistryObjectVectorAddToCorrectRegistry();
        int i = 0;
        while (i < vnifroeAddToUserHomeReg.size()) {
            m_nifregistrySingleton.addRegistryEntryToNIFRegistry(vnifroeAddToUserHomeReg.get(i));
            ++i;
        }
        Vector vnifroeRemoveFromUserHomeReg = nifrmThis.getRegistryObjectVectorRemoveFromCorrectRegistry();
        int i2 = 0;
        while (i2 < vnifroeRemoveFromUserHomeReg.size()) {
            m_nifregistrySingleton.removeRegistryEntryFromNIFRegistry(vnifroeRemoveFromUserHomeReg.get(i2));
            ++i2;
        }
        String sStdOutMsg = "Commit registry changes in updateUserHomeRegistry().";
        m_nifregistrySingleton.commitNIFRegistry();
        this.writeNIFRegistryDocument(m_nifregistrySingleton.getNIFRegistryDocument());
        Logr.debug(sStdOutMsg);
    }

    protected void updateNIFRegistryPropertiesAfterMerge(NIFRegistryMergerDelta nifrmThis, String sNIFRegistryPath) throws NIFException {
        String sMsg = null;
        HashSet<String> setInstallLocations = new HashSet<String>();
        LinkedHashMap lhmMergedRegistry = nifrmThis.getMergedRegistry();
        Vector vOfferingList = new Vector(lhmMergedRegistry.keySet());
        int i = 0;
        while (i < vOfferingList.size()) {
            NIFRegistryOfferingEntry nifroeThis = (NIFRegistryOfferingEntry)vOfferingList.get(i);
            if (!setInstallLocations.contains(nifroeThis.getOfferingLocationPath())) {
                sMsg = "The nifregistry property file under this location will be modified: " + nifroeThis.getOfferingLocationPath() + " and the new registry property is: " + this.m_sNIFRegistryPath;
                Logr.debug(sMsg);
                setInstallLocations.add(nifroeThis.getOfferingLocationPath());
            }
            ++i;
        }
        for (String sInstallRoot : setInstallLocations) {
            try {
                this.saveNIFRegistryLocationPath(sInstallRoot, this.m_sNIFRegistryPath);
            }
            catch (URISyntaxException e) {
                sMsg = "Cannot save registry location: " + sInstallRoot;
                Logr.debug(sMsg);
            }
            catch (IOException e) {
                sMsg = "Cannot modify the property file in this location:" + sInstallRoot;
                Logr.debug(sMsg);
            }
        }
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }
}

