/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.net.URI;
import java.net.URISyntaxException;

public class NIFRegistryHelper {
    private static final String S_EMPTY = "";
    private static final char S_WINDOWS_FILE_SEPARATOR = '\\';
    private static final char S_LINUX_FILE_SEPARATOR = '/';
    private static final String S_OS400_CASESENSITIVE_PATH_QOPENSYS = "/qopensys/";
    public static final String S_OFFERING_ID_ND = "ND";
    public static final String S_OFFERING_ID_BASE = "BASE";
    public static final String S_OFFERING_ID_BASETRIAL = "BASETRIAL";
    public static final String S_OFFERING_ID_EXPRESS = "EXPRESS";
    public static final String S_OFFERING_ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    public static final String S_OFFERING_ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String S_OFFERING_ID_CLIENT = "CLIENT";
    public static final String S_OFFERING_ID_PLUGIN = "PLG";
    public static final String S_OFFERING_ID_IHS = "IHS";
    public static final String S_OFFERING_ID_XD = "XD";
    public static final String S_OFFERING_ID_PME = "PME";
    public static final String S_OFFERING_ID_WBI = "WBI";
    public static final String S_OFFERING_ID_JDK = "JDK";
    public static final String S_OFFERING_ID_NDDMZ = "NDDMZ";
    public static final String S_OFFERING_ID_ZPMT = "ZPMT";

    public static boolean AreTheseURIsPointToSameLocation(URI uriSource, URI uriTarget) {
        if (uriSource == null || uriTarget == null) {
            return false;
        }
        if (PlatformConstants.isCurrentPlatformWindows() && !PlatformConstants.isOS400Install()) {
            return uriSource.getPath().equalsIgnoreCase(uriTarget.getPath());
        }
        if (PlatformConstants.isOS400Install()) {
            if (uriSource.getPath().toLowerCase().startsWith(S_OS400_CASESENSITIVE_PATH_QOPENSYS) && uriTarget.getPath().toLowerCase().startsWith(S_OS400_CASESENSITIVE_PATH_QOPENSYS)) {
                String sSourceChildPath = uriSource.getPath().substring(S_OS400_CASESENSITIVE_PATH_QOPENSYS.length());
                String sTargetChildPath = uriTarget.getPath().substring(S_OS400_CASESENSITIVE_PATH_QOPENSYS.length());
                return sSourceChildPath.equals(sTargetChildPath);
            }
            return uriSource.getPath().equalsIgnoreCase(uriTarget.getPath());
        }
        return uriSource.getPath().equals(uriTarget.getPath());
    }

    public static boolean areThesePathsPointToTheSameLocation(String sourcePath, String targetPath, InstallToolkitBridge itb) throws URISyntaxException {
        URI sourceURI = URIUtils.convertPathToURI(sourcePath, itb);
        URI targetURI = URIUtils.convertPathToURI(targetPath, itb);
        return NIFRegistryHelper.AreTheseURIsPointToSameLocation(sourceURI, targetURI);
    }

    public static URI normalizeLocationURI(URI uriLocation) throws URISyntaxException {
        if (uriLocation != null && PlatformConstants.isOS400Install()) {
            String sPathLocation = uriLocation.getPath();
            Logr.debug("Path location in normalizeLocation: " + sPathLocation);
            if (!sPathLocation.endsWith("/")) {
                sPathLocation = String.valueOf(sPathLocation) + "/";
            }
            URI uriCurrentLocation = new URI("file", S_EMPTY, sPathLocation, null, null);
            return uriCurrentLocation;
        }
        return uriLocation;
    }

    public static URI normalizeLocation(String sLocation) throws URISyntaxException {
        if (sLocation != null) {
            String sPathLocation = sLocation.replace('\\', '/');
            Logr.debug("Path location in normalizeLocation: " + sPathLocation);
            if (!sPathLocation.startsWith("/")) {
                sPathLocation = "/" + sPathLocation;
            }
            if (!sPathLocation.endsWith("/")) {
                sPathLocation = String.valueOf(sPathLocation) + "/";
            }
            URI uriCurrentLocation = new URI("file", S_EMPTY, sPathLocation, null, null);
            return uriCurrentLocation;
        }
        return null;
    }

    public static String normalizePath(String sPath) {
        if (sPath != null && !sPath.equals(S_EMPTY)) {
            sPath = sPath.replace('\\', '/');
            Logr.debug("Path location in normalizeLocation: " + sPath);
            if (!sPath.startsWith("/")) {
                sPath = "/" + sPath;
            }
            if (!sPath.endsWith("/")) {
                sPath = String.valueOf(sPath) + "/";
            }
        }
        return sPath;
    }

    public static String normalizePathNoEndingSlash(String sPath) {
        if (sPath != null && !sPath.equals(S_EMPTY)) {
            sPath = sPath.replace('\\', '/');
            Logr.debug("Path location in normalizeLocation: " + sPath);
            if (sPath.length() > 1 && sPath.endsWith("/")) {
                sPath = sPath.substring(0, sPath.length() - 1);
            }
        }
        return sPath;
    }

    public static String normalizePathFromURI(URI uriInput) {
        if (uriInput != null && uriInput.getPath() != null) {
            String sPath = S_EMPTY;
            sPath = PlatformConstants.isCurrentPlatformWindows() && !PlatformConstants.isOS400RemoteInstall() ? NIFRegistryHelper.normalizePath(uriInput.getPath()).substring(1).replace('/', '\\') : NIFRegistryHelper.normalizePath(uriInput.getPath());
            return sPath;
        }
        return null;
    }

    public static boolean isWASOfferingID(String sID) {
        return S_OFFERING_ID_ND.equalsIgnoreCase(sID) || S_OFFERING_ID_BASE.equalsIgnoreCase(sID) || S_OFFERING_ID_BASETRIAL.equalsIgnoreCase(sID) || S_OFFERING_ID_EXPRESS.equalsIgnoreCase(sID) || S_OFFERING_ID_EXPRESSTRIAL.equalsIgnoreCase(sID);
    }

    public static String normalizedTrialToNonTrialProductID(String id) {
        if (S_OFFERING_ID_BASETRIAL.equalsIgnoreCase(id)) {
            return S_OFFERING_ID_BASE;
        }
        if (S_OFFERING_ID_EXPRESSTRIAL.equalsIgnoreCase(id)) {
            return S_OFFERING_ID_EXPRESS;
        }
        return id;
    }
}

